/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wtp.jsf.facesconfig.editor.common.CommonPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogs.TreeViewerSelectionDialog;
import org.eclipse.wtp.jsf.facesconfig.editor.common.logging.Logger;
import org.eclipse.wtp.jsf.facesconfig.editor.common.utils.WebrootUtil;

public class CommonResourceDialog
extends TreeViewerSelectionDialog {
    private static Logger log;
    private IProject project = null;
    private String[] suffixs = null;
    private CommonResourceFilter filter = null;
    private String resourceDescription = null;
    private IFolder folder;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.common.dialogs.CommonResourceDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = CommonPlugin.getLogger(clazz);
    }

    public CommonResourceDialog(Shell parentShell, IProject project, int style) {
        super(parentShell, "", style);
        if (project == null) {
            throw new IllegalArgumentException("Argument(project) cannot be null");
        }
        this.project = project;
        this.setContentProvider(new ProjectFileDialogContentProvider());
        this.setLabelProvider(WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.filter = new CommonResourceFilter();
        this.setFilter(this.filter);
        this.setStatusMessage(this.getStatusMessage());
    }

    public CommonResourceDialog(Shell parentShell, IProject project) {
        this(parentShell, project, 0);
    }

    public CommonResourceDialog(Shell parentShell, IFolder folder, int style) {
        this(parentShell, folder == null ? null : folder.getProject(), style);
        this.folder = folder;
    }

    protected String getStatusMessage() {
        if (this.resourceDescription == null) {
            return "";
        }
        return this.resourceDescription;
    }

    protected Object findInputElement() {
        if (this.folder != null) {
            return new Object[]{this.folder};
        }
        return new Object[]{this.project};
    }

    protected boolean isValidSelection(Object selection) {
        if (selection instanceof Object[]) {
            int i = 0;
            int n = ((Object[])selection).length;
            while (i < n) {
                if (this.isValidElement(((Object[])selection)[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return this.isValidElement(selection);
    }

    private boolean isValidElement(Object selection) {
        if (selection instanceof IFile) {
            if (this.isSuffixBlank()) {
                return true;
            }
            if (this.suffixs != null && Arrays.asList(this.suffixs).contains(((IFile)selection).getFileExtension().toLowerCase())) {
                return true;
            }
        }
        return false;
    }

    public Object[] getResult() {
        Object[] objects = super.getResult();
        if (objects == null || objects.length == 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof IFile) {
                list.add(objects[i]);
            }
            ++i;
        }
        return list.toArray();
    }

    public void setSuffixs(String[] suffixs) {
        this.suffixs = this.convertTolowercase(suffixs);
        this.filter.setSuffixs(this.suffixs);
        this.setStatusMessage(this.getStatusMessage());
    }

    private String[] convertTolowercase(String[] suffixs) {
        if (suffixs != null) {
            String[] newSuffixs = new String[suffixs.length];
            int i = 0;
            while (i < suffixs.length) {
                newSuffixs[i] = suffixs[i].toLowerCase();
                ++i;
            }
            return newSuffixs;
        }
        return null;
    }

    public void setFilter(String[] suffixs, String sourceDescription) {
        this.setSuffixs(suffixs);
        this.setResourceDescription(sourceDescription);
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void setResourceDescription(String sourceDescription) {
        this.resourceDescription = sourceDescription;
        this.setStatusMessage(this.getStatusMessage());
    }

    private boolean isSuffixBlank() {
        boolean isSuffixBlank = false;
        if (this.suffixs == null) {
            isSuffixBlank = true;
        } else {
            int count = 0;
            int i = 0;
            int size = this.suffixs.length;
            while (i < size) {
                if (this.suffixs[i] != null && !"".equals(this.suffixs[i])) {
                    ++count;
                    break;
                }
                ++i;
            }
            if (count == 0) {
                isSuffixBlank = true;
            }
        }
        return isSuffixBlank;
    }

    class ProjectFileDialogContentProvider
    implements ITreeContentProvider {
        ProjectFileDialogContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object element) {
            IContainer container;
            if (element instanceof Object[]) {
                return (Object[])element;
            }
            if (element instanceof IContainer && (container = (IContainer)element).isAccessible()) {
                try {
                    return container.members();
                }
                catch (CoreException e) {
                    log.error("Error.ProjectFileDialogContentProvider.0", e);
                }
            }
            return new Object[0];
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class CommonResourceFilter
    extends ViewerFilter {
        private String[] filtersuffixs = null;
        Logger _log;
        static /* synthetic */ Class class$0;

        CommonResourceFilter() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.common.dialogs.CommonResourceDialog$CommonResourceFilter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this._log = CommonPlugin.getLogger(clazz);
        }

        public String[] getSuffixs() {
            return this.filtersuffixs;
        }

        public void setSuffixs(String[] suffixs) {
            this.filtersuffixs = suffixs;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                if (!WebrootUtil.isUnderWebContentFolder((IResource)file)) {
                    return false;
                }
                if (CommonResourceDialog.this.isSuffixBlank()) {
                    return true;
                }
                if (file.getFileExtension() == null) return false;
                if (!Arrays.asList(this.filtersuffixs).contains(file.getFileExtension().toLowerCase())) return false;
                return true;
            }
            if (!(element instanceof IContainer)) return false;
            if (!((IContainer)element).isAccessible()) {
                return false;
            }
            if (element instanceof IProject) {
                return true;
            }
            if (!(element instanceof IFolder)) return false;
            IContainer container = (IContainer)element;
            try {
                IResource[] members = container.members();
                int i = 0;
                while (true) {
                    if (i >= members.length) {
                        return false;
                    }
                    if (this.select(viewer, members[i].getParent(), members[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                this._log.error("Error.ProjectFileDialogContentProvider.0", e);
                return false;
            }
        }
    }
}

