/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wtp.jsf.facesconfig.editor.common.CommonPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.common.logging.Logger;

public class OverviewSection
extends SectionPart {
    private static Logger log;
    private String editorId;
    private FormToolkit toolkit;
    private ImageHyperlink helpImage;
    private Composite textClient;
    private String helpContextId;
    private String helpTooltip;
    protected FormEditor editor;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils.OverviewSection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = CommonPlugin.getLogger(clazz);
    }

    public OverviewSection(String editorId, IManagedForm managedForm, FormToolkit toolkit) {
        this(editorId, managedForm, toolkit, null, null);
    }

    public OverviewSection(String editorId, IManagedForm managedForm, FormToolkit toolkit, String helpContextId, String helpTooltip) {
        super(managedForm.getForm().getBody(), toolkit, 384);
        super.initialize(managedForm);
        this.editorId = editorId;
        this.toolkit = toolkit;
        this.helpContextId = helpContextId;
        this.helpTooltip = helpTooltip;
        this.textClient = this.toolkit.createComposite((Composite)this.getSection(), 0);
        this.textClient.setSize(32, 16);
        this.init();
        Composite client = this.toolkit.createComposite((Composite)this.getSection());
        this.createClient(client, this.toolkit);
        this.getSection().setClient((Control)client);
    }

    public OverviewSection(FormEditor editor, IManagedForm managedForm, FormToolkit toolkit, int style) {
        super(managedForm.getForm().getBody(), toolkit, 0x100 | style);
        super.initialize(managedForm);
        this.editor = editor;
        this.toolkit = toolkit;
        this.textClient = this.toolkit.createComposite((Composite)this.getSection(), 0);
        this.textClient.setSize(32, 16);
        this.init();
    }

    public OverviewSection(FormEditor editor, IManagedForm managedForm, FormToolkit toolkit, int style, String helpContextId, String helpTooltip) {
        super(managedForm.getForm().getBody(), toolkit, 0x100 | style);
        super.initialize(managedForm);
        this.editor = editor;
        this.toolkit = toolkit;
        this.textClient = toolkit.createComposite((Composite)this.getSection(), 0);
        this.textClient.setSize(32, 16);
        this.helpContextId = helpContextId;
        this.helpTooltip = helpTooltip;
        this.init();
    }

    public void initialize() {
        Composite client = this.toolkit.createComposite((Composite)this.getSection());
        this.createClient(client, this.toolkit);
        this.getSection().setClient((Control)client);
    }

    private void init() {
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.pack = false;
        rowLayout.justify = true;
        rowLayout.type = 256;
        rowLayout.marginLeft = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginBottom = 0;
        rowLayout.spacing = 0;
        this.textClient.setLayout((Layout)rowLayout);
        this.helpImage = new ImageHyperlink(this.textClient, 0);
        this.toolkit.adapt((Control)this.helpImage, true, true);
        this.toolkit.adapt((Control)this.textClient, true, true);
        this.helpImage.setImage(CommonPlugin.getDefault().getImage("help.gif"));
        this.getSection().setTextClient((Control)this.textClient);
        if (this.helpTooltip != null) {
            this.helpImage.setToolTipText(this.helpTooltip);
        }
        this.helpImage.setBackground(this.getSection().getTitleBarGradientBackground());
        this.helpImage.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IContext context = HelpSystem.getContext((String)OverviewSection.this.helpContextId);
                if (context != null) {
                    IHelpResource[] topics = context.getRelatedTopics();
                    if (topics != null && topics.length == 1) {
                        WorkbenchHelp.displayHelpResource((String)topics[0].getHref());
                    } else {
                        WorkbenchHelp.displayHelp((String)OverviewSection.this.helpContextId);
                    }
                }
            }
        });
    }

    public Composite createClient(Composite container, FormToolkit factory) {
        return null;
    }

    protected Composite createClientContainer(Composite parent, int span, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.numColumns = span;
        container.setLayout((Layout)layout);
        return container;
    }

    protected void setPageDetails(IConfigurationElement element) {
        this.setText(element.getAttribute("name"));
        this.setDescription(element.getAttribute("description"));
    }

    public void processItems(Composite parent, FormToolkit toolkit, IConfigurationElement element) {
        String hyperlink = element.getAttribute("hyperlink");
        String text = element.getAttribute("text");
        String action = element.getAttribute("hyperlinkaction");
        element.getAttribute("actionparameters");
        if (hyperlink != null && hyperlink.length() > 0) {
            Hyperlink hypr = toolkit.createHyperlink(parent, hyperlink, 0);
            if (action != null && action.length() > 0) {
                try {
                    final IAction thisAction = (IAction)element.createExecutableExtension("hyperlinkaction");
                    hypr.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            thisAction.run();
                        }
                    });
                }
                catch (Exception ee) {
                    log.error("log.OverviewSection.action.error", hyperlink, ee);
                    CommonPlugin.getAlerts().detailError(hyperlink, "log.OverviewSection.action.error", hyperlink, ee);
                }
            }
        }
        if (text != null && text.length() > 0) {
            FormText form = toolkit.createFormText(parent, false);
            form.setText(text, false, false);
        }
    }

    public IConfigurationElement getExtensions(String extensionPoint) {
        IConfigurationElement element = null;
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPoint);
        if (elements.length > 0) {
            int ii = 0;
            while (ii < elements.length) {
                String anEditorId = elements[ii].getDeclaringExtension().getSimpleIdentifier();
                if (this.editorId.equals(anEditorId)) {
                    element = elements[ii];
                    break;
                }
                ++ii;
            }
        }
        return element;
    }

    public void setEditor(FormEditor editor) {
        this.editor = editor;
    }

    public FormEditor getEditor() {
        return this.editor;
    }

    public void setText(String text) {
        this.getSection().setText(text);
    }

    public void setDescription(String text) {
        this.getSection().setDescription(text);
    }

    public void setLayoutData(Object layoutData) {
        this.getSection().setLayoutData(layoutData);
    }

    public void setExpanded(boolean expanded) {
        this.getSection().setExpanded(expanded);
    }

    public ImageHyperlink getHelpImage() {
        return this.helpImage;
    }

    public void setEditorID(String id) {
        this.editorId = id;
    }
}

