/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorUtil {
    public static final HashMap SYSTEM_DEFAULT_COLORS = new HashMap(20);
    public static final HashMap CSS_COLORS = new HashMap(20);

    static {
        CSS_COLORS.put("black", ColorConstants.black);
        CSS_COLORS.put("blue", ColorConstants.blue);
        CSS_COLORS.put("gray", ColorConstants.gray);
        CSS_COLORS.put("green", ColorConstants.green);
        CSS_COLORS.put("orange", ColorConstants.orange);
        CSS_COLORS.put("red", ColorConstants.red);
        CSS_COLORS.put("white", ColorConstants.white);
        CSS_COLORS.put("yellow", ColorConstants.yellow);
        CSS_COLORS.put("aqua", ColorConstants.cyan);
        CSS_COLORS.put("fuchsia", new Color(null, 255, 0, 255));
        CSS_COLORS.put("lime", ColorConstants.green);
        CSS_COLORS.put("maroon", new Color(null, 128, 0, 0));
        CSS_COLORS.put("navy", new Color(null, 0, 0, 128));
        CSS_COLORS.put("olive", new Color(null, 128, 128, 0));
        CSS_COLORS.put("purple", new Color(null, 128, 0, 128));
        CSS_COLORS.put("silver", ColorConstants.lightGray);
        CSS_COLORS.put("teal", new Color(null, 0, 128, 128));
        SYSTEM_DEFAULT_COLORS.putAll(CSS_COLORS);
        SYSTEM_DEFAULT_COLORS.put("activeborder", Display.getCurrent().getSystemColor(23));
        SYSTEM_DEFAULT_COLORS.put("activecaption", ColorConstants.titleBackground);
        SYSTEM_DEFAULT_COLORS.put("appworkspace", ColorConstants.listBackground);
        SYSTEM_DEFAULT_COLORS.put("background", ColorConstants.listBackground);
        SYSTEM_DEFAULT_COLORS.put("buttonface", ColorConstants.button);
        SYSTEM_DEFAULT_COLORS.put("buttonhighlight", ColorConstants.buttonLightest);
        SYSTEM_DEFAULT_COLORS.put("buttonshadow", ColorConstants.buttonDarker);
        SYSTEM_DEFAULT_COLORS.put("buttontext", Display.getCurrent().getSystemColor(21));
        SYSTEM_DEFAULT_COLORS.put("captiontext", ColorConstants.titleForeground);
        SYSTEM_DEFAULT_COLORS.put("graytext", ColorConstants.titleInactiveForeground);
        SYSTEM_DEFAULT_COLORS.put("highlight", ColorConstants.menuBackgroundSelected);
        SYSTEM_DEFAULT_COLORS.put("highlighttext", ColorConstants.menuForegroundSelected);
        SYSTEM_DEFAULT_COLORS.put("inactiveborder", Display.getCurrent().getSystemColor(35));
        SYSTEM_DEFAULT_COLORS.put("inactivecaption", ColorConstants.titleInactiveBackground);
        SYSTEM_DEFAULT_COLORS.put("inactivecaptionText", ColorConstants.titleInactiveForeground);
        SYSTEM_DEFAULT_COLORS.put("infobackground", ColorConstants.tooltipBackground);
        SYSTEM_DEFAULT_COLORS.put("infotext", ColorConstants.tooltipForeground);
        SYSTEM_DEFAULT_COLORS.put("menu", ColorConstants.menuBackground);
        SYSTEM_DEFAULT_COLORS.put("menutext", ColorConstants.menuForeground);
        SYSTEM_DEFAULT_COLORS.put("scrollbar", Display.getCurrent().getSystemColor(22));
        SYSTEM_DEFAULT_COLORS.put("threeddarkshadow", Display.getCurrent().getSystemColor(17));
        SYSTEM_DEFAULT_COLORS.put("threedface", Display.getCurrent().getSystemColor(22));
        SYSTEM_DEFAULT_COLORS.put("threedhighlight", Display.getCurrent().getSystemColor(20));
        SYSTEM_DEFAULT_COLORS.put("threedlightshadow", Display.getCurrent().getSystemColor(19));
        SYSTEM_DEFAULT_COLORS.put("threedshadow", Display.getCurrent().getSystemColor(17));
        SYSTEM_DEFAULT_COLORS.put("window", Display.getCurrent().getSystemColor(25));
        SYSTEM_DEFAULT_COLORS.put("windowframe", Display.getCurrent().getSystemColor(23));
        SYSTEM_DEFAULT_COLORS.put("windowtext", Display.getCurrent().getSystemColor(24));
        SYSTEM_DEFAULT_COLORS.put("hyperlink", ColorConstants.blue);
    }

    public static Color getCSSColor(String cssText) {
        return (Color)CSS_COLORS.get(cssText.toLowerCase());
    }

    public static Map getCSSColorMap() {
        return Collections.unmodifiableMap(CSS_COLORS);
    }

    public static RGB getColorRGB(String textColor) {
        if (textColor == null || textColor.length() == 0) {
            return null;
        }
        Color color = ColorUtil.getCSSColor(textColor);
        if (color != null) {
            return color.getRGB();
        }
        if (textColor.charAt(0) == '#' && textColor.length() == 4) {
            char[] rgbChars = textColor.toCharArray();
            char[] fullChars = new char[]{rgbChars[0], rgbChars[1], rgbChars[1], rgbChars[2], rgbChars[2], rgbChars[3], rgbChars[3]};
            textColor = String.valueOf(fullChars);
        }
        if (textColor.charAt(0) == '#' && textColor.length() == 7) {
            int intColor;
            block7: {
                try {
                    intColor = Integer.decode(textColor);
                    if (intColor <= 0xFFFFFF && intColor >= 0) break block7;
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            int r = intColor >> 16;
            int g = intColor >> 8 & 0xFF;
            int b = intColor & 0xFF;
            return new RGB(r, g, b);
        }
        return null;
    }

    public static String getStringColor(RGB rgb) {
        if (rgb == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("#");
        int[] intRGBs = new int[]{rgb.red, rgb.green, rgb.blue};
        int i = 0;
        while (i < 3) {
            if (intRGBs[i] < 16) {
                buffer.append("0");
            }
            buffer.append(Integer.toHexString(intRGBs[i]).toUpperCase());
            ++i;
        }
        return buffer.toString();
    }
}

