/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.BaseSectionPartCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.AddDefaultRenderKitIDWizard;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfigDocumentWrap;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.sectionparts.ISSESectionPart;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.DefaultRenderKitIDSection;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigOrderHelper;
import org.w3c.dom.Document;

public class AddDefaultRenderKitIDCommand
extends BaseSectionPartCommand {
    private Object model;
    private String[] items;

    public AddDefaultRenderKitIDCommand(String label, ISSESectionPart sectionPart) {
        super(label, sectionPart);
        this.model = sectionPart.getModel();
    }

    public AddDefaultRenderKitIDCommand(String label, IStructuredModel model) {
        super(label, model);
        this.model = model;
    }

    protected void doExecute() {
        if (!(this.model instanceof IStructuredModel)) {
            return;
        }
        List renderKitIDList = this.getCurrentDefaultRenderKitIDs();
        this.items = this.getAvailableRenderKitIDs();
        AddDefaultRenderKitIDWizard wizard = new AddDefaultRenderKitIDWizard(renderKitIDList, this.items);
        wizard.init(EditorPlugin.getActiveWorkbenchWindow().getWorkbench(), (IStructuredSelection)((StructuredSelection)((DefaultRenderKitIDSection)this.getSectionPart().getSection()).getSelection()));
        wizard.setForcePreviousAndNextButtons(false);
        Shell shell = null;
        IWorkbenchWindow workbenchWindow = EditorPlugin.getActiveWorkbenchWindow();
        shell = workbenchWindow.getShell() != null ? workbenchWindow.getShell() : new Shell();
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
        wizardDialog.create();
        if (wizardDialog.open() == 0) {
            String renderKitID = wizard.getText();
            this.createDefaultRenderKitID(this.getApplicationNode(), renderKitID);
        }
    }

    private List getCurrentDefaultRenderKitIDs() {
        NodeWrapUtil applicationWrap;
        List defaultRenderKitIDNodeList;
        IDOMNode facesConfigNode;
        NodeWrapUtil facesConfigWrap;
        IDOMNode applicationNode;
        IDOMDocument document;
        FacesConfigDocumentWrap documentWrap;
        FacesConfig facesConfig;
        ArrayList<String> list = new ArrayList<String>();
        if (this.model instanceof IStructuredModel && (facesConfig = (documentWrap = new FacesConfigDocumentWrap((Document)(document = ((IDOMModel)this.model).getDocument()))).getFacesConfig()) != null && (applicationNode = (IDOMNode)(facesConfigWrap = new NodeWrapUtil(facesConfigNode = facesConfig.getNode())).getChildNode("application")) != null && (defaultRenderKitIDNodeList = (applicationWrap = new NodeWrapUtil(applicationNode)).getChildNodes("default-render-kit-id")) != null) {
            int i = 0;
            int n = defaultRenderKitIDNodeList.size();
            while (i < n) {
                IDOMNode aNode = (IDOMNode)defaultRenderKitIDNodeList.get(i);
                list.add(aNode.getFirstChild().getNodeValue());
                ++i;
            }
        }
        return list;
    }

    private String[] getAvailableRenderKitIDs() {
        IDOMNode facesConfigNode;
        NodeWrapUtil facesConfigWrap;
        List renderKitNodeList;
        IDOMDocument document;
        FacesConfigDocumentWrap documentWrap;
        FacesConfig facesConfig;
        ArrayList<String> list = new ArrayList<String>();
        if (this.model instanceof IStructuredModel && (facesConfig = (documentWrap = new FacesConfigDocumentWrap((Document)(document = ((IDOMModel)this.model).getDocument()))).getFacesConfig()) != null && (renderKitNodeList = (facesConfigWrap = new NodeWrapUtil(facesConfigNode = facesConfig.getNode())).getChildNodes("render-kit")) != null) {
            int i = 0;
            while (i < renderKitNodeList.size()) {
                IDOMNode aRenderKitNode = (IDOMNode)renderKitNodeList.get(i);
                NodeWrapUtil aRenderKitWrap = new NodeWrapUtil(aRenderKitNode);
                IDOMNode renderKitIDNode = (IDOMNode)aRenderKitWrap.getChildNode("render-kit-id");
                if (renderKitIDNode != null) {
                    IDOMNode textNode = (IDOMNode)renderKitIDNode.getFirstChild();
                    list.add(textNode.getNodeValue());
                }
                ++i;
            }
        }
        Object[] items = new String[list.size()];
        int i = 0;
        int n = list.size();
        while (i < n) {
            items[i] = list.get(i).toString();
            ++i;
        }
        Arrays.sort(items);
        return items;
    }

    private boolean isAlreadyExist(String renderKitIDString) {
        if (renderKitIDString == null || renderKitIDString.length() == 0) {
            return true;
        }
        IDOMNode applicationNode = this.getApplicationNode();
        if (applicationNode == null) {
            return false;
        }
        NodeWrapUtil applicationWrap = new NodeWrapUtil(applicationNode);
        List defaultRenderKitIDList = applicationWrap.getChildNodes("default-render-kit-id");
        if (defaultRenderKitIDList == null) {
            return false;
        }
        int i = 0;
        while (i < defaultRenderKitIDList.size()) {
            IDOMNode node = (IDOMNode)defaultRenderKitIDList.get(i);
            String id = node.getFirstChild().getNodeValue();
            if (id != null && id.equalsIgnoreCase(renderKitIDString)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IDOMNode getApplicationNode() {
        IDOMNode facesConfigNode;
        NodeWrapUtil facesConfigWrap;
        IDOMDocument document;
        FacesConfigDocumentWrap documentWrap;
        FacesConfig facesConfig;
        IDOMNode applicationNode = null;
        if (this.model instanceof IStructuredModel && (facesConfig = (documentWrap = new FacesConfigDocumentWrap((Document)(document = ((IDOMModel)this.model).getDocument()))).getFacesConfig()) != null && (applicationNode = (IDOMNode)(facesConfigWrap = new NodeWrapUtil(facesConfigNode = facesConfig.getNode())).getChildNode("application")) == null) {
            applicationNode = facesConfigWrap.createChildNode("application", false, null, FacesConfigOrderHelper.getInstance());
        }
        return applicationNode;
    }

    private void createDefaultRenderKitID(IDOMNode applicationNode, String renderKitID) {
        NodeWrapUtil applicationWrap = new NodeWrapUtil(applicationNode);
        applicationWrap.createChildNode("default-render-kit-id", false, renderKitID, FacesConfigOrderHelper.getInstance());
    }
}

