/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.ClassButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldApplyListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IStringButtonAdapter;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StatusInfo;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogs.CommonWizardDialog;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.SelectComponentFamilyWizard;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfigDocumentWrap;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.Renderer;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.RendererRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;
import org.w3c.dom.Document;

public class EditRendererGeneralGroup
extends DialogFieldGroup {
    private RendererRecorder renderKitRendererRecorder;
    private StringDialogField displayNameField;
    private StringButtonDialogField componentFamilyField;
    private StringDialogField rendererTypeField;
    private ClassButtonDialogField rendererClassField;
    private Composite parent;
    private IProject currentProject;
    private static EditorResources resource = EditorResources.getInstance();

    public EditRendererGeneralGroup(RendererRecorder renderKitRendererRecorder) {
        this.renderKitRendererRecorder = renderKitRendererRecorder;
    }

    public void initialize() {
        this.displayNameField = new StringDialogField();
        this.displayNameField.setLabelText(resource.getString("ComponentsPage.RenderKitsSection.Renderer.Wizard.Page.General.DisplayName"));
        this.displayNameField.setText(this.renderKitRendererRecorder.getDisplayName());
        this.displayNameField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.displayNameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditRendererGeneralGroup.this.renderKitRendererRecorder.setDisplayName(EditRendererGeneralGroup.this.displayNameField.getText());
            }
        });
        this.componentFamilyField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                SelectComponentFamilyWizard wizard = new SelectComponentFamilyWizard(EditRendererGeneralGroup.this.componentFamilyField.getText(), EditRendererGeneralGroup.this.getComponentFamilies());
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                wizard.setForcePreviousAndNextButtons(false);
                CommonWizardDialog wizardDialog = new CommonWizardDialog(EditRendererGeneralGroup.this.parent.getShell(), (IWizard)wizard);
                wizardDialog.create();
                if (wizardDialog.open() == 0) {
                    EditRendererGeneralGroup.this.componentFamilyField.setText(wizard.getText());
                }
            }
        });
        this.componentFamilyField.setLabelText(resource.getString("ComponentsPage.RenderKitsSection.Renderer.Wizard.Page.General.ComponentFamily"));
        this.componentFamilyField.setText(this.renderKitRendererRecorder.getComponentFamily());
        this.componentFamilyField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.componentFamilyField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditRendererGeneralGroup.this.renderKitRendererRecorder.setComponentFamily(EditRendererGeneralGroup.this.componentFamilyField.getText());
            }
        });
        this.rendererTypeField = new StringDialogField();
        this.rendererTypeField.setLabelText(resource.getString("ComponentsPage.RenderKitsSection.Renderer.Wizard.Page.General.RendererType"));
        this.rendererTypeField.setText(this.renderKitRendererRecorder.getRendererType());
        this.rendererTypeField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.rendererTypeField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditRendererGeneralGroup.this.renderKitRendererRecorder.setRendererType(EditRendererGeneralGroup.this.rendererTypeField.getText());
            }
        });
        this.rendererClassField = new ClassButtonDialogField(this.getProject());
        this.rendererClassField.setLabelText(resource.getString("ComponentsPage.RenderKitsSection.Renderer.Wizard.Page.General.RendererClass"));
        this.rendererClassField.setText(this.renderKitRendererRecorder.getRendererClass());
        this.rendererClassField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.rendererClassField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditRendererGeneralGroup.this.renderKitRendererRecorder.setRendererClass(EditRendererGeneralGroup.this.rendererClassField.getText());
            }
        });
        this.rendererClassField.setSuperClassName("javax.faces.render.Renderer");
        this.rendererClassField.setAutoOpenResource(false);
    }

    private List getComponentFamilies() {
        IDOMNode facesConfigNode;
        NodeWrapUtil facesConfigWrap;
        List componentList;
        IDOMDocument document;
        FacesConfigDocumentWrap documentWrap;
        FacesConfig facesConfig;
        ArrayList<String> componentFamilies = new ArrayList<String>();
        IDOMModel model = this.renderKitRendererRecorder.getDOMModel();
        if (model != null && (facesConfig = (documentWrap = new FacesConfigDocumentWrap((Document)(document = model.getDocument()))).getFacesConfig()) != null && (componentList = (facesConfigWrap = new NodeWrapUtil(facesConfigNode = facesConfig.getNode())).getChildNodes("component")) != null) {
            int i = 0;
            int n = componentList.size();
            while (i < n) {
                IDOMNode componentNode = (IDOMNode)componentList.get(i);
                NodeWrapUtil componentWrap = new NodeWrapUtil(componentNode);
                String componentFamily = componentWrap.getChildNodeValue("component-type");
                if (componentFamily != null && componentFamily.length() > 0) {
                    componentFamilies.add(componentFamily);
                }
                ++i;
            }
        }
        return componentFamilies;
    }

    protected IProject getProject() {
        IDOMNode node;
        Renderer renderer;
        if (this.currentProject == null && (renderer = this.renderKitRendererRecorder.getRenderer()) != null && (node = renderer.getNode()) != null) {
            this.currentProject = StructuredModelUtil.getProjectFor((IStructuredModel)node.getModel());
        }
        return this.currentProject;
    }

    public void setProject(IProject project) {
        this.currentProject = project;
        this.rendererClassField.setProject(project);
    }

    public void refreshData() {
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        this.parent = parent;
        GridData data = new GridData(1808);
        parent.setLayoutData((Object)data);
        int numberOfColumns = 4;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        parent.setLayout((Layout)gl);
        this.displayNameField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.componentFamilyField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.componentFamilyField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.rendererTypeField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.rendererClassField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.rendererClassField.getTextControl(toolkit, parent));
    }

    public IStatus[] validateDialogFields() {
        StatusInfo componentFamilyStatus = new StatusInfo();
        StatusInfo rendererTypeStatus = new StatusInfo();
        StatusInfo rendererClassStatus = new StatusInfo();
        IStatus[] status = new IStatus[]{componentFamilyStatus, rendererTypeStatus, rendererClassStatus};
        if (this.componentFamilyField.getText().length() == 0) {
            componentFamilyStatus.setError(resource.getString("ComponentsPage.RenderKitsSection.Wizard.Page.EditRendererGeneralGroup.Error.ComponentFamilyEmpty"));
        }
        if (this.rendererTypeField.getText().length() == 0) {
            rendererTypeStatus.setError(resource.getString("ComponentsPage.RenderKitsSection.Wizard.Page.EditRendererGeneralGroup.Error.RendererTypeEmpty"));
        }
        if (this.rendererClassField.getText().length() == 0) {
            rendererClassStatus.setError(resource.getString("ComponentsPage.RenderKitsSection.Wizard.Page.EditRendererGeneralGroup.Error.RendererClassEmpty"));
        }
        return status;
    }
}

