/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogs.ResourceOnClasspathDialog;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.MessageBundleViewerSorter;

public class MessageBundleSelectionDialog
extends ResourceOnClasspathDialog {
    private List resourceBundles;
    private static EditorResources resource = EditorResources.getInstance();
    private String selectPropertyFileMessage = resource.getString("OthersPage.Application.MessageBundleSection.Dialog.Message.SelectPropertyFile");
    private String alreadyExistStatusMessage = resource.getString("OthersPage.Application.MessageBundleSection.Dialog.Message.AlreadyExists");
    private static final String[] PROPERTIES_FILES_SUFFIXS = new String[]{"properties"};

    public MessageBundleSelectionDialog(Shell parentShell, IJavaProject project, List resourceBundles) {
        super(parentShell, project);
        this.resourceBundles = resourceBundles;
        this.setSuffixs(PROPERTIES_FILES_SUFFIXS);
        this.setTitle(resource.getString("OthersPage.Application.MessageBundleSection.Dialog.Title"));
        this.setViewerSorter(new MessageBundleViewerSorter());
    }

    protected boolean isValidSelection(Object selection) {
        if (!super.isValidSelection(selection)) {
            this.setStatusMessage(this.selectPropertyFileMessage);
            return false;
        }
        ArrayList<Object> selectionList = new ArrayList<Object>();
        selectionList.add(selection);
        this.setResult(selectionList);
        Object result = super.getResult()[0];
        if (result == null) {
            this.setStatusMessage(this.selectPropertyFileMessage);
            return false;
        }
        String newResourceBundle = (String)result;
        if (this.isAlreadyExist(newResourceBundle)) {
            this.setStatusMessage(this.alreadyExistStatusMessage);
            return false;
        }
        return true;
    }

    private boolean isAlreadyExist(String resourceBundleString) {
        if (resourceBundleString == null || resourceBundleString.length() == 0) {
            return true;
        }
        if (this.resourceBundles == null) {
            return false;
        }
        int i = 0;
        while (i < this.resourceBundles.size()) {
            IDOMNode node = (IDOMNode)this.resourceBundles.get(i);
            String rbName = node.getFirstChild().getNodeValue();
            if (rbName != null && rbName.equalsIgnoreCase(resourceBundleString)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

