/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.model.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigOrderHelper;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ListEntriesRecorder {
    public static final int MOVE_UP = 0;
    public static final int MOVE_DOWN = 1;
    private List listEntries;
    private String valueClass;
    private IDOMNode parentNode;
    private ManagedBean bean;
    private boolean bSynchronizeWithModel;
    public static final String[] valueTags = new String[]{"value", "null-value"};

    public ListEntriesRecorder(IDOMNode parentNode, ManagedBean bean) {
        this.setParentNode(parentNode);
        this.setBean(bean);
    }

    public void setSynchronzeWithModel(boolean bSynchronize) {
        this.bSynchronizeWithModel = bSynchronize;
    }

    public void retrieve() {
        if (this.parentNode == null || this.bean == null) {
            return;
        }
        NodeWrapUtil parentNodeWrap = new NodeWrapUtil(this.parentNode);
        IDOMNode listEntriesNode = (IDOMNode)parentNodeWrap.getChildNode("list-entries");
        if (listEntriesNode != null) {
            NodeWrapUtil listEntriesWrap = new NodeWrapUtil(listEntriesNode);
            this.valueClass = listEntriesWrap.getChildNodeValue("value-class");
            List listEntries = listEntriesWrap.getChildNodes(valueTags);
            if (listEntries != null) {
                Iterator iter = listEntries.iterator();
                while (iter.hasNext()) {
                    this.addListEntry((IDOMNode)iter.next());
                }
            }
        }
    }

    public void update() {
        if (this.parentNode == null || this.bean == null) {
            return;
        }
        NodeWrapUtil parentNodeWrap = new NodeWrapUtil(this.parentNode);
        parentNodeWrap.removeChildNodes("list-entries");
        IDOMNode listEntriesNode = parentNodeWrap.createChildNode("list-entries", true, null, FacesConfigOrderHelper.getInstance());
        NodeWrapUtil listEntriesNodeWrap = new NodeWrapUtil(listEntriesNode);
        if (this.getValueClass() != null && this.getValueClass().length() > 0) {
            listEntriesNodeWrap.createChildNode("value-class", false, this.getValueClass(), FacesConfigOrderHelper.getInstance());
        }
        Iterator iter = this.getListEntries().iterator();
        while (iter.hasNext()) {
            ListEntry listEntry = (ListEntry)iter.next();
            if (listEntry._valueType.equalsIgnoreCase("null-value")) {
                listEntriesNodeWrap.createChildNode("null-value", true, null, FacesConfigOrderHelper.getInstance());
                continue;
            }
            listEntriesNodeWrap.createChildNode("value", false, listEntry._value, FacesConfigOrderHelper.getInstance());
        }
    }

    public void setParentNode(IDOMNode parentNode) {
        this.parentNode = parentNode;
    }

    public IDOMNode getParentNode() {
        return this.parentNode;
    }

    public void setBean(ManagedBean bean) {
        this.bean = bean;
    }

    public ManagedBean getBean() {
        return this.bean;
    }

    public void setValueClass(String valueClass) {
        this.valueClass = valueClass;
        if (this.bSynchronizeWithModel) {
            NodeWrapUtil listEntriesNodeWrap;
            IDOMNode valueClassNode;
            NodeWrapUtil parentNodeWrap = new NodeWrapUtil(this.parentNode);
            IDOMNode listEntriesNode = (IDOMNode)parentNodeWrap.getChildNode("list-entries");
            if (listEntriesNode == null) {
                listEntriesNode = parentNodeWrap.createChildNode("list-entries", true, null, FacesConfigOrderHelper.getInstance());
            }
            if ((valueClassNode = (IDOMNode)(listEntriesNodeWrap = new NodeWrapUtil(listEntriesNode)).getChildNode("value-class")) == null) {
                listEntriesNodeWrap.createChildNode("value-class", true, null, FacesConfigOrderHelper.getInstance());
            }
            listEntriesNodeWrap.setChildNodeValueKeepEmpty("value-class", this.valueClass);
        }
    }

    public String getValueClass() {
        return this.valueClass;
    }

    public void setListEntries(List listEntries) {
        if (this.listEntries != null) {
            this.listEntries.clear();
        }
        if (this.listEntries == null) {
            this.listEntries = new ArrayList();
        }
        this.listEntries.addAll(listEntries);
    }

    public List getListEntries() {
        if (this.listEntries == null) {
            this.listEntries = new ArrayList();
        }
        return this.listEntries;
    }

    public void moveListEntry(ListEntry entry, int direction) {
    }

    public boolean isEmpty() {
        NodeWrapUtil parentNodeWrap = new NodeWrapUtil(this.parentNode);
        return parentNodeWrap.getChildNode("list-entries") == null;
    }

    public void clearAll() {
        this.getListEntries().clear();
        NodeWrapUtil parentNodeWrap = new NodeWrapUtil(this.parentNode);
        parentNodeWrap.removeChildNodes("list-entries");
    }

    public void removeListEntry(ListEntry entry) {
        this.getListEntries().remove(entry);
        if (this.bSynchronizeWithModel) {
            NodeWrapUtil.removeNode((Node)entry._node);
        }
    }

    public ListEntry addListEntry(IDOMNode listEntry) {
        ListEntry entry = null;
        entry = listEntry.getNodeName().equalsIgnoreCase("null-value") ? this.addListEntryToList("null-value", null) : this.addListEntryToList("value", StructuredModelUtil.getTextElementValue((Element)listEntry));
        if (entry != null) {
            entry._node = listEntry;
        }
        return entry;
    }

    private ListEntry addListEntryToList(String valueType, String value) {
        ListEntry entry = null;
        if (valueType.equalsIgnoreCase("null-value") || valueType.equalsIgnoreCase("value")) {
            entry = new ListEntry();
            entry._valueType = valueType;
            entry._value = value;
            this.getListEntries().add(entry);
        }
        return entry;
    }

    private ListEntry addListEntryToModel(String valueType, String value) {
        ListEntry entry = null;
        if (valueType.equalsIgnoreCase("null-value") || valueType.equalsIgnoreCase("value")) {
            entry = new ListEntry();
            entry._valueType = valueType;
            entry._value = value;
            NodeWrapUtil parentNodeWrap = new NodeWrapUtil(this.parentNode);
            IDOMNode listEntriesNode = (IDOMNode)parentNodeWrap.getChildNode("list-entries");
            if (listEntriesNode == null) {
                listEntriesNode = parentNodeWrap.createChildNode("list-entries", true, null, FacesConfigOrderHelper.getInstance());
            }
            NodeWrapUtil listEntriesNodeWrap = new NodeWrapUtil(listEntriesNode);
            IDOMNode listEntryNode = null;
            listEntryNode = entry._valueType.equalsIgnoreCase("null-value") ? listEntriesNodeWrap.createChildNode("null-value", true, null, FacesConfigOrderHelper.getInstance()) : listEntriesNodeWrap.createChildNode("value", false, entry._value, FacesConfigOrderHelper.getInstance());
            entry._node = listEntryNode;
        }
        return entry;
    }

    public ListEntry addListEntry(String valueType, String value) {
        if (this.bSynchronizeWithModel) {
            return this.addListEntryToModel(valueType, value);
        }
        return this.addListEntryToList(valueType, value);
    }

    public void updateListEntry(ListEntry listEntry, String valueType, String value) {
        listEntry._valueType = valueType;
        listEntry._value = value;
        if (this.bSynchronizeWithModel) {
            NodeWrapUtil listEntriesNodeWrap = new NodeWrapUtil((IDOMNode)listEntry._node.getParentNode());
            if (listEntry._valueType.equalsIgnoreCase("null-value")) {
                listEntriesNodeWrap.createChildNodeBefore(listEntry._node, "null-value", true, null, FacesConfigOrderHelper.getInstance());
            } else {
                listEntriesNodeWrap.createChildNodeBefore(listEntry._node, "value", false, listEntry._value, FacesConfigOrderHelper.getInstance());
            }
            NodeWrapUtil.removeNode((Node)listEntry._node);
        }
    }

    public void updateListEntry(ListEntry listEntry, IDOMNode node) {
        new NodeWrapUtil(node);
        if (node.getNodeName().equalsIgnoreCase("null-value")) {
            listEntry._valueType = "null-value";
        } else {
            listEntry._valueType = "value";
            listEntry._value = StructuredModelUtil.getTextElementValue((Element)node);
        }
        listEntry._node = node;
    }

    public String toString() {
        String strListEntries = "";
        strListEntries = "[list-entries]";
        return strListEntries;
    }

    public class ListEntry {
        public String _valueType = "value";
        public String _value;
        public IDOMNode _node = null;
    }
}

