/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.model.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.OrderHelper;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigOrderHelper;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.TableContentHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeWrapUtil {
    private IStructuredFormatProcessor formatProcessor = new FormatProcessorXML();
    private TableContentHelper tableContentHelper = new TableContentHelper();
    private IDOMNode xmlNode;

    public static boolean isElementContentWhitespaceTextNode(Node node) {
        return node != null && node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0;
    }

    public static void removeNode(Node node) {
        Node parent = node.getParentNode();
        Node previousSibling = node.getPreviousSibling();
        if (previousSibling != null && NodeWrapUtil.isElementContentWhitespaceTextNode(previousSibling)) {
            parent.removeChild(previousSibling);
        }
        parent.removeChild(node);
    }

    public NodeWrapUtil(IDOMNode node) {
        this.xmlNode = node;
    }

    private static int getIndex(Map orderMap, String node) {
        Iterator it = orderMap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.indexOf(node) == -1) continue;
            return (Integer)orderMap.get(key);
        }
        return Integer.MAX_VALUE;
    }

    public IDOMNode createChildNode(String tagName, boolean isEmptyTag, String value, OrderHelper orderHelper) {
        IDOMElement childNode = (IDOMElement)this.xmlNode.getOwnerDocument().createElement(tagName);
        childNode.setEmptyTag(isEmptyTag);
        Map orderMap = new HashMap();
        if (orderHelper != null) {
            orderMap = orderHelper.getSublingWithOrder(this.xmlNode);
        }
        int newIndex = NodeWrapUtil.getIndex(orderMap, tagName);
        Node node = null;
        boolean found = false;
        NodeList nodeList = this.xmlNode.getChildNodes();
        int i = 0;
        int n = nodeList.getLength();
        while (i < n) {
            String nodeName;
            int index;
            node = nodeList.item(i);
            if (node.getNodeType() == 1 && newIndex < (index = NodeWrapUtil.getIndex(orderMap, nodeName = node.getNodeName()))) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            this.xmlNode.insertBefore((Node)childNode, node);
        } else {
            this.xmlNode.appendChild((Node)childNode);
        }
        if (value != null) {
            this.tableContentHelper.setNodeValue((Node)childNode, value);
        }
        this.formatProcessor.formatNode((Node)this.xmlNode);
        return childNode;
    }

    public IDOMNode createChildNodeBefore(IDOMNode siblingNode, String tagName, boolean isEmptyTag, String value, OrderHelper orderHelper) {
        IDOMElement childNode = (IDOMElement)this.xmlNode.getOwnerDocument().createElement(tagName);
        childNode.setEmptyTag(isEmptyTag);
        boolean found = false;
        NodeList nodeList = this.xmlNode.getChildNodes();
        int i = 0;
        int n = nodeList.getLength();
        while (i < n) {
            if (nodeList.item(i) == siblingNode) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            this.xmlNode.insertBefore((Node)childNode, (Node)siblingNode);
        } else {
            this.xmlNode.appendChild((Node)childNode);
        }
        if (value != null) {
            this.tableContentHelper.setNodeValue((Node)childNode, value);
        }
        this.formatProcessor.formatNode((Node)this.xmlNode);
        return childNode;
    }

    public IDOMNode createChildNode(String tagName, boolean isEmptyTag, String value) {
        return this.createChildNode(tagName, isEmptyTag, value, FacesConfigOrderHelper.getInstance());
    }

    public void appendChildNode(IDOMNode node) {
        this.xmlNode.appendChild((Node)node);
        this.formatProcessor.formatNode((Node)this.xmlNode);
    }

    public Node getChildNode(String tagName) {
        List elementChildren = this.tableContentHelper.getChildren(this.getNode());
        int i = 0;
        int n = elementChildren.size();
        while (i < n) {
            IDOMNode child;
            if (elementChildren.get(i) instanceof IDOMElement && (child = (IDOMNode)elementChildren.get(i)).getNodeName().equalsIgnoreCase(tagName)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public List getChildNodes(String tagName) {
        ArrayList<IDOMNode> list = new ArrayList<IDOMNode>();
        List elementChildren = this.tableContentHelper.getChildren(this.getNode());
        int i = 0;
        int n = elementChildren.size();
        while (i < n) {
            IDOMNode child;
            if (elementChildren.get(i) instanceof IDOMElement && (child = (IDOMNode)elementChildren.get(i)).getNodeName().equalsIgnoreCase(tagName)) {
                list.add(child);
            }
            ++i;
        }
        return list.isEmpty() ? null : list;
    }

    public List getChildNodes(String[] tagNames) {
        ArrayList<IDOMNode> list = new ArrayList<IDOMNode>();
        List elementChildren = this.tableContentHelper.getChildren(this.getNode());
        int i = 0;
        int n = elementChildren.size();
        while (i < n) {
            IDOMNode child;
            if (elementChildren.get(i) instanceof IDOMElement && this.isSearchedTag((child = (IDOMNode)elementChildren.get(i)).getNodeName(), tagNames)) {
                list.add(child);
            }
            ++i;
        }
        return list.isEmpty() ? null : list;
    }

    private boolean isSearchedTag(String searchedTag, String[] tagNames) {
        if (searchedTag == null || tagNames == null) {
            return false;
        }
        int i = 0;
        while (i < tagNames.length) {
            if (searchedTag.equalsIgnoreCase(tagNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getChildNodeValue(String tagName) {
        String result = null;
        Node node = this.getChildNode(tagName);
        if (node != null) {
            result = this.tableContentHelper.getNodeValue(node);
        }
        if ((result = NodeWrapUtil.unEscapeEntities(result)) != null) {
            result = result.trim();
        }
        return result != null ? result : "";
    }

    public IDOMNode getNode() {
        return this.xmlNode;
    }

    public void removeChildNodes(String tagName) {
        List list = this.getChildNodes(tagName);
        if (list != null) {
            int i = 0;
            int n = list.size();
            while (i < n) {
                Node node = (Node)list.get(i);
                NodeWrapUtil.removeNode(node);
                ++i;
            }
        }
    }

    public void setChildNodeValue(String tagName, String value) {
        String escapedValue = NodeWrapUtil.escapeEntities(value);
        boolean isExist = false;
        NodeList nodeList = this.xmlNode.getChildNodes();
        int i = 0;
        int n = nodeList.getLength();
        while (i < n) {
            Node node = nodeList.item(i);
            if (node instanceof IDOMElement && node.getNodeName().equalsIgnoreCase(tagName)) {
                isExist = true;
                if (escapedValue == null || escapedValue.equals("")) {
                    NodeWrapUtil.removeNode(node);
                    break;
                }
                this.tableContentHelper.setNodeValue(node, escapedValue);
                break;
            }
            ++i;
        }
        if (!isExist) {
            this.createChildNode(tagName, false, value);
        } else {
            this.formatProcessor.formatNode((Node)this.xmlNode);
        }
    }

    public void setChildNodeValueKeepEmpty(String tagName, String value) {
        String escapedValue = NodeWrapUtil.escapeEntities(value);
        boolean isExist = false;
        NodeList nodeList = this.xmlNode.getChildNodes();
        int i = 0;
        int n = nodeList.getLength();
        while (i < n) {
            Node node = nodeList.item(i);
            if (node instanceof IDOMElement && node.getNodeName().equalsIgnoreCase(tagName)) {
                isExist = true;
                this.tableContentHelper.setNodeValue(node, escapedValue);
                break;
            }
            ++i;
        }
        if (!isExist) {
            this.createChildNode(tagName, false, value);
        }
    }

    public void setChildNodeWithEmptyTag(String tagName, boolean flag) {
        if (flag) {
            this.createChildNode(tagName, true, null);
        } else {
            this.removeChildNodes("distributable");
        }
    }

    public static String escapeEntities(String str) {
        if (NodeWrapUtil.isEmptyString(str)) {
            return "";
        }
        StringBuffer buffer = null;
        int i = 0;
        int n = str.length();
        while (i < n) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '\'': {
                    entity = "&apos;";
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\r': {
                    entity = "&#xD;";
                    break;
                }
                case '\t': {
                    entity = "&#x9;";
                    break;
                }
                case '\n': {
                    entity = "&#xA;";
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity != null) {
                    buffer = new StringBuffer(str.length() + 20);
                    buffer.append(str.substring(0, i));
                    buffer.append(entity);
                }
            } else if (entity == null) {
                buffer.append(ch);
            } else {
                buffer.append(entity);
            }
            ++i;
        }
        return buffer == null ? str : buffer.toString();
    }

    public static String unEscapeEntities(String str) {
        if (NodeWrapUtil.isEmptyString(str)) {
            return "";
        }
        String result = new String(str);
        result = result.replaceAll("&amp;", "&");
        result = result.replaceAll("&lt;", "<");
        result = result.replaceAll("&gt;", ">");
        result = result.replaceAll("&apos;", "'");
        result = result.replaceAll("&quot;", "\"");
        result = result.replaceAll("&#xD;", "\r");
        result = result.replaceAll("&#x9;", "\t");
        result = result.replaceAll("&#xA;", "\n");
        return result;
    }

    private static boolean isEmptyString(String value) {
        return value == null || value.length() == 0;
    }
}

