/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.pageflow.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPreferences;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.figures.ConnectionLabel;

public class PFLinkFigure
extends PolylineConnection {
    private ConnectionLabel label = null;
    private Color labelBgColor;
    private Color labelFgColor;
    private Font labelFont;
    private boolean bLabelVisible = false;
    private int lineWidth = 0;
    private PolygonDecoration arrow = new PolygonDecoration();

    public PFLinkFigure() {
        this.arrow.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        this.arrow.setScale(10.0, (double)(this.getLineWidth() * 2));
        this.setTargetDecoration((RotatableDecoration)this.arrow);
        this.setForegroundColor(this.getForegroundColor());
    }

    public void setLabel(String strLabel) {
        if (strLabel != null) {
            if (strLabel.length() > 0) {
                if (this.label == null) {
                    this.label = new ConnectionLabel();
                    this.label.setFont(this.getLabelFont());
                    this.label.setBackgroundColor(this.getLabelBackgroundColor());
                    this.label.setForegroundColor(this.getLabelForegroundColor());
                    this.setLineWidth(this.getLineWidth());
                    this.setLabelVisible(this.getLabelVisible());
                    this.setForegroundColor(this.getForegroundColor());
                    this.add((IFigure)this.label, new MidpointLocator((Connection)this, 0));
                }
                this.label.setText(strLabel);
            } else if (this.label != null) {
                this.remove((IFigure)this.label);
                this.label = null;
            }
        }
    }

    public void setImage(Image image) {
        if (image != null) {
            if (this.label == null) {
                this.label = new ConnectionLabel();
                this.label.setFont(this.getLabelFont());
                this.label.setBackgroundColor(this.getLabelBackgroundColor());
                this.label.setForegroundColor(this.getLabelForegroundColor());
                this.setLineWidth(this.getLineWidth());
                this.setLabelVisible(this.getLabelVisible());
                this.setForegroundColor(this.getForegroundColor());
                this.add((IFigure)this.label, new MidpointLocator((Connection)this, 0));
            }
            this.label.setIcon(image);
        } else if (this.label != null) {
            if (this.label.getText().length() == 0) {
                this.remove((IFigure)this.label);
            } else {
                this.label.setIcon(null);
            }
        }
    }

    public void setToolTipText(String text) {
        Label toolTip = null;
        if (text != null && text.length() > 0) {
            toolTip = new Label(text);
            toolTip.setBorder((Border)new MarginBorder(3));
        }
        super.setToolTip(toolTip);
    }

    public String getToolTipText() {
        if (this.getToolTip() != null) {
            return ((Label)this.getToolTip()).getText();
        }
        return null;
    }

    public void setFont(Font f) {
        if (this.label != null) {
            this.label.setFont(f);
        }
        super.setFont(f);
    }

    private Font getLabelFont() {
        if (this.labelFont == null) {
            IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
            this.labelFont = new Font(null, PreferenceConverter.getFontData((IPreferenceStore)store, (String)"LineLabelFont"));
        }
        return this.labelFont;
    }

    public void setLineWidth(int w) {
        if (this.label != null) {
            this.label.setBorderWidth(w);
        }
        this.arrow.setScale(10.0, (double)(this.getLineWidth() * 2));
        super.setLineWidth(w);
    }

    public int getLineWidth() {
        IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
        this.lineWidth = store.getInt("LineWidth");
        return this.lineWidth;
    }

    public void setLabelVisible(boolean flag) {
        if (this.label != null) {
            this.label.setVisible(flag);
        }
    }

    private boolean getLabelVisible() {
        IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
        this.bLabelVisible = store.getBoolean("ShowLineLabels");
        return this.bLabelVisible;
    }

    public void setLabelForegroundColor(Color c) {
        this.labelFgColor = c;
        if (this.label != null) {
            this.label.setForegroundColor(c);
        }
    }

    private Color getLabelForegroundColor() {
        if (this.labelFgColor == null) {
            IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
            this.labelFgColor = EditorPreferences.getColor(store, "LineLabelFontColor");
        }
        return this.labelFgColor;
    }

    public void setLabelBackgroundColor(Color c) {
        this.labelBgColor = c;
        if (this.label != null) {
            this.label.setBackgroundColor(c);
        }
    }

    private Color getLabelBackgroundColor() {
        if (this.labelBgColor == null) {
            IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
            this.labelBgColor = EditorPreferences.getColor(store, "LineLabelColor");
        }
        return this.labelBgColor;
    }

    public Color getForegroundColor() {
        IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
        this.fgColor = EditorPreferences.getColor(store, "LineColor");
        return this.fgColor;
    }

    public void setForegroundColor(Color c) {
        if (this.label != null) {
            this.label.setBorderColor(c);
        }
        super.setForegroundColor(c);
    }
}

