/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.properties.sections;

import java.text.MessageFormat;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wtp.jsf.facesconfig.editor.properties.PropertyResources;

public class SetPropertyValueCommand
extends Command {
    protected static PropertyResources resource = PropertyResources.getInstance();
    protected Object propertyValue;
    protected Object propertyID;
    protected Object undoValue;
    protected boolean resetOnUndo;
    protected IPropertySource target;

    public SetPropertyValueCommand() {
        super("");
    }

    public SetPropertyValueCommand(String propLabel) {
        super(MessageFormat.format(resource.getString("property.Command.SetValue"), propLabel).trim());
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        boolean wasPropertySet = this.getTarget().isPropertySet(this.propertyID);
        this.undoValue = this.getTarget().getPropertyValue(this.propertyID);
        if (this.undoValue instanceof IPropertySource) {
            this.undoValue = ((IPropertySource)this.undoValue).getEditableValue();
        }
        if (this.propertyValue instanceof IPropertySource) {
            this.propertyValue = ((IPropertySource)this.propertyValue).getEditableValue();
        }
        this.getTarget().setPropertyValue(this.propertyID, this.propertyValue);
        this.resetOnUndo = wasPropertySet ^ this.getTarget().isPropertySet(this.propertyID);
        if (this.resetOnUndo) {
            this.undoValue = null;
        }
    }

    public IPropertySource getTarget() {
        return this.target;
    }

    public void setTarget(IPropertySource aTarget) {
        this.target = aTarget;
    }

    public void redo() {
        this.execute();
    }

    public void setPropertyId(Object pName) {
        this.propertyID = pName;
    }

    public void setPropertyValue(Object val) {
        this.propertyValue = val;
    }

    public void undo() {
        if (this.resetOnUndo) {
            this.getTarget().resetPropertyValue(this.propertyID);
        } else {
            this.getTarget().setPropertyValue(this.propertyID, this.undoValue);
        }
    }
}

