/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sectionparts;

import java.util.Iterator;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.RemoveXMLNodeCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.sectionparts.ISSESectionPart;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.ISSESection;

public abstract class AbstractSSESectionPart
implements ISSESectionPart {
    private Object model = null;
    private ISSESection section;

    public void dispose() {
        if (this.getModel() != null) {
            this.unhookFromModel(this.getModel());
        }
    }

    public void setModel(Object newModel) {
        if (this.model != null) {
            this.unhookFromModel(this.model);
        }
        this.model = newModel;
        this.getSection().setInput(this.model);
        this.hookIntoModel(this.model);
    }

    protected abstract void hookIntoModel(Object var1);

    protected abstract void unhookFromModel(Object var1);

    public Object getModel() {
        return this.model;
    }

    public void setSection(ISSESection section) {
        this.section = section;
        this.section.setSectionPart(this);
    }

    public ISSESection getSection() {
        return this.section;
    }

    private boolean isValidSelection() {
        ISelection selection = this.getSection().getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            if (selection.equals(StructuredSelection.EMPTY)) {
                return false;
            }
            Iterator iter = ((IStructuredSelection)selection).iterator();
            Object node = iter.next();
            if (node instanceof IDOMNode) {
                return true;
            }
        }
        return false;
    }

    public Command getCommand(Request request) {
        if (request.getType().equals("delete") && this.isValidSelection()) {
            return new RemoveXMLNodeCommand("", this);
        }
        return null;
    }

    public String getLabel(IDOMNode node) {
        if (node != null) {
            return node.getLocalName();
        }
        return null;
    }
}

