/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sectionparts;

import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfigDocumentWrap;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.providers.LocaleConfigContentLabelProvider;
import org.eclipse.wtp.jsf.facesconfig.editor.sectionparts.AbstractSSESectionPart;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.ISSESection;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.LocaleConfigSection;
import org.w3c.dom.Document;

public class LocaleConfigSectionPart
extends AbstractSSESectionPart {
    static /* synthetic */ Class class$0;

    protected void hookIntoModel(Object model) {
        if (!(model instanceof IStructuredModel)) {
            return;
        }
        IDOMDocument document = ((IDOMModel)model).getDocument();
        FacesConfigDocumentWrap documentWrap = new FacesConfigDocumentWrap((Document)document);
        ((IDOMNode)document).addAdapter((INodeAdapter)this);
        FacesConfig facesConfig = documentWrap.getFacesConfig();
        if (facesConfig != null) {
            facesConfig.getNode().addAdapter((INodeAdapter)this);
            NodeWrapUtil facesConfigWrap = new NodeWrapUtil(facesConfig.getNode());
            IDOMNode applicationNode = (IDOMNode)facesConfigWrap.getChildNode("application");
            if (applicationNode != null) {
                this.hookIntoApplication(applicationNode);
            }
        }
    }

    protected void hookIntoApplication(IDOMNode applicationNode) {
        applicationNode.addAdapter((INodeAdapter)this);
        NodeWrapUtil applicationWrap = new NodeWrapUtil(applicationNode);
        IDOMNode localeConfigNode = (IDOMNode)applicationWrap.getChildNode("locale-config");
        if (localeConfigNode != null) {
            this.hookIntoLocaleConfig(localeConfigNode);
        }
    }

    private void hookIntoLocaleConfig(IDOMNode localeConfigNode) {
        List list;
        localeConfigNode.addAdapter((INodeAdapter)this);
        NodeWrapUtil localeConfigWrap = new NodeWrapUtil(localeConfigNode);
        IDOMNode defaultLocalNode = (IDOMNode)localeConfigWrap.getChildNode("default-locale");
        if (defaultLocalNode != null) {
            defaultLocalNode.addAdapter((INodeAdapter)this);
        }
        if ((list = localeConfigWrap.getChildNodes("supported-locale")) != null) {
            int i = 0;
            while (i < list.size()) {
                ((IDOMNode)list.get(i)).addAdapter((INodeAdapter)this);
                ++i;
            }
        }
    }

    protected void unhookFromModel(Object model) {
        if (!(model instanceof IStructuredModel)) {
            return;
        }
        IDOMDocument document = ((IDOMModel)model).getDocument();
        ((IDOMNode)document).removeAdapter((INodeAdapter)this);
        FacesConfigDocumentWrap documentWrap = new FacesConfigDocumentWrap((Document)document);
        FacesConfig facesConfig = documentWrap.getFacesConfig();
        if (facesConfig != null) {
            facesConfig.getNode().removeAdapter((INodeAdapter)this);
            NodeWrapUtil facesConfigWrap = new NodeWrapUtil(facesConfig.getNode());
            IDOMNode applicationNode = (IDOMNode)facesConfigWrap.getChildNode("application");
            if (applicationNode != null) {
                this.unhookFromApplication(applicationNode);
            }
        }
    }

    protected void unhookFromApplication(IDOMNode applicationNode) {
        applicationNode.removeAdapter((INodeAdapter)this);
        NodeWrapUtil applicationWrap = new NodeWrapUtil(applicationNode);
        IDOMNode localeConfigNode = (IDOMNode)applicationWrap.getChildNode("locale-config");
        if (localeConfigNode != null) {
            this.unhookFromLocaleConfig(localeConfigNode);
        }
    }

    private void unhookFromLocaleConfig(IDOMNode localeConfigNode) {
        List list;
        localeConfigNode.removeAdapter((INodeAdapter)this);
        NodeWrapUtil localeConfigWrap = new NodeWrapUtil(localeConfigNode);
        IDOMNode defaultLocalNode = (IDOMNode)localeConfigWrap.getChildNode("default-locale");
        if (defaultLocalNode != null) {
            defaultLocalNode.removeAdapter((INodeAdapter)this);
        }
        if ((list = localeConfigWrap.getChildNodes("supported-locale")) != null) {
            int i = 0;
            while (i < list.size()) {
                ((IDOMNode)list.get(i)).removeAdapter((INodeAdapter)this);
                ++i;
            }
        }
    }

    public ISSESection createSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, IFormPage editor) {
        LocaleConfigSection section = new LocaleConfigSection(parent, managedForm, toolkit, editor);
        section.initialize();
        this.setSection(section);
        return section;
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.sectionparts.ISSESectionPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (!(notifier instanceof IDOMNode)) {
            return;
        }
        if (notifier instanceof Document) {
            this.setModel(((IDOMNode)notifier).getModel());
        }
        if (eventType == 5 || eventType == 4) {
            if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("locale-config")) {
                this.processLocaleConfigChanged((IDOMNode)notifier);
            } else if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("default-locale")) {
                this.processDefaultLocalChanged((IDOMNode)notifier);
            } else if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("supported-locale")) {
                this.processSupportedLocalChanged((IDOMNode)notifier);
            }
        } else if (eventType == 2) {
            if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("faces-config")) {
                if (newValue instanceof IDOMNode && ((IDOMNode)newValue).getNodeName().equalsIgnoreCase("application")) {
                    this.processAddApplication((IDOMNode)notifier, (IDOMNode)newValue);
                }
            } else if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("application")) {
                if (newValue instanceof IDOMNode && ((IDOMNode)newValue).getNodeName().equalsIgnoreCase("locale-config")) {
                    this.processAddLocaleConfig((IDOMNode)notifier, (IDOMNode)newValue);
                }
            } else if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("locale-config") && newValue instanceof IDOMNode) {
                if (((IDOMNode)newValue).getNodeName().equalsIgnoreCase("default-locale")) {
                    ((IDOMNode)newValue).addAdapter((INodeAdapter)this);
                } else if (((IDOMNode)newValue).getNodeName().equalsIgnoreCase("supported-locale")) {
                    ((IDOMNode)newValue).addAdapter((INodeAdapter)this);
                }
            }
        } else if (eventType == 3) {
            if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("faces-config")) {
                if (changedFeature instanceof IDOMNode && ((IDOMNode)changedFeature).getNodeName().equalsIgnoreCase("application")) {
                    this.processRemoveApplication((IDOMNode)notifier, (IDOMNode)changedFeature);
                }
            } else if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("application")) {
                if (changedFeature instanceof IDOMNode && ((IDOMNode)changedFeature).getNodeName().equalsIgnoreCase("locale-config")) {
                    this.processRemoveLocaleConfig((IDOMNode)notifier, (IDOMNode)changedFeature);
                }
            } else if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("locale-config") && changedFeature instanceof IDOMNode) {
                if (((IDOMNode)changedFeature).getNodeName().equalsIgnoreCase("default-locale")) {
                    this.processRemoveDefaultLocale((IDOMNode)changedFeature);
                } else if (((IDOMNode)changedFeature).getNodeName().equalsIgnoreCase("supported-locale")) {
                    this.processRemoveSupportedLocale((IDOMNode)changedFeature);
                }
            }
        }
    }

    private void processRemoveSupportedLocale(IDOMNode node) {
        node.removeAdapter((INodeAdapter)this);
        this.refreshTableViewer(null, true);
    }

    private void processRemoveDefaultLocale(IDOMNode node) {
        node.removeAdapter((INodeAdapter)this);
        this.refreshTableViewer(null, true);
    }

    private void processSupportedLocalChanged(IDOMNode node) {
        this.refreshTableViewer(node, false);
    }

    private void processDefaultLocalChanged(IDOMNode node) {
        this.refreshTableViewer(node, false);
    }

    private void processLocaleConfigChanged(IDOMNode node) {
        this.refreshTableViewer((IDOMNode)node.getParentNode(), false);
    }

    private void processRemoveLocaleConfig(IDOMNode parentNode, IDOMNode node) {
        this.unhookFromLocaleConfig(node);
        this.refreshTableViewer(null, true);
    }

    private void processRemoveApplication(IDOMNode notifier, IDOMNode changedFeature) {
        this.unhookFromApplication(changedFeature);
        this.refreshTableViewer(null, true);
    }

    private void processAddLocaleConfig(IDOMNode parentNode, IDOMNode node) {
        this.hookIntoLocaleConfig(node);
        ((LocaleConfigSection)this.getSection()).refreshAll();
    }

    private void processAddApplication(IDOMNode parentNode, IDOMNode node) {
        this.hookIntoApplication(node);
        ((LocaleConfigSection)this.getSection()).refreshAll();
    }

    private void refreshTableViewer(IDOMNode node, boolean needRefreshAll) {
        ((LocaleConfigSection)this.getSection()).refreshTableViewer(node, needRefreshAll);
    }

    public String getLabel(IDOMNode node) {
        LocaleConfigContentLabelProvider labelProvider = new LocaleConfigContentLabelProvider();
        return String.valueOf(node.getLocalName().trim()) + " \"" + labelProvider.getText(node).trim() + "\"";
    }
}

