/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sectionparts;

import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfigDocumentWrap;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.providers.ManagedBeanLabelProvider;
import org.eclipse.wtp.jsf.facesconfig.editor.sectionparts.AbstractSSESectionPart;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.ISSESection;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.ManagedBeansSection;
import org.w3c.dom.Document;

public class ManagedBeansSectionPart
extends AbstractSSESectionPart {
    static /* synthetic */ Class class$0;

    public void hookIntoManagedBean(IDOMNode beanNode) {
        IDOMNode scopeNode;
        NodeWrapUtil beanWrap = new NodeWrapUtil(beanNode);
        beanNode.addAdapter((INodeAdapter)this);
        IDOMNode nameNode = (IDOMNode)beanWrap.getChildNode("managed-bean-name");
        if (nameNode != null) {
            nameNode.addAdapter((INodeAdapter)this);
        }
        if ((scopeNode = (IDOMNode)beanWrap.getChildNode("managed-bean-scope")) != null) {
            scopeNode.addAdapter((INodeAdapter)this);
        }
    }

    protected void hookIntoModel(Object model) {
        if (!(model instanceof IStructuredModel)) {
            return;
        }
        IDOMDocument document = ((IDOMModel)model).getDocument();
        FacesConfigDocumentWrap documentWrap = new FacesConfigDocumentWrap((Document)document);
        ((IDOMNode)document).addAdapter((INodeAdapter)this);
        FacesConfig facesConfig = documentWrap.getFacesConfig();
        if (facesConfig != null) {
            facesConfig.getNode().addAdapter((INodeAdapter)this);
            Iterator iter = facesConfig.getManagedBeanList().iterator();
            while (iter.hasNext()) {
                ManagedBean bean = (ManagedBean)iter.next();
                this.hookIntoManagedBean(bean.getNode());
            }
        }
    }

    public void unhookFromManagedBean(IDOMNode beanNode) {
        IDOMNode scopeNode;
        NodeWrapUtil beanWrap = new NodeWrapUtil(beanNode);
        beanNode.removeAdapter((INodeAdapter)this);
        IDOMNode nameNode = (IDOMNode)beanWrap.getChildNode("managed-bean-name");
        if (nameNode != null) {
            nameNode.removeAdapter((INodeAdapter)this);
        }
        if ((scopeNode = (IDOMNode)beanWrap.getChildNode("managed-bean-scope")) != null) {
            scopeNode.removeAdapter((INodeAdapter)this);
        }
    }

    protected void unhookFromModel(Object model) {
        if (!(model instanceof IStructuredModel)) {
            return;
        }
        IDOMDocument document = ((IDOMModel)model).getDocument();
        ((IDOMNode)document).removeAdapter((INodeAdapter)this);
        FacesConfigDocumentWrap documentWrap = new FacesConfigDocumentWrap((Document)document);
        FacesConfig facesConfig = documentWrap.getFacesConfig();
        if (facesConfig != null) {
            facesConfig.getNode().removeAdapter((INodeAdapter)this);
            Iterator iter = facesConfig.getManagedBeanList().iterator();
            while (iter.hasNext()) {
                ManagedBean bean = (ManagedBean)iter.next();
                this.unhookFromManagedBean(bean.getNode());
            }
        }
    }

    public ISSESection createSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, IFormPage editor) {
        ManagedBeansSection managedBeansSection = new ManagedBeansSection(parent, managedForm, toolkit, editor);
        managedBeansSection.initialize();
        this.setSection(managedBeansSection);
        return managedBeansSection;
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.sectionparts.ISSESectionPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (!(notifier instanceof IDOMNode)) {
            return;
        }
        if (notifier instanceof Document) {
            this.setModel(((IDOMNode)notifier).getModel());
        }
        if (eventType == 5) {
            if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("managed-bean-name")) {
                this.processManagedBeanNameChanged((IDOMNode)notifier);
            } else if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("managed-bean-scope")) {
                this.processManagedBeanScopeChanged((IDOMNode)notifier);
            }
        } else if (eventType == 2) {
            if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("faces-config")) {
                if (newValue instanceof IDOMNode && ((IDOMNode)newValue).getNodeName().equalsIgnoreCase("managed-bean")) {
                    this.processAddMangedBean((IDOMNode)newValue);
                }
            } else if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("managed-bean")) {
                if (newValue instanceof IDOMNode) {
                    if (((IDOMNode)newValue).getNodeName().equalsIgnoreCase("managed-bean-name")) {
                        this.processAddMangedBeanName((IDOMNode)notifier, (IDOMNode)newValue);
                    } else if (((IDOMNode)newValue).getNodeName().equalsIgnoreCase("managed-bean-scope")) {
                        this.processAddMangedBeanScope((IDOMNode)notifier, (IDOMNode)newValue);
                    }
                }
            } else if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("managed-bean-name")) {
                if (newValue instanceof IDOMNode) {
                    this.processManagedBeanNameChanged((IDOMNode)notifier);
                }
            } else if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("managed-bean-scope") && newValue instanceof IDOMNode) {
                this.processManagedBeanScopeChanged((IDOMNode)notifier);
            }
        } else if (eventType == 3) {
            if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("faces-config")) {
                if (changedFeature instanceof IDOMNode && ((IDOMNode)changedFeature).getNodeName().equalsIgnoreCase("managed-bean")) {
                    this.processRemoveMangedBean((IDOMNode)changedFeature);
                }
            } else if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("managed-bean") && changedFeature instanceof IDOMNode) {
                if (((IDOMNode)changedFeature).getNodeName().equalsIgnoreCase("managed-bean-name")) {
                    this.processRemoveMangedBeanName((IDOMNode)notifier, (IDOMNode)changedFeature);
                } else if (((IDOMNode)changedFeature).getNodeName().equalsIgnoreCase("managed-bean-scope")) {
                    this.processRemoveMangedBeanScope((IDOMNode)notifier, (IDOMNode)changedFeature);
                }
            }
        }
    }

    private void processAddMangedBean(IDOMNode node) {
        this.hookIntoManagedBean(node);
        ((ManagedBeansSection)this.getSection()).refreshTreeViewer(node, true);
    }

    private void processAddMangedBeanScope(IDOMNode parentNode, IDOMNode node) {
        node.addAdapter((INodeAdapter)this);
        ((ManagedBeansSection)this.getSection()).refreshTreeViewer(parentNode, true);
    }

    private void processAddMangedBeanName(IDOMNode parentNode, IDOMNode node) {
        node.addAdapter((INodeAdapter)this);
        ((ManagedBeansSection)this.getSection()).refreshTreeViewer(parentNode, false);
    }

    private void processRemoveMangedBeanScope(IDOMNode parentNode, IDOMNode node) {
        node.removeAdapter((INodeAdapter)this);
        ((ManagedBeansSection)this.getSection()).refreshTreeViewer(null, true);
    }

    private void processRemoveMangedBeanName(IDOMNode parentNode, IDOMNode node) {
        node.removeAdapter((INodeAdapter)this);
        ((ManagedBeansSection)this.getSection()).refreshTreeViewer(parentNode, false);
    }

    private void processRemoveMangedBean(IDOMNode node) {
        this.unhookFromManagedBean(node);
        ((ManagedBeansSection)this.getSection()).refreshTreeViewer(null, true);
    }

    private void processManagedBeanScopeChanged(IDOMNode node) {
        ((ManagedBeansSection)this.getSection()).refreshTreeViewer((IDOMNode)node.getParentNode(), true);
    }

    private void processManagedBeanNameChanged(IDOMNode node) {
        ((ManagedBeansSection)this.getSection()).refreshTreeViewer((IDOMNode)node.getParentNode(), false);
    }

    private boolean isValidSelection() {
        Iterator iter;
        ISelection selection = this.getSection().getSite().getSelectionProvider().getSelection();
        return selection instanceof IStructuredSelection && (iter = ((IStructuredSelection)selection).iterator()).next() instanceof IDOMNode;
    }

    public String getLabel(IDOMNode node) {
        ManagedBeanLabelProvider labelProvider = new ManagedBeanLabelProvider();
        return "managed-bean \"" + labelProvider.getText(node) + "\"";
    }
}

