/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.FacesConfigEditor;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.ChangeSingleNodeValueCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.ClassButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldApplyListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldChangeListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.pages.ComponentsPage;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.AbstractSSESection;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;

public class ComponentsGeneralSection
extends AbstractSSESection {
    private static EditorResources resource = EditorResources.getInstance();
    private IFormPage formPage;
    private StringDialogField displayNameField;
    private StringDialogField descriptionField;
    private StringDialogField componentTypeField;
    private ClassButtonDialogField componentClassField;
    private IProject currentProject;

    public ComponentsGeneralSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, int style, String helpContextId, String helpTooltip) {
        super(parent, managedForm, toolkit, style, helpContextId, helpTooltip);
    }

    public ComponentsGeneralSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, String helpContextId, String helpTooltip) {
        super(parent, managedForm, toolkit, helpContextId, helpTooltip);
    }

    public ComponentsGeneralSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit) {
        super(parent, managedForm, toolkit);
    }

    public ComponentsGeneralSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, IFormPage editor) {
        this(parent, managedForm, toolkit, resource.getString("ComponentsPage.ComponentsSection.General.HelpContextID"), resource.getString("ComponentsPage.ComponentsSection.General.HelpToolTip"));
        this.formPage = editor;
        this.setText(resource.getString("ComponentsPage.ComponentsSection.General.Name"));
        this.setDescription(resource.getString("ComponentsPage.ComponentsSection.General.Description"));
    }

    protected void createContents(Composite container, FormToolkit toolkit) {
        int numberOfColumns = 4;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        container.setLayout((Layout)layout);
        GridData td = new GridData(768);
        container.setLayoutData((Object)td);
        IDialogFieldChangeListener dialogFieldChangeListener = new IDialogFieldChangeListener(){

            public void dialogFieldChanged(DialogField field) {
                ((FacesConfigEditor)((ComponentsPage)ComponentsGeneralSection.this.formPage).getEditor()).setDirty(true);
            }
        };
        toolkit.paintBordersFor(container);
        this.displayNameField = new StringDialogField();
        this.displayNameField.setLabelText(resource.getString("ComponentsPage.ComponentsSection.General.Label.DisplayName"));
        this.displayNameField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.displayNameField.setDialogFieldChangeListener(dialogFieldChangeListener);
        this.displayNameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newNameValue = ((StringDialogField)field).getText();
                ChangeSingleNodeValueCommand changeCmd = new ChangeSingleNodeValueCommand(resource.getString("ComponentsPage.ComponentsSection.General.SetComponentDisplayName"), ComponentsGeneralSection.this.getSectionPart(), "display-name", newNameValue);
                changeCmd.execute();
            }
        });
        this.descriptionField = new StringDialogField(2);
        this.descriptionField.setLabelText(resource.getString("ComponentsPage.ComponentsSection.General.Label.Description"));
        this.descriptionField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.descriptionField.setDialogFieldChangeListener(dialogFieldChangeListener);
        this.descriptionField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newDescription = ((StringDialogField)field).getText();
                ChangeSingleNodeValueCommand changeCmd = new ChangeSingleNodeValueCommand(resource.getString("ComponentsPage.ComponentsSection.General.SetComponentDescription"), ComponentsGeneralSection.this.getSectionPart(), "description", newDescription);
                changeCmd.execute();
            }
        });
        this.componentTypeField = new StringDialogField();
        this.componentTypeField.setLabelText(resource.getString("ComponentsPage.ComponentsSection.General.Label.ComponentType"));
        this.componentTypeField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.componentTypeField.setDialogFieldChangeListener(dialogFieldChangeListener);
        this.componentTypeField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newComponetType = ((StringDialogField)field).getText();
                ChangeSingleNodeValueCommand changeCmd = new ChangeSingleNodeValueCommand(resource.getString("ComponentsPage.ComponentsSection.General.SetComponentType"), ComponentsGeneralSection.this.getSectionPart(), "component-type", newComponetType);
                changeCmd.execute();
            }
        });
        this.componentClassField = new ClassButtonDialogField(this.getProject());
        this.componentClassField.setLabelText(resource.getString("ComponentsPage.ComponentsSection.General.Label.ComponentClass"));
        this.componentClassField.doFillIntoGrid(toolkit, container, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.componentClassField.getTextControl(toolkit, container));
        this.componentClassField.getTextControl(toolkit, container).setEditable(true);
        this.componentClassField.setDialogFieldChangeListener(dialogFieldChangeListener);
        this.componentClassField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newComponetClass = ((StringDialogField)field).getText();
                ChangeSingleNodeValueCommand changeCmd = new ChangeSingleNodeValueCommand(resource.getString("ComponentsPage.ComponentsSection.General.SetComponentClass"), ComponentsGeneralSection.this.getSectionPart(), "component-class", newComponetClass);
                changeCmd.execute();
            }
        });
        this.componentClassField.setSuperClassName("javax.faces.component.UIComponent");
        EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)container, resource.getString("ComponentsPage.ComponentsSection.General.HelpContextID"));
    }

    private IProject getProject() {
        if (this.currentProject == null && this.getInput() instanceof IDOMNode) {
            this.currentProject = StructuredModelUtil.getProjectFor((IDOMNode)this.getInput());
        }
        return this.currentProject;
    }

    public void clearAll() {
        this.displayNameField.setTextWithoutUpdate("");
        this.descriptionField.setTextWithoutUpdate("");
        this.componentTypeField.setTextWithoutUpdate("");
        this.componentClassField.setTextWithoutUpdate("");
    }

    public void refreshAll() {
        if (this.getInput() instanceof IDOMNode) {
            this.clearAll();
            NodeWrapUtil componentWrap = new NodeWrapUtil((IDOMNode)this.getInput());
            this.displayNameField.setTextWithoutUpdate(componentWrap.getChildNodeValue("display-name"));
            this.descriptionField.setTextWithoutUpdate(componentWrap.getChildNodeValue("description"));
            this.componentTypeField.setTextWithoutUpdate(componentWrap.getChildNodeValue("component-type"));
            this.componentClassField.setTextWithoutUpdate(componentWrap.getChildNodeValue("component-class"));
        }
    }

    public IWorkbenchPartSite getSite() {
        return this.formPage.getSite();
    }

    public ClassButtonDialogField getComponentClassField() {
        return this.componentClassField;
    }

    public StringDialogField getComponentTypeField() {
        return this.componentTypeField;
    }

    public StringDialogField getDescriptionField() {
        return this.descriptionField;
    }

    public StringDialogField getDisplayNameField() {
        return this.displayNameField;
    }

    public void setInput(Object newInput) {
        super.setInput(newInput);
        this.componentClassField.setProject(this.getProject());
    }
}

