/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.actions.ManagedBeanOpenAction;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.AddManagedBeanCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfigDocumentWrap;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBeanScopeTreeItem;
import org.eclipse.wtp.jsf.facesconfig.editor.providers.ManagedBeanContentProvider;
import org.eclipse.wtp.jsf.facesconfig.editor.providers.ManagedBeanLabelProvider;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.AbstractSSESection;
import org.w3c.dom.Document;

public class ManagedBeansSection
extends AbstractSSESection
implements ISelectionProvider,
ISelectionChangedListener {
    private static EditorResources resource = EditorResources.getInstance();
    private TreeViewer treeViewer;
    private IFormPage editor;
    private static final String DATABINDING_CONTEXTMENU_REG_ID = ".databinding.editor.contextmenu";
    protected List selectionChangedListeners = new ArrayList();
    private Button addButton;
    private Button removeButton;
    private ManagedBeanContentProvider contentProvider;
    protected INodeSelectionListener fNodeSelectionListener;
    static /* synthetic */ Class class$0;

    public ManagedBeansSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, IFormPage editor) {
        super(parent, managedForm, toolkit, resource.getString("ManagedBeansPage.ManagedBeansSection.HelpContextID"), resource.getString("ManagedBeansPage.ManagedBeansSection.HelpToolTip"));
        this.setText(resource.getString("ManagedBeansPage.ManagedBeansSection.Name"));
        this.setDescription(resource.getString("ManagedBeansPage.ManagedBeansSection.Description"));
        this.editor = editor;
    }

    protected void createContents(Composite container, FormToolkit toolkit) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.createViewer(container, toolkit);
        this.configureViewer();
        this.createOperationSection(container, toolkit);
        EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)container, resource.getString("ManagedBeansPage.ManagedBeansSection.HelpContextID"));
    }

    private void createOperationSection(Composite parent, FormToolkit toolkit) {
        Composite operationContainer = toolkit.createComposite(parent);
        GridData gd = new GridData(1040);
        operationContainer.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        operationContainer.setLayout((Layout)layout);
        this.addButton = toolkit.createButton(operationContainer, resource.getString("ManagedBeansPage.ManagedBeansSection.Button.Add.Name"), 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.addButton.setLayoutData((Object)gd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagedBeansSection.this.addButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ManagedBeansSection.this.addButtonSelected(e);
            }
        });
        this.removeButton = toolkit.createButton(operationContainer, resource.getString("ManagedBeansPage.ManagedBeansSection.Button.Remove.Name"), 8);
        this.removeButton.setEnabled(false);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagedBeansSection.this.removeButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ManagedBeansSection.this.removeButtonSelected(e);
            }
        });
    }

    private void addButtonSelected(SelectionEvent e) {
        AddManagedBeanCommand addCommand = new AddManagedBeanCommand("Add Managed Bean", this.getSectionPart());
        addCommand.execute();
    }

    private void removeButtonSelected(SelectionEvent e) {
        GroupRequest deleteReq = new GroupRequest((Object)"delete");
        Command cmd = this.getSectionPart().getCommand((Request)deleteReq);
        if (cmd != null) {
            cmd.execute();
        }
    }

    public INodeSelectionListener getNodeSelectionListener() {
        if (this.fNodeSelectionListener == null) {
            this.fNodeSelectionListener = new SSENodeSelectionListener();
        }
        return this.fNodeSelectionListener;
    }

    private IDOMNode getManagedBeanNode(IDOMNode xmlNode) {
        IDOMNode managedBean = null;
        if (xmlNode != null) {
            managedBean = xmlNode.getNodeName().equalsIgnoreCase("managed-bean") ? xmlNode : this.getManagedBeanNode((IDOMNode)xmlNode.getParentNode());
        }
        return managedBean;
    }

    private void createViewer(Composite parent, FormToolkit toolkit) {
        Composite treeContainer = toolkit.createComposite(parent);
        toolkit.paintBordersFor(treeContainer);
        GridData gd = new GridData(1808);
        treeContainer.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        treeContainer.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(treeContainer, 772);
        gd = new GridData(1808);
        this.treeViewer.getControl().setLayoutData((Object)gd);
        this.contentProvider = new ManagedBeanContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ManagedBeanLabelProvider());
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.setAutoExpandLevel(3);
    }

    protected void configureViewer() {
        if (this.treeViewer == null) {
            return;
        }
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ManagedBeansSection.this.treeViewerDoubleClicked(event);
            }
        });
    }

    private ActionRegistry getActionRegistry() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.ui.actions.ActionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ActionRegistry)this.editor.getAdapter((Class)clazz);
    }

    private void treeViewerDoubleClicked(DoubleClickEvent event) {
        ManagedBeanOpenAction openAction = (ManagedBeanOpenAction)this.getActionRegistry().getAction((Object)"com.sybase.stf.jmt.editors.managedbean.openeditor");
        if (openAction.isEnabled()) {
            openAction.run();
        }
    }

    private void setViewInput(IStructuredModel model) {
        IDOMDocument document = ((IDOMModel)model).getDocument();
        FacesConfigDocumentWrap documentWrap = new FacesConfigDocumentWrap((Document)document);
        FacesConfig facesConfig = documentWrap.getFacesConfig();
        if (facesConfig != null) {
            this.treeViewer.setInput((Object)facesConfig.getNode());
            this.treeViewer.refresh();
            this.ensureTreeViewerSelection(true);
        }
    }

    private void ensureTreeViewerSelection(boolean beanSelected) {
        Object[] rootItems = this.contentProvider.getElements(this.treeViewer.getInput());
        if (rootItems.length > 0) {
            Object selectedItem = rootItems[0];
            if (beanSelected) {
                int i = 0;
                while (i < rootItems.length) {
                    Object[] beans;
                    Object scopeItem = rootItems[i];
                    if (scopeItem instanceof ManagedBeanScopeTreeItem && (beans = this.contentProvider.getChildren(scopeItem)).length > 0) {
                        selectedItem = beans[0];
                        break;
                    }
                    ++i;
                }
            }
            this.treeViewer.reveal(selectedItem);
            this.treeViewer.setSelection((ISelection)new StructuredSelection(selectedItem));
        }
    }

    public void refreshTreeViewer(final IDOMNode node, final boolean needRefreshAll) {
        this.getManagedForm().getForm().getDisplay().syncExec(new Runnable(){

            public void run() {
                ManagedBean bean;
                if (needRefreshAll) {
                    ManagedBeansSection.this.refreshAllTreeViewer(node);
                } else if (node != null && (bean = new ManagedBean(node)).isValid()) {
                    ManagedBeansSection.this.treeViewer.refresh((Object)node, true);
                }
            }
        });
    }

    private void refreshAllTreeViewer(IDOMNode node) {
        this.treeViewer.refresh();
        if (node != null) {
            ManagedBean bean = new ManagedBean(node);
            if (bean.isValid()) {
                this.treeViewer.reveal((Object)node);
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)node));
            } else {
                this.ensureTreeViewerSelection(false);
            }
        } else {
            this.ensureTreeViewerSelection(false);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        if (this.treeViewer.getSelection() != null) {
            Object selectItem = ((StructuredSelection)this.treeViewer.getSelection()).getFirstElement();
            if (selectItem instanceof IDOMNode) {
                return this.treeViewer.getSelection();
            }
            if (selectItem instanceof ManagedBeanScopeTreeItem) {
                return new StructuredSelection((Object)((ManagedBeanScopeTreeItem)selectItem));
            }
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.treeViewer.setSelection(selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateStatus();
        Iterator listeners = this.selectionChangedListeners.iterator();
        while (listeners.hasNext()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners.next();
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    protected List getSelectedObjects() {
        if (!(this.getSelection() instanceof IStructuredSelection)) {
            return Collections.EMPTY_LIST;
        }
        return ((IStructuredSelection)this.getSelection()).toList();
    }

    private void updateStatus() {
        boolean bRemoveButtonEnabled = false;
        List selectedObjects = this.getSelectedObjects();
        if (!selectedObjects.isEmpty() && selectedObjects.get(0) instanceof IDOMNode && ((IDOMNode)selectedObjects.get(0)).getNodeName().equalsIgnoreCase("managed-bean")) {
            bRemoveButtonEnabled = true;
        }
        this.removeButton.setEnabled(bRemoveButtonEnabled);
    }

    public IWorkbenchPartSite getSite() {
        return this.editor.getSite();
    }

    public void refreshAll() {
        if (this.getInput() instanceof IStructuredModel) {
            this.setViewInput((IStructuredModel)this.getInput());
        }
    }

    public void clearAll() {
    }

    class SSENodeSelectionListener
    implements INodeSelectionListener {
        SSENodeSelectionListener() {
        }

        public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
            IDOMNode managedBeanNode;
            if (event.getSource().equals(ManagedBeansSection.this.treeViewer)) {
                return;
            }
            List selectedNodes = event.getSelectedNodes();
            if (selectedNodes != null && selectedNodes.size() > 0 && selectedNodes.get(0) instanceof IDOMNode && (managedBeanNode = ManagedBeansSection.this.getManagedBeanNode((IDOMNode)selectedNodes.get(0))) != null && ManagedBeansSection.this.treeViewer.getSelection() != null && !ManagedBeansSection.this.treeViewer.getSelection().isEmpty() && ((StructuredSelection)ManagedBeansSection.this.treeViewer.getSelection()).getFirstElement() != managedBeanNode) {
                StructuredSelection selection = new StructuredSelection((Object)managedBeanNode);
                ManagedBeansSection.this.treeViewer.setSelection((ISelection)selection, true);
            }
        }
    }
}

