/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.actions.OpenPageAction;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NavigationCase;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NavigationRule;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.AbstractOverviewSection;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigUtil;

public class OverviewNavigationSection
extends AbstractOverviewSection {
    private static EditorResources resource = EditorResources.getInstance();
    private static final int FROM_ID = 0;
    private static final int FROM_OUTCOME = 1;
    private static final int TO_ID = 2;
    private static final int COLUMN_WITH = 70;
    private TableViewer tableViewer;

    public OverviewNavigationSection(IManagedForm managedForm, FormToolkit toolkit, FormEditor editor) {
        super(editor, managedForm, toolkit, 194, resource.getString("OverviewPage.NavigationSection.Help.HelpContextID"), resource.getString("OverviewPage.NavigationSection.Help.HelpToolTip"));
        this.setText(resource.getString("OverviewPage.NavigationSection.name"));
        this.setDescription(resource.getString("OverviewPage.NavigationSection.description"));
    }

    public Composite createClient(Composite container, FormToolkit factory) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        factory.paintBordersFor(container);
        Table table = new Table(container, 66304);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 100;
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableLayout tablelayout = new TableLayout();
        table.setLayout((Layout)tablelayout);
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(resource.getString("OverviewPage.NavigationSection.table.col1"));
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 70, true));
        column1.setResizable(true);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(resource.getString("OverviewPage.NavigationSection.table.col2"));
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 70, true));
        column2.setResizable(true);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(resource.getString("OverviewPage.NavigationSection.table.col3"));
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 70, true));
        column3.setResizable(true);
        table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                OpenPageAction action = new OpenPageAction();
                action.setPageName("org.eclipse.wtp.jsf.facesconfig.editor.pageflow.PageflowEditor");
                action.run();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setSorter(new ViewerSorter());
        EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)container, resource.getString("OverviewPage.NavigationSection.Help.HelpContextID"));
        return container;
    }

    public void refreshAll() {
        if (this.getInput() == null || !(this.getInput() instanceof IDOMModel)) {
            return;
        }
        List elemList = null;
        List ncaseList = null;
        NavigationRule navigation = null;
        NavigationCase ncase = null;
        FacesConfig fconfig = FacesConfigUtil.getFacesConfig((IStructuredModel)((IDOMModel)this.getInput()));
        if (fconfig != null) {
            elemList = fconfig.getNavigationList();
            int count = elemList.size();
            ArrayList<NavigationElement> navigationList = new ArrayList<NavigationElement>(count);
            int i = 0;
            while (i < count) {
                navigation = (NavigationRule)elemList.get(i);
                if (navigation != null && (ncaseList = navigation.getNavigationCaseList()) != null) {
                    int j = 0;
                    int n = ncaseList.size();
                    while (j < n) {
                        ncase = (NavigationCase)ncaseList.get(j);
                        NavigationElement elem = new NavigationElement();
                        elem.setFromId(navigation.getFromViewId());
                        elem.setFromOutcome(ncase.getFromOutcome());
                        elem.setToId(ncase.getToViewId());
                        navigationList.add(elem);
                        ++j;
                    }
                }
                ++i;
            }
            this.tableViewer.setInput(navigationList);
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            NavigationElement elem = (NavigationElement)element;
            switch (columnIndex) {
                case 0: {
                    return elem.getFromId();
                }
                case 1: {
                    return elem.getFromOutcome();
                }
                case 2: {
                    return elem.getToId();
                }
            }
            return "";
        }
    }

    class NavigationElement {
        String _fromid;
        String _fromoutcome;
        String _toid;

        public NavigationElement(String fromid, String fromoutcome, String toid) {
            this._fromid = fromid;
            this._fromoutcome = fromoutcome;
            this._toid = toid;
        }

        public NavigationElement() {
        }

        void setFromId(String value) {
            this._fromid = value;
        }

        void setFromOutcome(String value) {
            this._fromoutcome = value;
        }

        void setToId(String value) {
            this._toid = value;
        }

        public String getFromId() {
            return this._fromid;
        }

        public String getFromOutcome() {
            return this._fromoutcome;
        }

        public String getToId() {
            return this._toid;
        }

        public String toString() {
            return String.valueOf(this._fromid) + "\\t" + this._fromoutcome + "\\t" + this._toid;
        }
    }
}

