/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.IMediator;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.ISkippable;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.ISummaryDataSource;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.IWizardAction;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.NewWizard;

public abstract class NewPage
extends WizardPage
implements IWizardAction,
ISkippable,
ISummaryDataSource {
    private boolean skippable = false;

    protected static boolean hasIllegalCharacters(String text) {
        if (text.length() == 0 || !Character.isJavaIdentifierStart(text.charAt(0))) {
            return true;
        }
        int i = 1;
        int n = text.length();
        while (i < n) {
            if (!Character.isJavaIdentifierPart(text.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public NewPage(String name) {
        super(name);
        this.setPageComplete(false);
    }

    public String[] getProjectNames() {
        int i = 0;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        int x = 0;
        while (x < projects.length) {
            if (projects[x].isOpen()) {
                ++i;
            }
            ++x;
        }
        String[] validProjects = new String[i];
        i = 0;
        int x2 = 0;
        while (x2 < projects.length) {
            if (projects[x2].isOpen()) {
                validProjects[i] = projects[x2].getName();
                ++i;
            }
            ++x2;
        }
        return validProjects;
    }

    public boolean getSkippable() {
        return this.skippable;
    }

    public List getSummaryData() {
        return new ArrayList();
    }

    public String getWorkspaceProject() {
        IStructuredSelection ssel;
        Object obj;
        String[] projects = this.getProjectNames();
        IWizard wizard = this.getWizard();
        ISelection selection = null;
        String selectedProject = "";
        if (projects.length == 0) {
            return "";
        }
        if (wizard instanceof NewWizard) {
            selection = ((NewWizard)wizard).getSelection();
        }
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (obj = (ssel = (IStructuredSelection)selection).getFirstElement()) != null) {
            if (obj instanceof IProject) {
                selectedProject = ((IProject)obj).getName();
            } else if (obj instanceof IJavaProject) {
                selectedProject = ((IJavaProject)obj).getProject().getName();
            } else if (obj instanceof IFile) {
                selectedProject = ((IFile)obj).getProject().getName();
            } else if (obj instanceof IFolder) {
                selectedProject = ((IFolder)obj).getProject().getName();
            } else if (obj instanceof IPackageFragmentRoot) {
                IJavaElement element = ((IPackageFragmentRoot)obj).getParent();
                IResource resource = element.getResource();
                selectedProject = resource.getName();
            } else if (obj instanceof IPackageFragment) {
                IJavaElement element = ((IPackageFragment)obj).getParent();
                IResource resource = element.getResource();
                selectedProject = resource.getProject().getName();
            }
        }
        return selectedProject;
    }

    public void onSetActive() {
    }

    public boolean onWizardNext() {
        IWizard wizard = this.getWizard();
        IMediator mediator = null;
        if (wizard instanceof IMediator) {
            mediator = (IMediator)wizard;
            mediator.mediatePage((IWizardPage)this);
        }
        return true;
    }

    public void setSkippable(boolean b) {
        this.skippable = b;
    }

    protected boolean canFinish() {
        return false;
    }

    protected abstract void dialogChanged();

    protected ModifyListener getModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPage.this.setPageComplete(NewPage.this.isPageComplete());
            }
        };
    }

    protected SelectionAdapter getSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewPage.this.setPageComplete(NewPage.this.isPageComplete());
            }
        };
    }

    protected abstract void initialize();

    protected void updateStatus(String message) {
        this.setErrorMessage(message);
    }

    private boolean isWebAppProject(IProject project) {
        try {
            return project.isOpen() && project.getNature("com.sybase.stf.jmt.WebappNature") != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

