/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.ManagedBeanUtils;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.ISkippable;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.ISummaryDataSource;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.IManagedBeanDataSource;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.JavaSelectionWizardPage;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.ManagedBeanConfiguration;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.WizardsResources;

public class NewClassWizardPage
extends org.eclipse.jdt.ui.wizards.NewClassWizardPage
implements ISummaryDataSource,
ISkippable,
IManagedBeanDataSource {
    private JavaSelectionWizardPage javaSelectionPage;
    private IProject currentProject;
    private ManagedBeanConfiguration managedBeanConfig;

    public NewClassWizardPage(IStructuredSelection selection, JavaSelectionWizardPage javaSelectionPage) {
        this.javaSelectionPage = javaSelectionPage;
    }

    public void init() {
        if (this.loadManagedBeanConfiguration()) {
            this.currentProject = this.managedBeanConfig.getProject();
            if (this.getPackageFragmentRoot() == null || this.currentProject != this.getPackageFragmentRoot().getJavaProject().getProject()) {
                IJavaProject jProject = JavaCore.create((IProject)this.currentProject);
                StructuredSelection selection = new StructuredSelection((Object)jProject);
                this.init((IStructuredSelection)selection);
            }
        }
    }

    private boolean loadManagedBeanConfiguration() {
        ManagedBeanConfiguration mbConfigPrev = null;
        if (this.getPreviousPage() instanceof IManagedBeanDataSource) {
            mbConfigPrev = ((IManagedBeanDataSource)this.getPreviousPage()).getConfiguration();
        }
        if (mbConfigPrev == null) {
            return false;
        }
        ManagedBeanConfiguration mbConfig = this.getConfiguration();
        mbConfig.setFacesConfigFile(mbConfigPrev.getFacesConfigFile());
        if (mbConfig.getProject() != mbConfigPrev.getProject()) {
            mbConfig.setProject(mbConfigPrev.getProject());
            return true;
        }
        return false;
    }

    public List getSummaryData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{WizardsResources.getInstance().getString("NewJavaManagedBeanWizard.Summary.SourceFolder"), this.getPackageFragmentRootText()});
        data.add(new String[]{WizardsResources.getInstance().getString("NewJavaManagedBeanWizard.Summary.PackageName"), this.getPackageText()});
        data.add(new String[]{WizardsResources.getInstance().getString("NewJavaManagedBeanWizard.Summary.TypeName"), this.getTypeName()});
        return data;
    }

    public boolean getSkippable() {
        return !this.javaSelectionPage.isCreateNewJavaClass();
    }

    public void setSkippable(boolean ignore) {
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        this.init();
    }

    public ManagedBeanConfiguration getConfiguration() {
        String refName;
        if (this.managedBeanConfig == null) {
            this.managedBeanConfig = new ManagedBeanConfiguration();
        }
        if ((refName = this.getTypeName()) != null && refName.length() > 0) {
            refName = String.valueOf(refName.substring(0, 1).toLowerCase()) + refName.substring(1);
            refName = ManagedBeanUtils.getDefaultManagedBeanName(this.currentProject, refName);
            String className = this.getPackageText() != null && this.getPackageText().length() > 0 ? String.valueOf(this.getPackageText()) + "." + this.getTypeName() : this.getTypeName();
            this.managedBeanConfig.setName(refName);
            this.managedBeanConfig.setClassName(className);
            this.managedBeanConfig.setPropertyEditable(true);
        }
        return this.managedBeanConfig;
    }

    public List getManagedBeanProperty() {
        return null;
    }
}

