/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.core.jsflibraryregistry;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wtp.jsf.core.internal.JSFCorePlugin;
import org.eclipse.wtp.jsf.core.internal.Messages;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryFactory;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.JSFVersion;
import org.eclipse.wtp.jsf.core.internal.jsflibraryregistry.PluginProvidedJSFLibrary;
import org.eclipse.wtp.jsf.core.jsflibraryregistry.InvalidArchiveFilesCreationException;
import org.eclipse.wtp.jsf.core.jsflibraryregistry.JSFLibraryArchiveFilesDelegate;

public final class PluginProvidedJSFLibraryCreationHelper {
    private IConfigurationElement config_element;
    public static final String NAME = "name";
    public static final String IS_IMPL = "isImplementation";
    public static final String VERSION = "maxVersionSupported";
    public static final String DELEGATE = "archiveFilesDelegate";

    public PluginProvidedJSFLibraryCreationHelper(IConfigurationElement jsfLibrary) {
        this.config_element = jsfLibrary;
    }

    public JSFLibrary create() {
        PluginProvidedJSFLibrary newLib = JSFLibraryRegistryFactory.eINSTANCE.createPluginProvidedJSFLibrary();
        newLib.setID(this.getLibID());
        newLib.setPluginID(this.getPluginID());
        newLib.setName(this.config_element.getAttribute(NAME));
        newLib.setImplementation(this.config_element.getAttribute(IS_IMPL).equals("true"));
        newLib.setJSFVersion(JSFVersion.getJSFVersion(this.config_element.getAttribute(VERSION)));
        try {
            this.addArchives(newLib);
            return newLib;
        }
        catch (Exception e) {
            JSFCorePlugin.log(e, NLS.bind((String)Messages.PluginProvidedJSFLibraryCreationHelper_ErrorCreating, (Object)newLib.getName()));
            return null;
        }
    }

    private void addArchives(JSFLibrary newLib) throws InvalidArchiveFilesCreationException, CoreException {
        JSFLibraryArchiveFilesDelegate jarCol = null;
        ArchiveFile jar = null;
        jarCol = (JSFLibraryArchiveFilesDelegate)this.config_element.createExecutableExtension(DELEGATE);
        if (jarCol != null) {
            jarCol.setConfigurationElement(this.config_element);
            Collection jars = jarCol.getArchiveFiles();
            if (jars == null) {
                return;
            }
            Iterator it = jars.iterator();
            while (it.hasNext()) {
                Object aJar = it.next();
                if (aJar instanceof ArchiveFile) {
                    jar = (ArchiveFile)aJar;
                    if (newLib.containsArchiveFile(jar.getSourceLocation())) continue;
                    newLib.getArchiveFiles().add((Object)jar);
                    continue;
                }
                throw new InvalidArchiveFilesCreationException(NLS.bind((String)Messages.PluginProvidedJSFLibraryCreationHelper_ErrorMultipleDefinition, (Object)jar.getSourceLocation(), (Object)this.config_element.getName()));
            }
        }
    }

    private String getLibID() {
        StringBuffer buf = new StringBuffer(this.config_element.getDeclaringExtension().getUniqueIdentifier());
        buf.append("/").append(this.config_element.getAttribute(NAME));
        return buf.toString();
    }

    private String getPluginID() {
        return this.config_element.getDeclaringExtension().getNamespace();
    }
}

