/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.common.dialogfield;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.DialogFieldBase;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.ISupportTextValue;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.LayoutUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ComboDialogField
extends DialogFieldBase
implements ISupportTextValue {
    private static final int WIDTH_HINT = 10;
    private String text = "";
    private int selectionIndex;
    private String[] items = new String[0];
    private CCombo comboControl;
    private ModifyListener modifyListener;
    private int flags;
    private boolean pending = false;
    private Map entryMap;

    public ComboDialogField(int flags) {
        this.flags = flags;
        this.selectionIndex = -1;
    }

    public Control[] doFillIntoGrid(FormToolkit toolkit, Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Control requiredLabel = this.getRequiredLabelControl(toolkit, parent);
        requiredLabel.setLayoutData((Object)ComboDialogField.gridDataForLabel(1));
        Control label = this.getLabelControl(toolkit, parent);
        label.setLayoutData((Object)ComboDialogField.gridDataForLabel(1));
        CCombo combo = this.getComboControl(toolkit, parent);
        combo.setLayoutData((Object)ComboDialogField.gridDataForCombo(nColumns - 2));
        return new Control[]{requiredLabel, label, combo};
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected static GridData gridDataForCombo(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.widthHint = 10;
        return gd;
    }

    public boolean setFocus() {
        if (this.isOkToUse((Control)this.comboControl)) {
            this.comboControl.setFocus();
        }
        return true;
    }

    public CCombo getComboControl(FormToolkit toolkit, Composite parent) {
        if (this.comboControl == null) {
            this.assertCompositeNotNull(parent);
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ComboDialogField.this.doModifyText(e);
                }
            };
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ComboDialogField.this.doSelectionChanged(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    ComboDialogField.this.handleDefaultSelection(e);
                }
            };
            if (toolkit != null) {
                this.comboControl = new CCombo(parent, this.flags);
                toolkit.adapt((Composite)this.comboControl);
            } else {
                this.comboControl = new CCombo(parent, this.flags | 0x800);
                this.comboControl.setBackground(Display.getCurrent().getSystemColor(25));
            }
            this.comboControl.setItems(this.items);
            if (this.selectionIndex != -1) {
                this.comboControl.select(this.selectionIndex);
            } else {
                this.comboControl.setText(this.text);
            }
            this.comboControl.setFont(parent.getFont());
            this.comboControl.addModifyListener(this.modifyListener);
            this.comboControl.addSelectionListener(selectionListener);
            this.comboControl.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    ComboDialogField.this.doFocusLost(e);
                }
            });
            this.comboControl.setEnabled(this.isEnabled());
        }
        return this.comboControl;
    }

    protected void handleDefaultSelection(SelectionEvent e) {
        if (this.pending) {
            this.pending = false;
            this.dialogFieldApplied();
        }
    }

    protected void doFocusLost(FocusEvent e) {
        if (this.pending) {
            this.pending = false;
            this.dialogFieldApplied();
        }
    }

    private void doModifyText(ModifyEvent e) {
        if (this.isOkToUse((Control)this.comboControl)) {
            this.text = this.getEntryKey(this.comboControl.getText());
            this.selectionIndex = this.comboControl.getSelectionIndex();
        }
        this.pending = true;
        this.dialogFieldChanged();
    }

    private void doSelectionChanged(SelectionEvent e) {
        if (this.isOkToUse((Control)this.comboControl)) {
            this.items = this.comboControl.getItems();
            this.text = this.getEntryKey(this.comboControl.getText());
            this.selectionIndex = this.comboControl.getSelectionIndex();
        }
        this.pending = false;
        this.dialogFieldChangedAndApplied();
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.comboControl)) {
            this.comboControl.setEnabled(this.isEnabled());
        }
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        this.items = items;
        if (this.isOkToUse((Control)this.comboControl)) {
            this.comboControl.setItems(this.items);
        }
        this.pending = false;
    }

    public void setEntryMap(Map map) {
        this.entryMap = map;
        if (this.entryMap == null) {
            this.entryMap = new TreeMap();
        }
        Map.Entry[] entries = this.entryMap.entrySet().toArray(new Map.Entry[0]);
        String[] items = new String[entries.length];
        int i = 0;
        while (i < entries.length) {
            items[i] = entries[i].getValue().toString();
            ++i;
        }
        this.setItems(items);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.setTextWithoutUpdate(text);
        this.pending = false;
        this.dialogFieldChangedAndApplied();
    }

    public void selectItem(int index) {
        if (this.isOkToUse((Control)this.comboControl)) {
            this.comboControl.select(index);
        } else if (index >= 0 && index < this.items.length) {
            this.text = this.getEntryKey(this.items[index]);
            this.selectionIndex = index;
        }
        this.dialogFieldChangedAndApplied();
    }

    public int getSelectionIndex() {
        return this.selectionIndex;
    }

    public void setTextWithoutUpdate(String text) {
        this.pending = false;
        if (text == null) {
            text = "";
        }
        this.text = text;
        if (this.isOkToUse((Control)this.comboControl)) {
            this.comboControl.removeModifyListener(this.modifyListener);
            this.comboControl.setText(this.getEntryValue(text));
            this.comboControl.addModifyListener(this.modifyListener);
        }
    }

    private String getEntryValue(String key) {
        if (this.entryMap == null || !this.entryMap.containsKey(key)) {
            return key;
        }
        return this.entryMap.get(key).toString();
    }

    private String getEntryKey(String value) {
        if (this.entryMap == null || !this.entryMap.containsValue(value)) {
            return value;
        }
        Map.Entry[] entries = this.entryMap.entrySet().toArray(new Map.Entry[0]);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getValue() == value || value != null && value.equals(entries[i].getValue())) {
                return entries[i].getKey().toString();
            }
            ++i;
        }
        return value;
    }

    public void handleGrabHorizontal() {
        LayoutUtil.setGrabHorizontal((Control)this.comboControl, true);
    }
}

