/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.core.internal.types.BooleanLiteralType;
import org.eclipse.jst.jsf.core.internal.types.FloatLiteralType;
import org.eclipse.jst.jsf.core.internal.types.IntegerLiteralType;
import org.eclipse.jst.jsf.core.internal.types.NullLiteralType;
import org.eclipse.jst.jsf.core.internal.types.StringLiteralType;
import org.eclipse.jst.jsf.core.internal.types.ValueType;
import org.eclipse.jst.jsf.designtime.resolver.ISymbolContextResolver;
import org.eclipse.jst.jsf.designtime.resolver.StructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.validation.el.EvaluationTracker;
import org.eclipse.jst.jsf.validation.el.MyLocalizedMessage;
import org.eclipse.jst.jsf.validation.el.ValueExpressionTracker;
import org.eclipse.jst.jsf.validation.el.operators.BinaryOperator;
import org.eclipse.jst.jsf.validation.el.operators.TernaryChoiceOperator;
import org.eclipse.jst.jsf.validation.el.operators.UnaryOperator;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAddExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAndExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTChoiceExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTEqualityExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTFunctionInvocation;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTLiteral;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTMultiplyExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTOperatorExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTOrExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTRelationalExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTUnaryExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValue;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValuePrefix;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValueSuffix;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParserVisitor;
import org.eclipse.jst.jsp.core.internal.java.jspel.SimpleNode;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

class ASTSemanticValidator
implements JSPELParserVisitor {
    private final IFile _targetFile;
    private final ASTExpression _expr;
    private final IStructuredDocumentContext _context;
    private final ISymbolContextResolver _symbolResolver;
    private final List _messages;
    private final EvaluationTracker _tracker;

    ASTSemanticValidator(ASTExpression expr, IStructuredDocumentContext context) {
        IWorkspaceContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        this._targetFile = resolver != null ? (IFile)resolver.getResource() : null;
        this._expr = expr;
        this._context = context;
        this._symbolResolver = StructuredDocumentSymbolResolverFactory.getInstance().getSymbolContextResolver(this._context);
        this._messages = new ArrayList();
        this._tracker = new EvaluationTracker();
    }

    public void validate() {
        this._expr.jjtAccept((JSPELParserVisitor)this, (Object)this._tracker);
    }

    public Object visit(ASTAddExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTAndExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTChoiceExpression node, Object data) {
        if (node.jjtGetNumChildren() != 3) {
            throw new AssertionError((Object)"Binary operators should always have two sub-expressions");
        }
        node.jjtGetChild(0).jjtAccept((JSPELParserVisitor)this, data);
        ValueType choiceArg = ((EvaluationTracker)data).getType();
        node.jjtGetChild(1).jjtAccept((JSPELParserVisitor)this, data);
        ValueType whenTrueArg = ((EvaluationTracker)data).getType();
        node.jjtGetChild(2).jjtAccept((JSPELParserVisitor)this, data);
        ValueType whenFalseArg = ((EvaluationTracker)data).getType();
        if (choiceArg != null && whenTrueArg != null && whenFalseArg != null) {
            TernaryChoiceOperator operator = new TernaryChoiceOperator();
            Diagnostic diagnostic = operator.validate(choiceArg, whenTrueArg, whenFalseArg);
            if (diagnostic.getSeverity() != 0) {
                Token firstToken = node.getFirstToken();
                MyLocalizedMessage message = new MyLocalizedMessage(diagnostic, this._targetFile);
                message.setOffset(this._context.getDocumentPosition() + firstToken.beginColumn - 1);
                message.setLength(node.getLastToken().endColumn - firstToken.beginColumn + 1);
                this._messages.add(message);
            }
            ((EvaluationTracker)data).setType(operator.perform(choiceArg, whenTrueArg, whenFalseArg));
        } else {
            ((EvaluationTracker)data).setType(null);
        }
        return data;
    }

    public Object visit(ASTEqualityExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTExpression node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTFunctionInvocation node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTLiteral node, Object data) {
        if (node.jjtGetNumChildren() > 0) {
            throw new AssertionError((Object)"Literals should be terminal");
        }
        BooleanLiteralType type = null;
        Token literalToken = node.getFirstToken();
        switch (literalToken.kind) {
            case 8: {
                type = new StringLiteralType(this.stripQuotes(literalToken.image));
                break;
            }
            case 5: {
                type = new IntegerLiteralType(Long.parseLong(literalToken.image));
                break;
            }
            case 6: {
                type = new FloatLiteralType(Double.parseDouble(literalToken.image));
                break;
            }
            case 11: {
                type = BooleanLiteralType.FALSE;
                break;
            }
            case 10: {
                type = BooleanLiteralType.TRUE;
                break;
            }
            case 12: {
                type = NullLiteralType.SINGLETON;
            }
        }
        ((EvaluationTracker)data).setType((ValueType)type);
        return data;
    }

    private String stripQuotes(String stringLiteral) {
        if (stringLiteral.startsWith("'") || stringLiteral.startsWith("\"")) {
            if (stringLiteral.length() > 2) {
                return stringLiteral.substring(1, stringLiteral.length() - 1);
            }
            return "";
        }
        return stringLiteral;
    }

    public Object visit(ASTMultiplyExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTOrExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTRelationalExpression node, Object data) {
        this.performBinaryEvaluation((ASTOperatorExpression)node, (EvaluationTracker)data);
        return data;
    }

    public Object visit(ASTUnaryExpression node, Object data) {
        Token firstToken;
        node.childrenAccept((JSPELParserVisitor)this, data);
        ValueType type = ((EvaluationTracker)data).getType();
        if (type != null && UnaryOperator.isUnaryOperator(firstToken = node.getFirstToken())) {
            UnaryOperator unaryOp = UnaryOperator.createUnaryOperator(firstToken);
            Diagnostic diagnostic = unaryOp.validate(type);
            if (diagnostic.getSeverity() != 0) {
                MyLocalizedMessage message = new MyLocalizedMessage(diagnostic, this._targetFile);
                message.setOffset(this._context.getDocumentPosition() + firstToken.beginColumn - 1);
                message.setLength(node.getLastToken().endColumn - firstToken.beginColumn + 1);
                this._messages.add(message);
            }
            ((EvaluationTracker)data).setType(unaryOp.performOperation(type));
        }
        return type;
    }

    public Object visit(ASTValue node, Object data) {
        String typeSig;
        ValueExpressionTracker tracker = new ValueExpressionTracker(this._targetFile.getProject());
        ((EvaluationTracker)data).setValueTracker(tracker);
        node.childrenAccept((JSPELParserVisitor)this, data);
        if (!tracker.isErrorFlag() && tracker.getCurPropertySymbol() != null && tracker.getCurPropertySymbol().isIntermediate()) {
            int problemStartOffset = tracker.getCurPropertySymbolOffset();
            MyLocalizedMessage message = new MyLocalizedMessage(2, (IResource)this._targetFile, 1, new Object[]{tracker.getCurPropertySymbol().getName()});
            message.setOffset(problemStartOffset);
            message.setLength(tracker.getCurPropertySymbolLength());
            message.setTargetObject(this._targetFile);
            message.setAttribute("name", tracker.getCurPropertySymbol().getName());
            this._messages.add(message);
        } else if (tracker.isRootValid() && !tracker.isErrorFlag() && (typeSig = tracker.resolveType()) != null) {
            ValueType type = new ValueType(typeSig, 0);
            ((EvaluationTracker)data).setType(type);
        }
        return data;
    }

    public Object visit(ASTValuePrefix node, Object data) {
        ValueExpressionTracker tracker = ((EvaluationTracker)data).getValueTracker();
        if (!tracker.isErrorFlag() && node.jjtGetNumChildren() == 0) {
            Token token = node.getFirstToken();
            String image = token.image;
            ISymbol symbol = this._symbolResolver.getSymbol(image);
            if (symbol == null) {
                int problemStartOffset = this._context.getDocumentPosition() + token.beginColumn - 1;
                MyLocalizedMessage message = new MyLocalizedMessage(2, (IResource)this._targetFile, 0, new Object[]{image});
                message.setOffset(problemStartOffset);
                message.setLength(token.endColumn - token.beginColumn + 1);
                message.setTargetObject(this._targetFile);
                message.setAttribute("name", image);
                this._messages.add(message);
            } else {
                tracker.setRootSymbol(symbol);
            }
        }
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(ASTValueSuffix node, Object data) {
        ValueExpressionTracker tracker = ((EvaluationTracker)data).getValueTracker();
        if (!tracker.isErrorFlag()) {
            Token firstToken = node.getFirstToken();
            if (node.jjtGetNumChildren() == 0 && firstToken.kind == 13) {
                Token dotId = node.getLastToken();
                if (tracker.isRootValid()) {
                    int startOffset = this._context.getDocumentPosition() + dotId.beginColumn - 1;
                    int length = dotId.endColumn - dotId.beginColumn + 1;
                    if (!tracker.isValidMemberOfCurrentSymbol(dotId.image)) {
                        MyLocalizedMessage message = new MyLocalizedMessage(2, (IResource)this._targetFile, 1, new Object[]{dotId.image, tracker.getRootSymbol().getName()});
                        message.setOffset(startOffset);
                        message.setLength(length);
                        message.setTargetObject(this._targetFile);
                        this._messages.add(message);
                        tracker.setErrorFlag(true);
                    } else {
                        tracker.setCurPropertySymbol(tracker.getNextPropertySymbol(dotId.image), startOffset, length);
                    }
                }
            }
        }
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public Object visit(SimpleNode node, Object data) {
        return node.childrenAccept((JSPELParserVisitor)this, data);
    }

    public void reportFindings(IValidator validator, IReporter reporter) {
        Iterator it = this._messages.iterator();
        while (it.hasNext()) {
            reporter.addMessage(validator, (IMessage)it.next());
        }
    }

    private void performBinaryEvaluation(ASTOperatorExpression node, EvaluationTracker tracker) {
        if (node.jjtGetNumChildren() < 2) {
            throw new AssertionError((Object)"Binary operators should always have at least two sub-expressions");
        }
        if (node.getOperatorTokens().size() != node.jjtGetNumChildren() - 1) {
            throw new AssertionError((Object)"Binary operators should always have one operator token less than number of sub-expressions");
        }
        node.jjtGetChild(0).jjtAccept((JSPELParserVisitor)this, (Object)tracker);
        ValueType curType = tracker.getType();
        int child = 1;
        while (child < node.jjtGetNumChildren()) {
            node.jjtGetChild(child).jjtAccept((JSPELParserVisitor)this, (Object)tracker);
            ValueType secondType = tracker.getType();
            if (curType != null && secondType != null) {
                BinaryOperator operator = BinaryOperator.getBinaryOperator((Token)node.getOperatorTokens().get(child - 1));
                Diagnostic diagnostic = operator.validate(curType, secondType);
                if (diagnostic.getSeverity() != 0) {
                    Token firstToken = node.getFirstToken();
                    MyLocalizedMessage message = new MyLocalizedMessage(diagnostic, this._targetFile);
                    message.setOffset(this._context.getDocumentPosition() + firstToken.beginColumn - 1);
                    message.setLength(node.getLastToken().endColumn - firstToken.beginColumn + 1);
                    this._messages.add(message);
                }
                curType = operator.performOperation(curType, secondType);
            }
            ++child;
        }
        tracker.setType(curType);
    }

    public List getMessages() {
        return this._messages;
    }

    public ValueType getExpressionType() {
        return this._tracker.getType();
    }

    public static void main(String[] args) throws IOException {
        int nextCharacter;
        String elText = "";
        while ((nextCharacter = System.in.read()) != -1) {
            char nextChar = (char)nextCharacter;
            if (nextChar == '\n') {
                try {
                    JSPELParser parser = JSPELParser.createParser((String)elText);
                    ASTExpression expr = parser.Expression();
                    expr.dump("");
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
                elText = "";
                continue;
            }
            elText = String.valueOf(elText) + nextChar;
        }
    }
}

