/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.validation.el.ASTSemanticValidator;
import org.eclipse.jst.jsf.validation.el.MyLocalizedMessage;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.ParseException;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.jst.jsp.core.internal.java.jspel.TokenMgrError;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JSPELValidatorCopy
extends JSPValidator {
    protected void validateRegionContainer(IStructuredDocument structuredDoc, ITextRegionCollection container, IReporter reporter, IFile file) {
        ITextRegionCollection containerRegion = container;
        Iterator regions = containerRegion.getRegions().iterator();
        ITextRegion region = null;
        while (regions.hasNext() && !reporter.isCancelled()) {
            ITextRegionList regionList;
            ITextRegionCollection parentRegion;
            region = (ITextRegion)regions.next();
            String type = region.getType();
            if (type == null || !(region instanceof ITextRegionCollection) || (parentRegion = (ITextRegionCollection)region).getType() != "XML_TAG_ATTRIBUTE_VALUE" || (regionList = parentRegion.getRegions()).size() < 4) continue;
            ITextRegion openQuote = regionList.get(0);
            ITextRegion openVBLQuote = regionList.get(1);
            if (openQuote.getType() != "XML_TAG_ATTRIBUTE_VALUE_DQUOTE" && openQuote.getType() != "XML_TAG_ATTRIBUTE_VALUE_SQUOTE" || openVBLQuote.getType() != "JSP_VBL_OPEN") continue;
            ITextRegion content = regionList.get(2);
            if (content.getType() == "JSP_VBL_CONTENT") {
                this.validateXMLNode(structuredDoc, parentRegion, content, reporter, file);
            }
            boolean foundClosingQuote = false;
            int i = 2;
            while (i < regionList.size()) {
                ITextRegion searchRegion = regionList.get(i);
                if (searchRegion.getType() == "JSP_VBL_CLOSE") {
                    foundClosingQuote = true;
                }
                ++i;
            }
            if (foundClosingQuote) continue;
            int problemStartOffset = parentRegion.getStartOffset();
            MyLocalizedMessage message = new MyLocalizedMessage(1, "Missing closing bracket on expression", 2);
            message.setOffset(problemStartOffset);
            message.setLength(parentRegion.getLength());
            message.setTargetObject(file);
            reporter.addMessage((IValidator)this, (IMessage)message);
        }
    }

    protected ASTExpression validateXMLNode(IStructuredDocument document, ITextRegionCollection container, ITextRegion region, IReporter reporter, IFile file) {
        String elText = container.getText(region);
        JSPELParser elParser = JSPELParser.createParser((String)elText);
        int contentStart = container.getStartOffset(region);
        int contentLength = region.getLength();
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)document, contentStart);
        try {
            ASTExpression expr = elParser.Expression();
            this.validateSemantics(expr, file, reporter, context);
            if (expr.getLastToken().endColumn < elText.trim().length() - 1) {
                int problemStartOffset = contentStart + expr.getLastToken().endColumn;
                MyLocalizedMessage message = new MyLocalizedMessage(2, JSPCoreMessages.JSPEL_Syntax, 3);
                message.setOffset(problemStartOffset);
                message.setLength(elText.trim().length() - expr.getLastToken().endColumn);
                message.setTargetObject(file);
                reporter.addMessage((IValidator)this, (IMessage)message);
            }
            return expr;
        }
        catch (ParseException e) {
            Token curTok = e.currentToken;
            int problemStartOffset = contentStart + curTok.beginColumn;
            MyLocalizedMessage message = new MyLocalizedMessage(2, JSPCoreMessages.JSPEL_Syntax, 3);
            message.setOffset(problemStartOffset);
            message.setLength(curTok.endColumn - curTok.beginColumn + 1);
            message.setTargetObject(file);
            reporter.addMessage((IValidator)this, (IMessage)message);
            return null;
        }
        catch (TokenMgrError tokenMgrError) {
            MyLocalizedMessage message = new MyLocalizedMessage(2, JSPCoreMessages.JSPEL_Token, 3);
            message.setOffset(contentStart);
            message.setLength(contentLength);
            message.setTargetObject(file);
            reporter.addMessage((IValidator)this, (IMessage)message);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public void validateFile(IFile file, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 143->147)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void validateSemantics(ASTExpression expr, IFile file, IReporter reporter, IStructuredDocumentContext context) {
        ASTSemanticValidator validator = new ASTSemanticValidator(expr, context);
        validator.validate();
        validator.reportFindings((IValidator)this, reporter);
    }
}

