/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.contentmodel.annotation.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.contentmodel.annotations.Activator;
import org.eclipse.wtp.jsf.contentmodel.annotation.internal.CMAnnotationAdvisor;
import org.eclipse.wtp.jsf.contentmodel.annotation.internal.CMAnnotationFileInfo;
import org.eclipse.wtp.jsf.contentmodel.annotation.internal.CMAnnotationMap;
import org.eclipse.wtp.jsf.contentmodel.annotation.internal.provisional.CMAnnotationSourceFileLocator;
import org.eclipse.wtp.jsf.contentmodel.annotation.internal.provisional.ICMAnnotationFileParser;
import org.osgi.framework.Bundle;

public class CMAnnotationFileParserHelper {
    private CMAnnotationFileInfo fileInfo;
    private static final String DEFAULT_PARSER_NAME = "org.eclipse.wtp.jsf.contentmodel.annotation.internal.CMAnnotationFileParser";
    private static final String DEFAULT_LOCATOR_NAME = "org.eclipse.wtp.jsf.contentmodel.annotation.internal.CMPluginRelativeSourceFileLocator";

    public CMAnnotationFileParserHelper(CMAnnotationFileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public void parse(CMAnnotationMap map) {
        ICMAnnotationFileParser parser = this.getParser();
        CMAnnotationAdvisor advisor = new CMAnnotationAdvisor(map, this.fileInfo);
        CMAnnotationSourceFileLocator locator = this.getLocator();
        map.setLocator(locator);
        try {
            parser.parse(advisor, locator);
        }
        catch (Exception e) {
            Activator.log(e, "Unable to parse: " + this.fileInfo.getAnnotationFileLocation() + " with " + this.fileInfo.getAnnotationFileLocatorClassname());
        }
    }

    private ICMAnnotationFileParser getParser() {
        String parserClassName = this.fileInfo.getParserClassName();
        Object obj = null;
        obj = parserClassName != null && !parserClassName.equals("") ? CMAnnotationFileParserHelper.getObjectForClassname(this.fileInfo.getBundleId(), parserClassName) : CMAnnotationFileParserHelper.getObjectForClassname("org.eclipse.jst.jsf.contentmodel.annotations", DEFAULT_PARSER_NAME);
        if (obj != null && obj instanceof ICMAnnotationFileParser) {
            return (ICMAnnotationFileParser)obj;
        }
        return null;
    }

    private CMAnnotationSourceFileLocator getLocator() {
        String locatorClassName = this.fileInfo.getAnnotationFileLocatorClassname();
        Object obj = null;
        obj = locatorClassName != null && !locatorClassName.equals("") ? CMAnnotationFileParserHelper.getObjectForClassname(this.fileInfo.getBundleId(), locatorClassName) : CMAnnotationFileParserHelper.getObjectForClassname("org.eclipse.jst.jsf.contentmodel.annotations", DEFAULT_LOCATOR_NAME);
        if (obj != null && obj instanceof CMAnnotationSourceFileLocator) {
            CMAnnotationSourceFileLocator locator = (CMAnnotationSourceFileLocator)obj;
            locator.setFileInfo(this.fileInfo);
            return locator;
        }
        return null;
    }

    private static Object getObjectForClassname(String bundleId, String providerClassName) {
        Bundle bundle;
        block6: {
            bundle = Platform.getBundle((String)bundleId);
            if (bundle != null) break block6;
            Activator.log(4, CMAnnotationFileParserHelper.getMsg(bundleId, providerClassName, "Unable to find bundleId: "));
            return null;
        }
        try {
            Class klass = bundle.loadClass(providerClassName);
            if (klass != null) {
                return klass.newInstance();
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            Activator.log(e, CMAnnotationFileParserHelper.getMsg(bundleId, providerClassName, "ClassNotFoundException: "));
        }
        catch (InstantiationException e) {
            Activator.log(e, CMAnnotationFileParserHelper.getMsg(bundleId, providerClassName, "InstantiationException: "));
        }
        catch (IllegalAccessException e) {
            Activator.log(e, CMAnnotationFileParserHelper.getMsg(bundleId, providerClassName, "IllegalAccessException: "));
        }
        return null;
    }

    private static String getMsg(String bundleId, String providerClassName, String prefix) {
        StringBuffer buf = new StringBuffer(prefix);
        buf.append(providerClassName).append(" in ").append(bundleId);
        return buf.toString();
    }
}

