/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.DialogFieldBase;
import org.eclipse.jst.jsf.facesconfig.common.guiutils.SWTUtils;
import org.eclipse.jst.jsf.facesconfig.ui.NewEditorResourcesNLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditValueDialog
extends Dialog {
    private static final int VALUE_WIDTH = 380;
    private static final int VALUE_HEIGHT = 220;
    private String value;
    private Text valueText;
    private Button nullValueTypeButton;
    private boolean isNullButtonShown = false;
    private boolean isNullValue;

    public EditValueDialog(Shell parentShell, String value) {
        super(parentShell);
        this.value = value;
        this.isNullButtonShown = false;
    }

    public EditValueDialog(Shell parentShell, boolean isNullButtonShown, boolean isNullValue, String value) {
        super(parentShell);
        this.isNullValue = isNullValue;
        this.value = value;
        this.isNullButtonShown = isNullButtonShown;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        container.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        if (this.isNullButtonShown) {
            this.nullValueTypeButton = SWTUtils.createCheckBox((Composite)container, (String)"null-value", (int)2);
            this.nullValueTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditValueDialog.this.valueText.setEnabled(!EditValueDialog.this.nullValueTypeButton.getSelection());
                    EditValueDialog.this.isNullValue = EditValueDialog.this.nullValueTypeButton.getSelection();
                }
            });
        }
        DialogFieldBase valueTitle = new DialogFieldBase();
        valueTitle.setLabelText(NewEditorResourcesNLS.ManagedBeanPropertyEditDialog_Value);
        valueTitle.doFillIntoGrid(null, container, 1);
        gd = new GridData(1808);
        gd.widthHint = 380;
        gd.heightHint = 220;
        this.valueText = new Text(container, 2050);
        this.valueText.setLayoutData((Object)gd);
        this.initFields();
        return container;
    }

    private void initFields() {
        if (this.isNullButtonShown && this.isNullValue) {
            this.nullValueTypeButton.setSelection(true);
            this.valueText.setEnabled(false);
        } else if (this.value != null) {
            this.valueText.setText(this.value);
        }
    }

    protected void createValueSection(Composite container) {
        Composite valueSection = new Composite(container, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        valueSection.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        valueSection.setLayoutData((Object)gd);
        Label lblValue = new Label(valueSection, 16384);
        gd = new GridData(256);
        gd.widthHint = 100;
        lblValue.setLayoutData((Object)gd);
        lblValue.setText(NewEditorResourcesNLS.ManagedBeanPropertyEditDialog_Value);
        gd = new GridData(768);
        gd.widthHint = 200;
        this.valueText = new Text(valueSection, 2048);
        this.valueText.setLayoutData((Object)gd);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NewEditorResourcesNLS.ValueEditDialog_Title);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            this.setReturnCode(1);
            this.close();
            return;
        }
        if (buttonId == 0) {
            this.value = this.valueText.getText();
            this.setReturnCode(0);
            this.close();
            return;
        }
        super.buttonPressed(buttonId);
    }

    public Object getResultData() {
        return this.value;
    }

    public boolean isNullValue() {
        return this.isNullButtonShown && this.isNullValue;
    }
}

