/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.xsd.ui.internal.actions.XSDEditNamespacesAction;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateNamespaceInformationCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.w3c.dom.Element;

public class XSDSchemaSection
extends AbstractSection {
    IWorkbenchPart part;
    Text prefixText;
    Text targetNamespaceText;
    Button editButton;
    StyledText errorText;
    Color red;

    public void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        CLabel prefixLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_SCHEMA_PREFIX"));
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        prefixLabel.setLayoutData((Object)data);
        this.prefixText = this.getWidgetFactory().createText(this.composite, "", 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.prefixText.setLayoutData((Object)data);
        this.applyAllListeners((Control)this.prefixText);
        CLabel targetNamespaceLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_TARGET_NAME_SPACE"));
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        targetNamespaceLabel.setLayoutData((Object)data);
        this.targetNamespaceText = this.getWidgetFactory().createText(this.composite, "", 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.targetNamespaceText.setLayoutData((Object)data);
        this.applyAllListeners((Control)this.targetNamespaceText);
        this.editButton = this.getWidgetFactory().createButton(this.composite, String.valueOf(XSDEditorPlugin.getXSDString("_UI_SECTION_ADVANCED_ATTRIBUTES")) + "...", 8);
        data = new GridData(0x1000008, 0x1000000, true, false);
        data.horizontalSpan = 2;
        this.editButton.setLayoutData((Object)data);
        this.editButton.addSelectionListener((SelectionListener)this);
        this.errorText = new StyledText(this.composite, 0x800000);
        this.errorText.setEditable(false);
        this.errorText.setEnabled(false);
        this.errorText.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        this.errorText.setLayoutData((Object)data);
    }

    public void refresh() {
        this.setListenerEnabled(false);
        Element element = this.xsdSchema.getElement();
        if (element != null) {
            TypesHelper helper = new TypesHelper(this.xsdSchema);
            String aPrefix = helper.getPrefix(element.getAttribute("targetNamespace"), false);
            if (aPrefix != null && aPrefix.length() > 0) {
                this.prefixText.setText(aPrefix);
            } else {
                this.prefixText.setText("");
            }
            String tns = element.getAttribute("targetNamespace");
            if (tns != null && tns.length() > 0) {
                this.targetNamespaceText.setText(tns);
            } else {
                this.targetNamespaceText.setText("");
            }
            this.errorText.setText("");
        }
        this.setListenerEnabled(true);
    }

    public void doHandleEvent(Event event) {
        this.errorText.setText("");
        String prefixValue = this.prefixText.getText();
        String tnsValue = this.targetNamespaceText.getText();
        if (tnsValue.trim().length() == 0 && prefixValue.trim().length() > 0) {
            this.errorText.setText(XSDEditorPlugin.getXSDString("_ERROR_TARGET_NAMESPACE_AND_PREFIX"));
            int length = this.errorText.getText().length();
            this.red = new Color(null, 255, 0, 0);
            StyleRange style = new StyleRange(0, length, this.red, this.targetNamespaceText.getBackground());
            this.errorText.setStyleRange(style);
            return;
        }
        if (event.widget == this.prefixText) {
            this.updateNamespaceInfo(prefixValue, tnsValue);
        } else if (event.widget == this.targetNamespaceText) {
            this.updateNamespaceInfo(prefixValue, tnsValue);
        }
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.editButton) {
            XSDEditNamespacesAction nsAction = new XSDEditNamespacesAction(XSDEditorPlugin.getXSDString("_UI_ACTION_EDIT_NAMESPACES"), this.xsdSchema.getElement(), null, this.xsdSchema);
            nsAction.run();
            this.refresh();
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    private void updateNamespaceInfo(String newPrefix, String newTargetNamespace) {
        UpdateNamespaceInformationCommand command = new UpdateNamespaceInformationCommand("", this.xsdSchema, newPrefix, newTargetNamespace);
        command.execute();
    }

    public void dispose() {
        if (this.prefixText != null && !this.prefixText.isDisposed()) {
            this.removeListeners((Control)this.prefixText);
        }
        if (this.targetNamespaceText != null && !this.targetNamespaceText.isDisposed()) {
            this.removeListeners((Control)this.targetNamespaceText);
        }
        if (this.red != null) {
            this.red.dispose();
            this.red = null;
        }
        super.dispose();
    }

    protected boolean validatePrefix(String prefix) {
        return true;
    }
}

