/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.classpath;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.jdt.internal.classpath.FlexibleProjectContainer;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainer;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.GlobalComponentChangeListener;
import org.eclipse.wst.common.componentcore.internal.GlobalComponentChangeNotifier;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;

public class J2EEComponentClasspathUpdater
extends AdapterImpl
implements GlobalComponentChangeListener,
IResourceChangeListener {
    private static J2EEComponentClasspathUpdater instance = null;
    private int pauseCount = 0;
    private Set moduleUpdatesRequired = new HashSet();
    private Set earUpdatesRequired = new HashSet();
    private IPath WEB_APP_LIBS_PATH = new Path("org.eclipse.jst.j2ee.internal.web.container");
    private final String MODULE_URI = "module:/resource";
    private Map knownManifests = new Hashtable();
    private Map knownEARs = new Hashtable();

    public static J2EEComponentClasspathUpdater getInstance() {
        if (instance == null) {
            J2EEComponentClasspathUpdater.init();
        }
        return instance;
    }

    public static void init() {
        if (instance == null) {
            instance = new J2EEComponentClasspathUpdater();
            GlobalComponentChangeNotifier.getInstance().addListener((GlobalComponentChangeListener)instance);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)instance, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseUpdates() {
        J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
        synchronized (j2EEComponentClasspathUpdater) {
            ++this.pauseCount;
        }
    }

    /*
     * Exception decompiling
     */
    public void resumeUpdates() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 184->188)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void notifyChanged(Notification notification) {
        if (notification.getFeature() == ComponentcorePackage.eINSTANCE.getWorkbenchComponent_ReferencedComponents()) {
            switch (notification.getEventType()) {
                case 4: {
                    ReferencedComponent oldRef = (ReferencedComponent)notification.getOldValue();
                    URI handle = oldRef.getHandle();
                    if (!handle.toString().startsWith("module:/resource")) break;
                    String projectName = handle.segment(2);
                    IProject project = ProjectUtilities.getProject((String)projectName);
                    this.queueUpdate(project);
                }
            }
        }
    }

    public void editModelChanged(EditModelEvent anEvent) {
        switch (anEvent.getEventCode()) {
            case 1: 
            case 6: {
                IProject project = anEvent.getEditModel().getProject();
                this.queueUpdate(project);
            }
        }
    }

    public void queueUpdate(IProject project) {
        if (J2EEProjectUtilities.isEARProject(project)) {
            this.queueUpdateEAR(project);
        } else if ((J2EEProjectUtilities.isApplicationClientProject(project) || J2EEProjectUtilities.isEJBProject(project) || J2EEProjectUtilities.isDynamicWebProject(project) || J2EEProjectUtilities.isJCAProject(project) || J2EEProjectUtilities.isUtilityProject(project)) && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
            this.queueUpdateModule(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUpdateModule(IProject project) {
        J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
        synchronized (j2EEComponentClasspathUpdater) {
            if (this.pauseCount > 0) {
                if (!this.moduleUpdatesRequired.contains(project)) {
                    this.moduleUpdatesRequired.add(project);
                }
                return;
            }
        }
        this.updateModule(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUpdateEAR(IProject earProject) {
        J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
        synchronized (j2EEComponentClasspathUpdater) {
            if (this.pauseCount > 0) {
                if (!this.earUpdatesRequired.contains(earProject)) {
                    this.earUpdatesRequired.add(earProject);
                }
                return;
            }
        }
        this.updateEAR(earProject);
    }

    /*
     * Exception decompiling
     */
    private void updateEAR(IProject earProject) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 92->96)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateModule(final IProject project) {
        final IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                IProject[] earProjects;
                IClasspathContainer container = J2EEComponentClasspathUpdater.this.getWebAppLibrariesContainer(project, false);
                if (container != null && container instanceof FlexibleProjectContainer) {
                    ((FlexibleProjectContainer)container).refresh();
                }
                if ((earProjects = J2EEProjectUtilities.getReferencingEARProjects(project)).length == 0) {
                    J2EEComponentClasspathUpdater.this.removeContainerFromModuleIfNecessary(project);
                    return;
                }
                container = J2EEComponentClasspathUpdater.this.addContainerToModuleIfNecessary(project);
                if (container != null && container instanceof J2EEComponentClasspathContainer) {
                    ((J2EEComponentClasspathContainer)container).refresh();
                }
                IFile manifest = J2EEProjectUtilities.getManifestFile(project);
                J2EEComponentClasspathUpdater.this.trackManifest((IResource)manifest);
            }
        };
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.isTreeLocked()) {
            Runnable r = new Runnable(){

                public void run() {
                    while (workspace.isTreeLocked()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    try {
                        workspace.run(workspaceRunnable, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                }
            };
            Thread t = new Thread(r);
            t.start();
        } else {
            try {
                workspaceRunnable.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
    }

    public IClasspathContainer getWebAppLibrariesContainer(IProject webProject, boolean create) {
        IClasspathEntry entry;
        IJavaProject jproj = JavaCore.create((IProject)webProject);
        IClasspathContainer container = null;
        IClasspathEntry iClasspathEntry = entry = create ? null : this.getExistingContainer(jproj, this.WEB_APP_LIBS_PATH);
        if (entry != null || create) {
            try {
                container = JavaCore.getClasspathContainer((IPath)this.WEB_APP_LIBS_PATH, (IJavaProject)jproj);
            }
            catch (JavaModelException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        return container;
    }

    private IClasspathContainer addContainerToModuleIfNecessary(IProject moduleProject) {
        IJavaProject jproj = JavaCore.create((IProject)moduleProject);
        IClasspathEntry entry = this.getExistingContainer(jproj, J2EEComponentClasspathContainer.CONTAINER_PATH);
        if (entry == null) {
            try {
                entry = JavaCore.newContainerEntry((IPath)J2EEComponentClasspathContainer.CONTAINER_PATH);
                this.addToClasspath(jproj, entry);
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        IClasspathContainer container = null;
        try {
            container = JavaCore.getClasspathContainer((IPath)J2EEComponentClasspathContainer.CONTAINER_PATH, (IJavaProject)jproj);
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        return container;
    }

    private void removeContainerFromModuleIfNecessary(IProject moduleProject) {
        IJavaProject jproj = JavaCore.create((IProject)moduleProject);
        IClasspathEntry entry = this.getExistingContainer(jproj, J2EEComponentClasspathContainer.CONTAINER_PATH);
        if (entry != null) {
            try {
                this.removeFromClasspath(jproj, entry);
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
    }

    private void addToClasspath(IJavaProject jproj, IClasspathEntry entry) throws CoreException {
        IClasspathEntry[] current = jproj.getRawClasspath();
        IClasspathEntry[] updated = new IClasspathEntry[current.length + 1];
        System.arraycopy(current, 0, updated, 0, current.length);
        updated[current.length] = entry;
        jproj.setRawClasspath(updated, null);
    }

    private void removeFromClasspath(IJavaProject jproj, IClasspathEntry entry) throws CoreException {
        IClasspathEntry[] current = jproj.getRawClasspath();
        IClasspathEntry[] updated = new IClasspathEntry[current.length - 1];
        boolean removed = false;
        int i = 0;
        while (i < current.length) {
            if (!removed) {
                if (current[i] == entry) {
                    removed = true;
                } else {
                    updated[i] = current[i];
                }
            } else {
                updated[i - 1] = current[i];
            }
            ++i;
        }
        jproj.setRawClasspath(updated, null);
    }

    private IClasspathEntry getExistingContainer(IJavaProject jproj, IPath classpathContainerPath) {
        try {
            IClasspathEntry[] cpes = jproj.getRawClasspath();
            int j = 0;
            while (j < cpes.length) {
                IClasspathEntry cpe = cpes[j];
                if (cpe.getEntryKind() == 5 && cpe.getPath().equals((Object)classpathContainerPath)) {
                    return cpe;
                }
                ++j;
            }
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackManifest(IResource manifest) {
        if (manifest == null) {
            return;
        }
        Map map = this.knownManifests;
        synchronized (map) {
            if (manifest.exists()) {
                Long timeStamp = new Long(manifest.getLocalTimeStamp());
                this.knownManifests.put(manifest, timeStamp);
            } else {
                this.knownManifests.remove(manifest);
            }
        }
    }

    public void trackEAR(IProject earProject) {
        this.trackEAR(earProject, false);
    }

    private void trackEAR(IProject earProject, boolean forceUpdate) {
        if (earProject.exists()) {
            if (forceUpdate || !this.knownEARs.containsKey(earProject)) {
                try {
                    IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
                    IVirtualResource[] resources = earComponent.getRootFolder().members();
                    HashSet<String> archiveSet = (HashSet<String>)this.knownEARs.get(earProject);
                    if (archiveSet == null) {
                        archiveSet = new HashSet<String>();
                        this.knownEARs.put(earProject, archiveSet);
                    } else {
                        archiveSet.clear();
                    }
                    int i = 0;
                    while (i < resources.length) {
                        if (resources[i].getName().endsWith(".jar")) {
                            archiveSet.add(resources[i].getName());
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {
                    this.knownEARs.remove(earProject);
                }
            }
        } else {
            this.knownEARs.remove(earProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resourceChanged(IResourceChangeEvent event) {
        try {
            this.pauseUpdates();
            ArrayList<IResource> manifestsToRemove = null;
            ArrayList<IProject> modulesToUpdate = null;
            Map map = this.knownManifests;
            synchronized (map) {
                Iterator iterator = this.knownManifests.keySet().iterator();
                while (iterator.hasNext()) {
                    IResource resource = (IResource)iterator.next();
                    if (resource.exists()) {
                        long currentTimeStamp = resource.getLocalTimeStamp();
                        Long lastTimeStamp = (Long)this.knownManifests.get(resource);
                        if (lastTimeStamp == currentTimeStamp) continue;
                        if (modulesToUpdate == null) {
                            modulesToUpdate = new ArrayList<IProject>();
                        }
                        modulesToUpdate.add(resource.getProject());
                        continue;
                    }
                    if (manifestsToRemove == null) {
                        manifestsToRemove = new ArrayList<IResource>();
                    }
                    manifestsToRemove.add(resource);
                }
            }
            if (manifestsToRemove != null) {
                map = this.knownManifests;
                synchronized (map) {
                    int i = 0;
                    int size = manifestsToRemove.size();
                    while (i < size) {
                        this.knownManifests.remove(manifestsToRemove.get(i));
                        ++i;
                    }
                }
            }
            if (modulesToUpdate != null) {
                int i = 0;
                int size = modulesToUpdate.size();
                while (i < size) {
                    this.queueUpdateModule((IProject)modulesToUpdate.get(i));
                    ++i;
                }
            }
            ArrayList<IProject> earsToRemove = null;
            IProject[] earProjects = null;
            Map size = this.knownEARs;
            synchronized (size) {
                Set keySet = this.knownEARs.keySet();
                earProjects = new IProject[keySet.size()];
                Iterator iterator = keySet.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    earProjects[i] = (IProject)iterator.next();
                    ++i;
                }
            }
            int i = 0;
            while (i < earProjects.length) {
                block45: {
                    block47: {
                        if (!earProjects[i].exists()) break block47;
                        Set archiveSet = (Set)this.knownEARs.get(earProjects[i]);
                        if (archiveSet != null) {
                            IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProjects[i]);
                            try {
                                IVirtualResource[] resources = earComponent.getRootFolder().members();
                                boolean requiresUpdate = false;
                                int archivesFound = 0;
                                int j = 0;
                                while (true) {
                                    if (j >= resources.length || requiresUpdate) {
                                        if (requiresUpdate || archivesFound < archiveSet.size()) {
                                            this.queueUpdateEAR(earProjects[i]);
                                        }
                                        break block45;
                                    }
                                    String name = resources[j].getName();
                                    if (name.endsWith(".jar")) {
                                        if (!archiveSet.contains(resources[j].getName())) {
                                            requiresUpdate = true;
                                        } else {
                                            ++archivesFound;
                                        }
                                    }
                                    ++j;
                                }
                            }
                            catch (CoreException coreException) {
                                if (earsToRemove == null) {
                                    earsToRemove = new ArrayList();
                                }
                                earsToRemove.add(earProjects[i]);
                            }
                        }
                        break block45;
                    }
                    if (earsToRemove == null) {
                        earsToRemove = new ArrayList<IProject>();
                    }
                    earsToRemove.add(earProjects[i]);
                }
                ++i;
            }
            if (earsToRemove != null) {
                Map map2 = this.knownEARs;
                synchronized (map2) {
                    int i2 = 0;
                    while (i2 < earsToRemove.size()) {
                        this.knownEARs.remove(earsToRemove.get(i2));
                        ++i2;
                    }
                }
            }
            Object var14_27 = null;
            this.resumeUpdates();
            return;
        }
        catch (Throwable throwable) {
            Object var14_26 = null;
            this.resumeUpdates();
            throw throwable;
        }
    }
}

