/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.jst.jsf.designtime";
    private static Activator plugin;
    private static Map _registeredVariableResolvers;
    private static final String VARIABLE_RESOLVER_EXT_POINT_NAME = "variableresolver";
    private static Map _registeredPropertyResolvers;
    private static final String PROPERTY_RESOLVER_EXT_POINT_NAME = "propertyresolver";
    private static Map _registeredMethodResolvers;
    private static final String METHOD_RESOLVER_EXT_POINT_NAME = "methodresolver";
    private static Map _registeredExternalContextProviders;
    private static final String EXTERNAL_CONTEXT_EXT_POINT_NAME = "externalcontext";

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static synchronized Map getVariableResolvers() {
        if (_registeredVariableResolvers == null) {
            Activator.registerVariableResolverProviders();
            if (_registeredVariableResolvers == null) {
                throw new AssertionError((Object)"registerProviders failed");
            }
        }
        return Collections.unmodifiableMap(_registeredVariableResolvers);
    }

    private static void registerVariableResolverProviders() {
        _registeredVariableResolvers = new HashMap();
        Activator.loadRegisteredExtensions(VARIABLE_RESOLVER_EXT_POINT_NAME, _registeredVariableResolvers, VARIABLE_RESOLVER_EXT_POINT_NAME);
    }

    public static Map getPropertyResolvers() {
        if (_registeredPropertyResolvers == null) {
            Activator.registerPropertyResolverProviders();
            if (_registeredPropertyResolvers == null) {
                throw new AssertionError((Object)"registerProviders failed");
            }
        }
        return Collections.unmodifiableMap(_registeredPropertyResolvers);
    }

    private static void registerPropertyResolverProviders() {
        _registeredPropertyResolvers = new HashMap();
        Activator.loadRegisteredExtensions(PROPERTY_RESOLVER_EXT_POINT_NAME, _registeredPropertyResolvers, PROPERTY_RESOLVER_EXT_POINT_NAME);
    }

    public static Map getMethodResolvers() {
        if (_registeredMethodResolvers == null) {
            Activator.registerMethodResolverProviders();
            if (_registeredMethodResolvers == null) {
                throw new AssertionError((Object)"registerProviders failed");
            }
        }
        return Collections.unmodifiableMap(_registeredMethodResolvers);
    }

    private static void registerMethodResolverProviders() {
        _registeredMethodResolvers = new HashMap();
        Activator.loadRegisteredExtensions(METHOD_RESOLVER_EXT_POINT_NAME, _registeredMethodResolvers, METHOD_RESOLVER_EXT_POINT_NAME);
    }

    public static Map getExternalContextProviders() {
        if (_registeredExternalContextProviders == null) {
            Activator.registerExternalContextProviders();
            if (_registeredExternalContextProviders == null) {
                throw new AssertionError((Object)"registerProviders failed");
            }
        }
        return Collections.unmodifiableMap(_registeredExternalContextProviders);
    }

    private static void registerExternalContextProviders() {
        _registeredExternalContextProviders = new HashMap();
        Activator.loadRegisteredExtensions(EXTERNAL_CONTEXT_EXT_POINT_NAME, _registeredExternalContextProviders, EXTERNAL_CONTEXT_EXT_POINT_NAME);
    }

    private static void loadRegisteredExtensions(String extName, Map registry, String elementName) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(plugin.getBundle().getSymbolicName(), extName);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            String bundleId = extension.getContributor().getName();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if (elementName.equals(element.getName()) && element.getAttribute("class") != null && element.getAttribute("id") != null) {
                    String factoryClassName = element.getAttribute("class");
                    String id = element.getAttribute("id");
                    Bundle bundle = Platform.getBundle((String)bundleId);
                    if (bundle != null) {
                        try {
                            Class factoryClass = bundle.loadClass(factoryClassName);
                            Object variableResolver = factoryClass.newInstance();
                            registry.put(id, variableResolver);
                        }
                        catch (Exception e) {
                            ILog logger = Activator.getDefault().getLog();
                            logger.log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, "Error loading property resolver provider extension point", (Throwable)e));
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

