/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.command;

import java.util.Collection;
import org.eclipse.gef.commands.Command;
import org.eclipse.jst.jsf.facesconfig.ui.EditorResources;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowFactory;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowModelManager;

public class UpdatePageflowCommand
extends Command {
    private Pageflow curPageflow;
    private Pageflow oldPageflow;
    private Pageflow newPageflow;

    public UpdatePageflowCommand() {
        super(EditorResources.getInstance().getString("Pageflow.Commands.UpdatePageflowCommand.Label"));
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        PageflowFactory factory = PageflowModelManager.getFactory();
        this.oldPageflow = factory.createPageflow();
        this.oldPageflow.getNodes().addAll((Collection)this.curPageflow.getNodes());
        this.oldPageflow.getLinks().addAll((Collection)this.curPageflow.getLinks());
        this.curPageflow.getNodes().clear();
        this.curPageflow.getLinks().clear();
        this.curPageflow.getNodes().addAll((Collection)this.newPageflow.getNodes());
        this.curPageflow.getLinks().addAll((Collection)this.newPageflow.getLinks());
    }

    public void redo() {
        this.oldPageflow.getNodes().addAll((Collection)this.curPageflow.getNodes());
        this.oldPageflow.getLinks().addAll((Collection)this.curPageflow.getLinks());
        this.curPageflow.getNodes().clear();
        this.curPageflow.getLinks().clear();
        this.curPageflow.getNodes().addAll((Collection)this.newPageflow.getNodes());
        this.curPageflow.getLinks().addAll((Collection)this.newPageflow.getLinks());
    }

    public void undo() {
        this.newPageflow.getNodes().addAll((Collection)this.curPageflow.getNodes());
        this.newPageflow.getLinks().addAll((Collection)this.curPageflow.getLinks());
        this.curPageflow.getNodes().clear();
        this.curPageflow.getLinks().clear();
        this.curPageflow.getNodes().addAll((Collection)this.oldPageflow.getNodes());
        this.curPageflow.getLinks().addAll((Collection)this.oldPageflow.getLinks());
    }

    public void setPageflowUpdateDelta(Pageflow curPageflow, Pageflow newPageflow) {
        this.curPageflow = curPageflow;
        this.newPageflow = newPageflow;
    }
}

