/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout;

import org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout.DirectedGraph;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout.Edge;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout.EdgeList;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout.GraphUtilities;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout.GraphVisitor;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout.Node;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout.Rank;

class LocalOptimizer
extends GraphVisitor {
    LocalOptimizer() {
    }

    boolean shouldSwap(Node current, Node next) {
        int offsetDiff;
        int iNext;
        int j;
        int iCurrent;
        Edge currentEdge;
        if (GraphUtilities.isConstrained(current, next)) {
            return false;
        }
        int crossCount = 0;
        int invertedCrossCount = 0;
        EdgeList currentEdges = current.incoming;
        EdgeList nextEdges = next.incoming;
        int rank = current.rank - 1;
        int i = 0;
        while (i < currentEdges.size()) {
            currentEdge = currentEdges.getEdge(i);
            iCurrent = currentEdge.getIndexForRank(rank);
            j = 0;
            while (j < nextEdges.size()) {
                iNext = nextEdges.getEdge(j).getIndexForRank(rank);
                if (iNext < iCurrent) {
                    ++crossCount;
                } else if (iNext > iCurrent) {
                    ++invertedCrossCount;
                } else {
                    offsetDiff = nextEdges.getEdge(j).getSourceOffset() - currentEdge.getSourceOffset();
                    if (offsetDiff < 0) {
                        ++crossCount;
                    } else if (offsetDiff > 0) {
                        ++invertedCrossCount;
                    }
                }
                ++j;
            }
            ++i;
        }
        currentEdges = current.outgoing;
        nextEdges = next.outgoing;
        rank = current.rank + 1;
        i = 0;
        while (i < currentEdges.size()) {
            currentEdge = currentEdges.getEdge(i);
            iCurrent = currentEdge.getIndexForRank(rank);
            j = 0;
            while (j < nextEdges.size()) {
                iNext = nextEdges.getEdge(j).getIndexForRank(rank);
                if (iNext < iCurrent) {
                    ++crossCount;
                } else if (iNext > iCurrent) {
                    ++invertedCrossCount;
                } else {
                    offsetDiff = nextEdges.getEdge(j).getTargetOffset() - currentEdge.getTargetOffset();
                    if (offsetDiff < 0) {
                        ++crossCount;
                    } else if (offsetDiff > 0) {
                        ++invertedCrossCount;
                    }
                }
                ++j;
            }
            ++i;
        }
        return invertedCrossCount < crossCount;
    }

    private void swapNodes(Node current, Node next, Rank rank) {
        int index = rank.indexOf(current);
        rank.set(index + 1, current);
        rank.set(index, next);
        index = current.index;
        current.index = next.index;
        next.index = index;
    }

    public void visit(DirectedGraph g) {
        boolean flag;
        do {
            flag = false;
            int r = 0;
            while (r < g.ranks.size()) {
                Rank rank = g.ranks.getRank(r);
                int n = 0;
                while (n < rank.count() - 1) {
                    Node nextNode;
                    Node currentNode = rank.getNode(n);
                    if (this.shouldSwap(currentNode, nextNode = rank.getNode(n + 1))) {
                        this.swapNodes(currentNode, nextNode, rank);
                        flag = true;
                        n = Math.max(0, n - 2);
                    }
                    ++n;
                }
                ++r;
            }
        } while (flag);
    }
}

