/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.ContextParamSpecifiedJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.DefaultJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.IJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.IJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.IJSFAppConfigProvidersChangeListener;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.InvalidWriteAccessModeException;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.JSFAppConfigProvidersChangeEvent;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.RuntimeClasspathJSFAppConfigLocater;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JSFAppConfigManager {
    public static final QualifiedName KEY_SESSIONPROPERTY = new QualifiedName("org.eclipse.jst.jsf.core", "JSFAppConfigManager");
    protected IProject project = null;
    protected LinkedHashSet configProviders = null;
    protected ArrayList configProvidersChangeListeners = null;
    protected LinkedHashSet configLocaters = null;

    private JSFAppConfigManager(IProject project) {
        this.project = project;
        this.initialize();
    }

    public IProject getProject() {
        return this.project;
    }

    protected void initialize() {
        this.configProviders = new LinkedHashSet();
        this.configProvidersChangeListeners = new ArrayList();
        this.configLocaters = new LinkedHashSet();
        this.populateConfigLocaters();
        this.locateConfigProviders(false);
        this.setAsSessionProperty();
    }

    protected void populateConfigLocaters() {
        this.configLocaters.add(new DefaultJSFAppConfigLocater());
        this.configLocaters.add(new ContextParamSpecifiedJSFAppConfigLocater());
        this.configLocaters.add(new RuntimeClasspathJSFAppConfigLocater());
    }

    public void locateConfigProviders(boolean clearFirst) {
        if (clearFirst) {
            this.disposeConfigProviders();
            this.configProviders.clear();
        }
        Iterator itConfigLocaters = this.configLocaters.iterator();
        while (itConfigLocaters.hasNext()) {
            IJSFAppConfigLocater configLocater = (IJSFAppConfigLocater)itConfigLocaters.next();
            configLocater.locateProviders(this);
        }
    }

    public void disposeConfigProviders() {
        Iterator itConfigProviders = this.configProviders.iterator();
        while (itConfigProviders.hasNext()) {
            IJSFAppConfigProvider configProvider = (IJSFAppConfigProvider)itConfigProviders.next();
            configProvider.releaseFacesConfigModel();
        }
    }

    public static JSFAppConfigManager getInstance(IProject project) {
        JSFAppConfigManager manager = null;
        if (JSFAppConfigManager.isValidProject(project) && (manager = JSFAppConfigManager.getFromSessionProperty(project)) == null) {
            manager = new JSFAppConfigManager(project);
        }
        return manager;
    }

    protected static boolean isValidProject(IProject project) {
        boolean isValid;
        block4: {
            isValid = false;
            if (project != null && project.isAccessible()) {
                try {
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                    if (facetedProject == null) break block4;
                    Set projectFacets = facetedProject.getProjectFacets();
                    Iterator itProjectFacets = projectFacets.iterator();
                    while (itProjectFacets.hasNext()) {
                        IProjectFacetVersion projectFacetVersion = (IProjectFacetVersion)itProjectFacets.next();
                        IProjectFacet projectFacet = projectFacetVersion.getProjectFacet();
                        if (!"jst.jsf".equals(projectFacet.getId())) continue;
                        isValid = true;
                        break;
                    }
                }
                catch (CoreException ce) {
                    JSFCorePlugin.log(4, ce.getLocalizedMessage(), ce);
                }
            }
        }
        return isValid;
    }

    protected static JSFAppConfigManager getFromSessionProperty(IProject project) {
        JSFAppConfigManager manager = null;
        try {
            Object obj = project.getSessionProperty(KEY_SESSIONPROPERTY);
            if (obj != null && obj instanceof JSFAppConfigManager) {
                manager = (JSFAppConfigManager)obj;
            }
        }
        catch (CoreException ce) {
            JSFCorePlugin.log(4, ce.getLocalizedMessage(), ce);
        }
        return manager;
    }

    protected void setAsSessionProperty() {
        if (this.project != null && this.project.isAccessible()) {
            try {
                this.project.setSessionProperty(KEY_SESSIONPROPERTY, (Object)this);
            }
            catch (CoreException ce) {
                JSFCorePlugin.log(4, ce.getLocalizedMessage(), ce);
            }
        }
    }

    protected void unsetAsSessionProperty() {
        if (this.project != null && this.project.isAccessible()) {
            try {
                this.project.setSessionProperty(KEY_SESSIONPROPERTY, null);
            }
            catch (CoreException ce) {
                JSFCorePlugin.log(4, ce.getLocalizedMessage(), ce);
            }
        }
    }

    public boolean addJSFAppConfigProvider(IJSFAppConfigProvider configProvider) {
        boolean added = this.configProviders.add(configProvider);
        if (added) {
            this.notifyJSFAppConfigProvidersChangeListeners(configProvider, 1);
        }
        return added;
    }

    public boolean removeJSFAppConfigProvider(IJSFAppConfigProvider configProvider) {
        boolean removed;
        if (configProvider != null) {
            configProvider.releaseFacesConfigModel();
        }
        if (removed = this.configProviders.remove(configProvider)) {
            this.notifyJSFAppConfigProvidersChangeListeners(configProvider, 2);
        }
        return removed;
    }

    public boolean addJSFAppConfigProvidersChangeListener(IJSFAppConfigProvidersChangeListener listener) {
        return this.configProvidersChangeListeners.add(listener);
    }

    public boolean removeJSFAppConfigProvidersChangeListener(IJSFAppConfigProvidersChangeListener listener) {
        return this.configProvidersChangeListeners.remove(listener);
    }

    protected void notifyJSFAppConfigProvidersChangeListeners(IJSFAppConfigProvider configProvider, int eventType) {
        JSFAppConfigProvidersChangeEvent event = new JSFAppConfigProvidersChangeEvent(configProvider, eventType);
        Iterator itListeners = this.configProvidersChangeListeners.iterator();
        while (itListeners.hasNext()) {
            IJSFAppConfigProvidersChangeListener listener = (IJSFAppConfigProvidersChangeListener)itListeners.next();
            listener.changedJSFAppConfigProviders(event);
        }
    }

    public FacesConfigType[] getFacesConfigModelsForRead() {
        ArrayList<FacesConfigType> facesConfigList = new ArrayList<FacesConfigType>();
        Iterator itConfigProviders = this.configProviders.iterator();
        while (itConfigProviders.hasNext()) {
            IJSFAppConfigProvider configProvider = (IJSFAppConfigProvider)itConfigProviders.next();
            try {
                FacesConfigType facesConfig = configProvider.getFacesConfigModel(false);
                if (facesConfig == null) continue;
                facesConfigList.add(facesConfig);
            }
            catch (InvalidWriteAccessModeException iwame) {
                JSFCorePlugin.log(4, iwame.getLocalizedMessage(), iwame);
            }
        }
        FacesConfigType[] facesConfigs = new FacesConfigType[facesConfigList.size()];
        facesConfigs = facesConfigList.toArray(facesConfigs);
        return facesConfigs;
    }

    protected void finalize() {
        this.unsetAsSessionProperty();
        this.configLocaters.clear();
        this.configProvidersChangeListeners.clear();
        this.disposeConfigProviders();
        this.configProviders.clear();
    }
}

