/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.core.common.data;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.wst.rdb.data.internal.core.common.data.BigIntegerFormat;

public class ResultSetReader {
    public static Object read(ResultSet rs, int column) throws SQLException, IOException {
        return ResultSetReader.read(rs, column, -1);
    }

    public static Object read(ResultSet rs, int column, int lobLimit) throws SQLException, IOException {
        int type = rs.getMetaData().getColumnType(column + 1);
        if (type == 1111) {
            return rs.getString(column + 1);
        }
        if (type == -5) {
            return new BigIntegerFormat().parse(rs.getString(column + 1));
        }
        Object o = rs.getObject(column + 1);
        if (o == null) {
            return null;
        }
        if (type == 93 && !(o instanceof Timestamp)) {
            return rs.getString(column + 1);
        }
        if (o instanceof Blob) {
            return ResultSetReader.readBinaryStream(((Blob)o).getBinaryStream(), lobLimit);
        }
        if (o instanceof Clob) {
            return ResultSetReader.readCharacterString(((Clob)o).getCharacterStream(), lobLimit);
        }
        return o;
    }

    protected static String readCharacterString(Reader r, int limit) throws SQLException, IOException {
        StringWriter w = new StringWriter();
        char[] buf = new char[256];
        int remaining = limit;
        int n = r.read(buf);
        while (n != -1) {
            w.write(buf, 0, n);
            if (limit != -1 && (remaining -= n) <= 0) break;
            n = r.read(buf);
        }
        r.close();
        w.close();
        String s = w.toString();
        if (limit != -1 && s.length() > limit) {
            s = s.substring(0, limit);
        }
        return s;
    }

    protected static Object readBinaryStream(InputStream is, int limit) throws SQLException, IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int n = ((InputStream)bis).read();
        while (n != -1) {
            os.write(n);
            if (limit != -1 && --limit <= 0) break;
            n = ((InputStream)bis).read();
        }
        ((InputStream)bis).close();
        byte[] bytes = os.toByteArray();
        os.close();
        return bytes;
    }
}

