/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.FileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public abstract class ContainerImpl
extends FileImpl
implements Container {
    protected LoadStrategy loadStrategy;
    protected Map fileIndex;
    protected FileNotificationAdapter fileIndexAdapter;
    protected EList files = null;
    static /* synthetic */ Class class$0;

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.CONTAINER;
    }

    public boolean containsFile(String aUri) {
        String key;
        String string = key = aUri.startsWith("/") ? ArchiveUtil.truncateFromFrontIgnoreCase(aUri, "/") : aUri;
        if (this.isIndexed()) {
            return this.getFileIndex().containsKey(key);
        }
        return this.getLoadStrategy().contains(key);
    }

    public String getAbsolutePath() throws FileNotFoundException {
        return this.getLoadStrategy().getAbsolutePath();
    }

    public File getFile(String URI2) throws FileNotFoundException {
        File file;
        if (!this.isIndexed()) {
            this.getFiles();
        }
        if ((file = (File)this.getFileIndex().get(URI2)) == null) {
            throw new FileNotFoundException(URI2);
        }
        return file;
    }

    protected Map getFileIndex() {
        if (this.fileIndex == null) {
            this.getFileIndexAdapter().rebuildFileIndex();
        }
        return this.fileIndex;
    }

    protected FileNotificationAdapter getFileIndexAdapter() {
        if (this.fileIndexAdapter == null) {
            this.fileIndexAdapter = new FileNotificationAdapter();
            this.eAdapters().add((Object)this.fileIndexAdapter);
        }
        return this.fileIndexAdapter;
    }

    public EList getFiles() {
        EList filesList = this.getFilesGen();
        if (!this.isIndexed()) {
            if (filesList.isEmpty() && this.getLoadStrategy() != null) {
                filesList.addAll((Collection)this.getLoadStrategy().collectFiles());
            }
            this.getFileIndex();
        }
        return filesList;
    }

    public InputStream getInputStream(String aUri) throws IOException, FileNotFoundException {
        if (this.isIndexed()) {
            return this.getFile(aUri).getInputStream();
        }
        return this.primGetInputStream(aUri);
    }

    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public boolean isContainer() {
        return true;
    }

    public boolean isIndexed() {
        return this.fileIndex != null;
    }

    public InputStream primGetInputStream(String aUri) throws IOException, FileNotFoundException {
        return this.getLoadStrategy().getInputStream(aUri);
    }

    public void rebuildFileIndex() {
        this.getFileIndexAdapter().rebuildFileIndex();
    }

    public void setLoadStrategy(LoadStrategy newLoadStrategy) {
        if (newLoadStrategy != null) {
            newLoadStrategy.setContainer(this);
            if (this.loadStrategy != null) {
                newLoadStrategy.setRendererType(this.loadStrategy.getRendererType());
                newLoadStrategy.setReadOnly(this.loadStrategy.isReadOnly());
                this.loadStrategy.setContainer(null);
                this.loadStrategy.close();
            }
        }
        this.loadStrategy = newLoadStrategy;
    }

    public EList getFilesGen() {
        if (this.files == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.File");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.files = new EObjectContainmentWithInverseEList((Class)clazz, (InternalEObject)this, 7, 6);
        }
        return this.files;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return ((InternalEList)this.getFiles()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return ((InternalEList)this.getFiles()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getFiles();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.getFiles().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return this.files != null && !this.files.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public void clearFiles() {
        boolean oldDelivery = this.eDeliver();
        this.files.clear();
        this.eSetDeliver(oldDelivery);
        if (this.isIndexed()) {
            this.eAdapters().remove((Object)this.fileIndexAdapter);
            this.fileIndexAdapter = null;
            this.fileIndex = null;
        }
    }

    protected class FileNotificationAdapter
    extends AdapterImpl {
        protected FileNotificationAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == "FileNotificationAdapter";
        }

        public void addIndexedFile(String newValue, Notifier notifier) {
            ContainerImpl.this.fileIndex.put(newValue, notifier);
            if (notifier.eAdapters() == null || !notifier.eAdapters().contains((Object)this)) {
                notifier.eAdapters().add((Object)this);
            }
        }

        public void removeIndexedFile(String oldValue, Notifier notifier) {
            ContainerImpl.this.fileIndex.remove(oldValue);
            notifier.eAdapters().remove((Object)this);
        }

        public void notifyChanged(Notification notification) {
            if (ContainerImpl.this.fileIndex == null || notification.getFeature() == null) {
                return;
            }
            if (notification.getFeature().equals(CommonarchivePackage.eINSTANCE.getFile_URI()) && ((File)notification.getNotifier()).getContainer() == ContainerImpl.this) {
                ContainerImpl.this.fileIndex.remove(notification.getOldValue());
                ContainerImpl.this.fileIndex.put(notification.getNewValue(), notification.getNotifier());
            }
            if (notification.getFeature().equals(CommonarchivePackage.eINSTANCE.getContainer_Files()) && notification.getNotifier() == ContainerImpl.this) {
                switch (notification.getEventType()) {
                    case 3: {
                        File file = (File)notification.getNewValue();
                        this.addIndexedFile(file.getURI(), (Notifier)file);
                        break;
                    }
                    case 4: {
                        this.removeIndexedFile(((File)notification.getOldValue()).getURI(), (Notifier)((File)notification.getOldValue()));
                        break;
                    }
                    case 5: {
                        this.filesAdded((List)notification.getNewValue());
                        break;
                    }
                    case 6: {
                        this.filesRemoved((List)notification.getOldValue());
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 1: {
                        if (notification.getPosition() == -1) break;
                        File file = (File)notification.getNewValue();
                        this.removeIndexedFile(((File)notification.getOldValue()).getURI(), (Notifier)((File)notification.getOldValue()));
                        this.addIndexedFile(file.getURI(), (Notifier)file);
                    }
                }
            }
        }

        public void filesAdded(List newFiles) {
            int i = 0;
            while (i < newFiles.size()) {
                File file = (File)newFiles.get(i);
                this.addIndexedFile(file.getURI(), (Notifier)file);
                ++i;
            }
        }

        public void filesRemoved(List oldFiles) {
            int i = 0;
            while (i < oldFiles.size()) {
                File file = (File)oldFiles.get(i);
                this.removeIndexedFile(file.getURI(), (Notifier)file);
                ++i;
            }
        }

        public void rebuildFileIndex() {
            this.removeAdaptersIfNecessary();
            ContainerImpl.this.fileIndex = new HashMap();
            if (ContainerImpl.this.getFiles().size() > 0) {
                Iterator i = ContainerImpl.this.getFiles().iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    this.addIndexedFile(file.getURI(), (Notifier)file);
                }
            }
        }

        public void removeAdaptersIfNecessary() {
            if (ContainerImpl.this.fileIndex == null) {
                return;
            }
            Iterator iter = ContainerImpl.this.fileIndex.values().iterator();
            while (iter.hasNext()) {
                File aFile = (File)iter.next();
                aFile.eAdapters().remove((Object)this);
            }
        }
    }
}

