/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.preferences.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.validation.internal.ui.ValidateAction;
import org.eclipse.wst.validation.internal.ui.ValidationUIMessages;
import org.osgi.service.prefs.BackingStoreException;

public class HTMLValidationPreferencePage
extends AbstractPreferencePage {
    private static final int[] SEVERITIES = new int[]{1, 2, -1};
    private List fCombos = new ArrayList();
    private SelectionListener fSelectionListener;
    private IPreferencesService fPreferencesService = Platform.getPreferencesService();
    private IScopeContext[] fScopeContext = null;

    protected Control createContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        page.setLayout((Layout)layout);
        Composite content = this.createValidationSection(page);
        GridData gridData = new GridData(4, 4, true, true);
        content.setLayoutData((Object)gridData);
        return page;
    }

    private Composite createValidationSection(Composite page) {
        int nColumns = 3;
        new Label(page, 0).setText(HTMLUIMessages.Validation_description);
        Group validationGroup = this.createGroup(page, nColumns);
        validationGroup.setText(HTMLUIMessages.Label_Elements);
        String[] errorWarningIgnoreLabel = new String[]{HTMLUIMessages.Validation_Error, HTMLUIMessages.Validation_Warning, HTMLUIMessages.Validation_Ignore};
        this.addComboBox((Composite)validationGroup, HTMLUIMessages.Validation_Missing_Start_Tag, "elemMissingStart", SEVERITIES, errorWarningIgnoreLabel, 0);
        this.addComboBox((Composite)validationGroup, HTMLUIMessages.Validation_Missing_End_Tag, "elemMissingEnd", SEVERITIES, errorWarningIgnoreLabel, 0);
        return page;
    }

    public boolean performOk() {
        if (super.performOk() && this.shouldRevalidateOnSettingsChange()) {
            MessageBox mb = new MessageBox(this.getShell(), 197058);
            mb.setText(HTMLUIMessages.Validation_Title);
            mb.setMessage(HTMLUIMessages.Validation_Workspace);
            switch (mb.open()) {
                case 256: {
                    return false;
                }
                case 64: {
                    Job validationJob = new Job(ValidationUIMessages.RunValidationDialogTitle){

                        protected IStatus run(IProgressMonitor monitor) {
                            ValidateAction vaction = new ValidateAction();
                            vaction.selectionChanged((IStructuredSelection)new StructuredSelection((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects()));
                            vaction.run();
                            return Status.OK_STATUS;
                        }
                    };
                    validationJob.schedule();
                }
            }
            return true;
        }
        return true;
    }

    protected boolean shouldRevalidateOnSettingsChange() {
        Iterator it = this.fCombos.iterator();
        while (it.hasNext()) {
            ComboData data = (ComboData)((Combo)it.next()).getData();
            if (!data.isChanged()) continue;
            return true;
        }
        return false;
    }

    protected void performDefaults() {
        this.resetSeverities();
        super.performDefaults();
    }

    protected void resetSeverities() {
        IEclipsePreferences defaultContext = new DefaultScope().getNode(this.getPreferenceNodeQualifier());
        int i = 0;
        while (i < this.fCombos.size()) {
            ComboData data = (ComboData)((Combo)this.fCombos.get(i)).getData();
            int severity = defaultContext.getInt(data.getKey(), 2);
            data.setSeverity(severity);
            ((Combo)this.fCombos.get(i)).select(data.getIndex());
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected String getPreferenceNodeQualifier() {
        return HTMLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    protected Combo addComboBox(Composite parent, String label, String key, int[] values, String[] valueLabels, int indent) {
        GridData gd = new GridData(4, 2, true, false, 2, 1);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16384);
        labelControl.setFont(JFaceResources.getDialogFont());
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = this.newComboControl(parent, key, values, valueLabels);
        comboBox.setLayoutData((Object)new GridData(256));
        return comboBox;
    }

    protected Combo newComboControl(Composite composite, String key, int[] values, String[] valueLabels) {
        ComboData data = new ComboData(key, values, -1);
        Combo comboBox = new Combo(composite, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.addSelectionListener(this.getSelectionListener());
        comboBox.setFont(JFaceResources.getDialogFont());
        int severity = -1;
        if (key != null) {
            severity = this.fPreferencesService.getInt(this.getPreferenceNodeQualifier(), key, 2, this.createPreferenceScopes());
        }
        if (severity == 1 || severity == 2 || severity == -1) {
            data.setSeverity(severity);
            data.originalSeverity = severity;
        }
        if (data.getIndex() >= 0) {
            comboBox.select(data.getIndex());
        }
        this.fCombos.add(comboBox);
        return comboBox;
    }

    protected SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    HTMLValidationPreferencePage.this.controlChanged(e.widget);
                }
            };
        }
        return this.fSelectionListener;
    }

    protected IScopeContext[] createPreferenceScopes() {
        if (this.fScopeContext == null) {
            this.fScopeContext = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        }
        return this.fScopeContext;
    }

    protected void controlChanged(Widget widget) {
        ComboData data = (ComboData)widget.getData();
        if (!(widget instanceof Combo)) {
            return;
        }
        data.setIndex(((Combo)widget).getSelectionIndex());
    }

    protected void storeValues() {
        if (this.fCombos == null || this.fCombos.size() == 0) {
            return;
        }
        Iterator it = this.fCombos.iterator();
        IScopeContext[] contexts = this.createPreferenceScopes();
        while (it.hasNext()) {
            ComboData data = (ComboData)((Combo)it.next()).getData();
            if (data.getKey() == null) continue;
            contexts[0].getNode(this.getPreferenceNodeQualifier()).putInt(data.getKey(), data.getSeverity());
        }
        int i = 0;
        while (i < contexts.length) {
            try {
                contexts[i].getNode(this.getPreferenceNodeQualifier()).flush();
            }
            catch (BackingStoreException backingStoreException) {}
            ++i;
        }
    }

    private class ComboData {
        private String fKey;
        private int[] fSeverities;
        private int fIndex;
        int originalSeverity = -2;

        public ComboData(String key, int[] severities, int index) {
            this.fKey = key;
            this.fSeverities = severities;
            this.fIndex = index;
        }

        public String getKey() {
            return this.fKey;
        }

        public void setIndex(int index) {
            this.fIndex = index;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public void setSeverity(int severity) {
            int i = 0;
            while (this.fSeverities != null && i < this.fSeverities.length) {
                if (this.fSeverities[i] == severity) {
                    this.fIndex = i;
                    return;
                }
                ++i;
            }
            this.fIndex = -1;
        }

        public int getSeverity() {
            return this.fIndex >= 0 && this.fSeverities != null && this.fIndex < this.fSeverities.length ? this.fSeverities[this.fIndex] : -1;
        }

        boolean isChanged() {
            return this.fSeverities[this.fIndex] != this.originalSeverity;
        }
    }
}

