/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.FileImpl;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.wizard.AvailableJarsProvider;
import org.eclipse.swt.graphics.Image;

public class AvailableUtilJarsAndWebLibProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof EARFile) {
            Object[] array = EARComponentImportDataModelProvider.getAllUtilities((EARFile)((EARFile)inputElement)).toArray();
            List filteredProjects = new ArrayList();
            if (array == null || array.length == 0) {
                return new Object[0];
            }
            filteredProjects = this.filterEJBClientJars(array, (EARFile)inputElement);
            array = filteredProjects.toArray();
            Arrays.sort(array, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return AvailableUtilJarsAndWebLibProvider.this.getColumnText(o1, 0).compareTo(AvailableUtilJarsAndWebLibProvider.this.getColumnText(o2, 0));
                }
            });
            return array;
        }
        return new Object[0];
    }

    private List filterEJBClientJars(Object[] array, EARFile ear) {
        ArrayList<Object> utilities = new ArrayList<Object>(array.length);
        int i = 0;
        while (i < array.length) {
            utilities.add(array[i]);
            ++i;
        }
        List ejbJars = ear.getEJBJarFiles();
        if (ejbJars != null) {
            ArrayList<String> clientNames = new ArrayList<String>(ejbJars.size());
            int j = 0;
            while (j < ejbJars.size()) {
                EJBJar jar = ((EJBJarFile)ejbJars.get(j)).getDeploymentDescriptor();
                if (jar != null) {
                    clientNames.add(jar.getEjbClientJar());
                }
                ++j;
            }
            if (clientNames != null && !clientNames.isEmpty()) {
                ArrayList toRemove = new ArrayList();
                int k = 0;
                while (k < clientNames.size()) {
                    String projectName = (String)clientNames.get(k);
                    int l = 0;
                    while (l < utilities.size()) {
                        File file = (File)utilities.get(l);
                        if (file.getName().equals(projectName)) {
                            toRemove.add(utilities.get(l));
                        }
                        ++l;
                    }
                    ++k;
                }
                utilities.removeAll(toRemove);
            }
        }
        return utilities;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return AvailableJarsProvider.getUtilImage();
    }

    public String getColumnText(Object element, int columnIndex) {
        FileImpl file = (FileImpl)element;
        if (file.getURI().startsWith("WEB-INF/lib/")) {
            String parentWarFileName = ((WARFile)file.eContainer()).getName();
            return String.valueOf(parentWarFileName) + "#" + file.getURI();
        }
        return file.getName();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

