/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.ui.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.rdb.data.internal.core.common.IColumnDataAccessor;
import org.eclipse.wst.rdb.data.internal.core.editor.IRowData;
import org.eclipse.wst.rdb.data.internal.core.editor.ITableData;
import org.eclipse.wst.rdb.data.internal.ui.DataUIPlugin;
import org.eclipse.wst.rdb.data.internal.ui.editor.Messages;
import org.eclipse.wst.rdb.data.internal.ui.editor.TableDataEditor;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;

public class TableDataCellModifier
implements ICellModifier {
    protected static final int MAX_LENGTH = Integer.MAX_VALUE;
    protected TableDataEditor editor;
    protected TableViewer viewer;
    protected boolean canModify = false;

    public TableDataCellModifier(TableDataEditor editor, TableViewer viewer) {
        this.editor = editor;
        this.viewer = viewer;
    }

    public boolean canModify(Object element, String property) {
        if (!this.canModify) {
            return false;
        }
        if (this.editor.isReadonly()) {
            return false;
        }
        int col = this.getColumnIndex(property);
        if (this.isColumnGenerated(col)) {
            return false;
        }
        ITableData tableData = this.editor.getTableData();
        if (element instanceof IRowData) {
            Object val = ((IRowData)element).getValue(col);
            int type = tableData.getColumnType(col);
            IColumnDataAccessor acc = tableData.getColumnDataAccessor(col);
            if (!acc.supportsInlineEdit() || acc.isSnippet(val, type)) {
                return false;
            }
            String s = acc.serialize(val, type);
            if (s != null && s.length() > Integer.MAX_VALUE) {
                return false;
            }
        }
        return true;
    }

    protected boolean isColumnGenerated(int colIndex) {
        Column sqlCol = (Column)this.editor.getSqlTable().getColumns().get(colIndex);
        return sqlCol.getIdentitySpecifier() != null;
    }

    public void setCanModify(boolean canModify) {
        this.canModify = canModify;
    }

    public Object getValue(Object element, String property) {
        int col = this.getColumnIndex(property);
        if (!(element instanceof IRowData)) {
            return "";
        }
        IRowData row = (IRowData)element;
        try {
            Object o = row.getValue(col);
            String s = row.getTable().getColumnDataAccessor(col).serialize(o, row.getTable().getColumnType(col));
            return s == null ? "" : s;
        }
        catch (Exception ex) {
            DataUIPlugin.getDefault().writeLog(4, 0, ex.getMessage(), ex);
            return Messages.getString("TableDataCellModifier.error");
        }
    }

    public void modify(Object element, String property, Object value) {
        int column = this.getColumnIndex(property);
        if (element instanceof Item) {
            element = ((Item)element).getData();
        }
        IRowData row = this.editor.getOrCreateRow();
        Object oldObject = row.getValue(column);
        String oldString = row.getTable().getColumnDataAccessor(column).serialize(oldObject, row.getTable().getColumnType(column));
        if (value.equals(oldString)) {
            return;
        }
        try {
            this.editor.setDirty(true);
            Object o = row.getTable().getColumnDataAccessor(column).deserialize((String)value, row.getTable().getColumnType(column));
            row.updateValue(column, o);
        }
        catch (Exception ex) {
            Status warning = new Status(4, "org.eclipse.wst.rdb.data.ui", 1, Messages.getString("TableDataCellModifier.dataFormatError"), (Throwable)ex);
            ErrorDialog.openError((Shell)this.viewer.getControl().getShell(), (String)Messages.getString("TableDataCellModifier.ErrorUpdatingData"), null, (IStatus)warning);
        }
        this.viewer.refresh((Object)row);
    }

    protected int getColumnIndex(String property) {
        Object[] properties = this.viewer.getColumnProperties();
        int col = 0;
        while (properties[col] != property && col < properties.length) {
            ++col;
        }
        if (col == properties.length) {
            return -1;
        }
        return col;
    }
}

