/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests.IVirtualResourceAPITest;

public abstract class IVirtualContainerAPITest
extends IVirtualResourceAPITest {
    protected IVirtualContainer targetVirtualContainer;
    protected IContainer targetPlatformContainer;
    protected IPath expectedPlatformContainerPath;
    protected IPath expectedFileSingleDepthPath = new Path("/jsps/TestJsp3.jsp");
    protected IPath expectedFolderSingleDepthPath = new Path("WEB-INF/lib");
    protected String expectedFolderName = "jsps";
    protected IPath expectedFolderZerothDepthPath = new Path(this.expectedFolderName);
    protected String expectedFileName = "TestFile1.txt";
    protected IPath expectedFileZerothDepthPath = new Path(this.expectedFileName);

    public IVirtualContainerAPITest(String name) {
        super(name);
    }

    protected void assertRequirements() {
        super.assertRequirements();
    }

    public void testGetFileString() {
        IVirtualFile testFile1txt = this.targetVirtualContainer.getFile(this.expectedFileName);
        IVirtualContainerAPITest.assertEquals((String)"The test file project relative path must match.", (Object)this.expectedPlatformContainerPath.append(this.expectedFileName), (Object)testFile1txt.getProjectRelativePath());
    }

    public void testGetFilePath() {
        IVirtualFile test3jsp = this.targetVirtualContainer.getFile(this.expectedFileSingleDepthPath);
        IPath expectedPath = this.expectedPlatformContainerPath.append(this.expectedFileSingleDepthPath);
        IVirtualContainerAPITest.assertEquals((String)"The test file project relative path must match.", (Object)expectedPath, (Object)test3jsp.getProjectRelativePath());
    }

    public void testGetFolderString() {
        IVirtualFolder jspsFolder = this.targetVirtualContainer.getFolder(this.expectedFolderName);
        IVirtualContainerAPITest.assertNotNull((String)"The folder should not be null.", (Object)jspsFolder);
        IVirtualContainerAPITest.assertEquals((String)"The name of the folder returned shouled match the expected folder.", (String)this.expectedFolderName, (String)jspsFolder.getName());
    }

    public void testGetFolderIPath() {
        IVirtualFolder testGetFolder = this.targetVirtualContainer.getFolder(this.expectedFolderZerothDepthPath);
        IVirtualContainerAPITest.assertNotNull((String)"The folder should not be null.", (Object)testGetFolder);
        IVirtualContainerAPITest.assertEquals((String)"The name of the folder returned shouled match the expected folder.", (Object)this.expectedFolderZerothDepthPath, (Object)testGetFolder.getRuntimePath());
    }

    public void testExistsIPath() {
        IVirtualContainerAPITest.assertTrue((String)"The expected file path should be found to exist.", (boolean)this.targetVirtualContainer.exists(this.expectedFileSingleDepthPath));
    }

    public void testFindMemberString() {
        IVirtualResource foundResource = this.targetVirtualContainer.findMember(this.expectedFolderName);
        IVirtualContainerAPITest.assertEquals((String)"The type found for the expected folder name should be IVirtualResource.FOLDER.", (int)32, (int)foundResource.getType());
        IVirtualFolder cfr_ignored_0 = (IVirtualFolder)foundResource;
        IVirtualContainerAPITest.assertEquals((String)"The name should be correct.", (String)this.expectedFolderName, (String)foundResource.getName());
        foundResource = this.targetVirtualContainer.findMember(this.expectedFileName);
        IVirtualContainerAPITest.assertEquals((String)"The type found for the expected folder name should be IVirtualResource.FILE.", (int)16, (int)foundResource.getType());
        IVirtualFile cfr_ignored_1 = (IVirtualFile)foundResource;
        IVirtualContainerAPITest.assertEquals((String)"The name should be correct.", (String)this.expectedFileName, (String)foundResource.getName());
    }

    public void testFindMemberStringint() {
        IVirtualResource foundResource = this.targetVirtualContainer.findMember(this.expectedFolderName, 0);
        IVirtualContainerAPITest.assertEquals((String)"The type found for the expected folder name should be IVirtualResource.FOLDER.", (int)32, (int)foundResource.getType());
        IVirtualFolder cfr_ignored_0 = (IVirtualFolder)foundResource;
        IVirtualContainerAPITest.assertEquals((String)"The name should be correct.", (String)this.expectedFolderName, (String)foundResource.getName());
        foundResource = this.targetVirtualContainer.findMember(this.expectedFolderName, 0);
        IVirtualContainerAPITest.assertEquals((String)"The type found for the expected folder name should be IVirtualResource.FILE.", (int)16, (int)foundResource.getType());
        IVirtualFile cfr_ignored_1 = (IVirtualFile)foundResource;
        IVirtualContainerAPITest.assertEquals((String)"The name should be correct.", (String)this.expectedFileName, (String)foundResource.getName());
    }

    public void testFindMemberIPath() {
        IVirtualResource foundResource = this.targetVirtualContainer.findMember(this.expectedFolderSingleDepthPath);
        IVirtualContainerAPITest.assertEquals((String)"The type found for the expected folder name should be IVirtualResource.FOLDER.", (int)32, (int)foundResource.getType());
        IVirtualFolder cfr_ignored_0 = (IVirtualFolder)foundResource;
        IVirtualContainerAPITest.assertEquals((String)"The name should be correct.", (String)this.expectedFolderSingleDepthPath.lastSegment(), (String)foundResource.getName());
        foundResource = this.targetVirtualContainer.findMember(this.expectedFileSingleDepthPath);
        IVirtualContainerAPITest.assertEquals((String)"The type found for the expected folder name should be IVirtualResource.FILE.", (int)16, (int)foundResource.getType());
        IVirtualFile cfr_ignored_1 = (IVirtualFile)foundResource;
        IVirtualContainerAPITest.assertEquals((String)"The name should be correct.", (String)this.expectedFileSingleDepthPath.lastSegment(), (String)foundResource.getName());
    }

    public void testFindMemberIPathint() {
        IVirtualResource foundResource = this.targetVirtualContainer.findMember(this.expectedFolderSingleDepthPath, 0);
        IVirtualContainerAPITest.assertEquals((String)"The type found for the expected folder name should be IVirtualResource.FOLDER.", (int)32, (int)foundResource.getType());
        IVirtualFolder cfr_ignored_0 = (IVirtualFolder)foundResource;
        IVirtualContainerAPITest.assertEquals((String)"The name should be correct.", (String)this.expectedFolderSingleDepthPath.lastSegment(), (String)foundResource.getName());
        foundResource = this.targetVirtualContainer.findMember(this.expectedFileSingleDepthPath, 0);
        IVirtualContainerAPITest.assertEquals((String)"The type found for the expected folder name should be IVirtualResource.FILE.", (int)16, (int)foundResource.getType());
        IVirtualFile cfr_ignored_1 = (IVirtualFile)foundResource;
        IVirtualContainerAPITest.assertEquals((String)"The name should be correct.", (String)this.expectedFileSingleDepthPath.lastSegment(), (String)foundResource.getName());
    }

    public void testMembers() {
    }

    public void testMembersint() {
    }

    public void testCreate() {
    }
}

