/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.plugin.ErrorDialog;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractActionDelegate
implements IActionDelegate {
    protected ISelection selection;
    protected boolean allowsMultiSelect = false;
    public static final Class IPROJECT_CLASS;
    private static final String ERROR_OCCURRED_TITLE;
    private static final String ERROR_OCCURRED_MESSAGE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IPROJECT_CLASS = clazz;
        ERROR_OCCURRED_TITLE = J2EEUIMessages.getResourceString("ERROR_OCCURRED_TITLE");
        ERROR_OCCURRED_MESSAGE = J2EEUIMessages.getResourceString("ERROR_OCCURRED_MESSAGE");
    }

    protected IProject getProject() {
        return this.getProject(this.getSelectedElement());
    }

    protected List getProjects() {
        if (this.selection == null || !(this.selection instanceof IStructuredSelection)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IProject> result = new ArrayList<IProject>();
        IStructuredSelection struct = (IStructuredSelection)this.selection;
        Iterator it = struct.iterator();
        while (it.hasNext()) {
            IProject p = this.getProject(it.next());
            if (p == null) continue;
            result.add(p);
        }
        return result;
    }

    protected IProject getProject(Object element) {
        if (this.isSupportedAction(element)) {
            return ProjectUtilities.getProject((EObject)((EObject)element));
        }
        if (element instanceof IAdaptable) {
            return (IProject)((IAdaptable)element).getAdapter(IPROJECT_CLASS);
        }
        return null;
    }

    protected IStructuredSelection getStructuredSelection() {
        if (this.selection == null || !(this.selection instanceof IStructuredSelection)) {
            return null;
        }
        if (this.selection.isEmpty()) {
            this.selection = J2EEUIPlugin.getCurrentSelection();
        }
        return (IStructuredSelection)this.selection;
    }

    protected Object getSelectedElement() {
        IStructuredSelection sel = this.getStructuredSelection();
        return sel == null ? null : sel.getFirstElement();
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return J2EEUIPlugin.getActiveWorkbenchWindow();
    }

    protected abstract boolean isSupportedAction(Object var1);

    protected void primRun(IProject project, Shell shell) {
    }

    protected void primRun(Shell shell) {
        this.primRun(this.getProject(), shell);
    }

    public void run(IAction action) {
        Shell shell = this.getWorkbenchWindow().getShell();
        this.setActionStateFromProjects(action);
        if (!action.isEnabled()) {
            MessageDialog.openInformation((Shell)shell, (String)J2EEUIMessages.getResourceString("INFORMATION_UI_"), (String)J2EEUIMessages.getResourceString("CHOSEN_OP_NOT_AVAILABLE"));
        } else {
            try {
                this.primRun(shell);
            }
            catch (Throwable t) {
                ErrorDialog.openError(shell, ERROR_OCCURRED_TITLE, ERROR_OCCURRED_MESSAGE, t, 0, false);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection aSelection) {
        this.selection = aSelection;
        this.setActionState(action);
    }

    protected void setActionState(IAction action) {
        if (this.allowsMultiSelect) {
            this.setActionStateForMultiSelect(action);
        } else {
            this.setActionStateForSingleSelect(action);
        }
    }

    protected void setActionStateForSingleSelect(IAction action) {
        IStructuredSelection sel = this.getStructuredSelection();
        if (sel == null || sel.size() != 1) {
            action.setEnabled(false);
            return;
        }
        this.setActionStateFromProjects(action);
    }

    protected void setActionStateForMultiSelect(IAction action) {
        this.setActionStateFromProjects(action);
    }

    protected void setActionStateFromProjects(IAction action) {
        IStructuredSelection sel = this.getStructuredSelection();
        boolean allOk = false;
        if (sel != null && !sel.isEmpty()) {
            allOk = true;
            Iterator it = sel.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                IProject project = this.getProject(o);
                if (project != null && project.isOpen()) continue;
                allOk = false;
                break;
            }
        }
        action.setEnabled(allOk);
    }

    public boolean allowsMultiSelect() {
        return this.allowsMultiSelect;
    }

    public void setAllowsMultiSelect(boolean allowsMultiSelect) {
        this.allowsMultiSelect = allowsMultiSelect;
    }
}

