/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.section;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ClassButtonDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringDialogField;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitClassType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitIdType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.jst.jsf.facesconfig.ui.util.ModelUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RenderkitGeneralSection
extends AbstractFacesConfigSection {
    private StringDialogField displayNameField;
    private StringDialogField descriptionField;
    private StringDialogField renderkitIdField;
    private ClassButtonDialogField renderkitClassField;
    private RenderKitGeneralAdapter renderKitGeneralAdapter;

    public RenderkitGeneralSection(Composite parent, IManagedForm managedForm, IFacesConfigPage page, FormToolkit toolkit) {
        super(parent, managedForm, page, toolkit, null, null);
        this.getSection().setText(EditorMessages.RenderKitGeneralSection_Name);
        this.getSection().setDescription(EditorMessages.RenderKitGeneralSection_Description);
    }

    protected void createContents(Composite container, FormToolkit toolkit) {
        int numberOfColumns = 4;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        container.setLayout((Layout)layout);
        GridData td = new GridData(768);
        container.setLayoutData((Object)td);
        toolkit.paintBordersFor(container);
        this.displayNameField = new StringDialogField();
        this.displayNameField.setLabelText(EditorMessages.RenderKitGeneralSection_Label_DisplayName);
        this.displayNameField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.displayNameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newDisplayNameValue = ((StringDialogField)field).getText().trim();
                Command cmd = null;
                RenderKitType Renderkit = (RenderKitType)RenderkitGeneralSection.this.getInput();
                EditingDomain editingDomain = RenderkitGeneralSection.this.getEditingDomain();
                if (Renderkit.getDisplayName().size() > 0) {
                    DisplayNameType displayName = (DisplayNameType)Renderkit.getDisplayName().get(0);
                    cmd = SetCommand.create((EditingDomain)editingDomain, (Object)displayName, (Object)FacesConfigPackage.eINSTANCE.getDisplayNameType_TextContent(), (Object)newDisplayNameValue);
                } else {
                    DisplayNameType displayNameType = FacesConfigFactory.eINSTANCE.createDisplayNameType();
                    displayNameType.setTextContent(newDisplayNameValue);
                    displayNameType.eAdapters().add((Object)RenderkitGeneralSection.this.getRenderKitGeneralAdapter());
                    cmd = AddCommand.create((EditingDomain)editingDomain, (Object)Renderkit, (Object)FacesConfigPackage.eINSTANCE.getRenderKitType_DisplayName(), (Object)displayNameType);
                }
                if (cmd.canExecute()) {
                    editingDomain.getCommandStack().execute(cmd);
                }
            }
        });
        this.descriptionField = new StringDialogField(2);
        this.descriptionField.setLabelText(EditorMessages.RenderKitGeneralSection_Label_Description);
        this.descriptionField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.descriptionField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String newDescriptionValue = ((StringDialogField)field).getText().trim();
                newDescriptionValue = ModelUtil.escapeEntities(newDescriptionValue);
                Command cmd = null;
                RenderKitType Renderkit = (RenderKitType)RenderkitGeneralSection.this.getInput();
                EditingDomain editingDomain = RenderkitGeneralSection.this.getEditingDomain();
                if (Renderkit.getDescription().size() > 0) {
                    DescriptionType description = (DescriptionType)Renderkit.getDescription().get(0);
                    cmd = SetCommand.create((EditingDomain)editingDomain, (Object)description, (Object)FacesConfigPackage.eINSTANCE.getDescriptionType_TextContent(), (Object)newDescriptionValue);
                } else {
                    DescriptionType description = FacesConfigFactory.eINSTANCE.createDescriptionType();
                    description.setTextContent(newDescriptionValue);
                    description.eAdapters().add((Object)RenderkitGeneralSection.this.getRenderKitGeneralAdapter());
                    cmd = AddCommand.create((EditingDomain)editingDomain, (Object)Renderkit, (Object)FacesConfigPackage.eINSTANCE.getRenderKitType_Description(), (Object)description);
                }
                if (cmd.canExecute()) {
                    editingDomain.getCommandStack().execute(cmd);
                }
            }
        });
        this.renderkitIdField = new StringDialogField();
        this.renderkitIdField.setLabelText(EditorMessages.RenderKitGeneralSection_Label_RenderKitID);
        this.renderkitIdField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.renderkitIdField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                Command command;
                RenderKitIdType RenderkitId = FacesConfigFactory.eINSTANCE.createRenderKitIdType();
                RenderkitId.setTextContent(((StringDialogField)field).getText());
                EditingDomain editingDomain = RenderkitGeneralSection.this.getEditingDomain();
                if (editingDomain != null && (command = SetCommand.create((EditingDomain)editingDomain, (Object)RenderkitGeneralSection.this.getInput(), (Object)FacesConfigPackage.eINSTANCE.getRenderKitType_RenderKitId(), (Object)RenderkitId)).canExecute()) {
                    editingDomain.getCommandStack().execute(command);
                }
            }
        });
        this.renderkitClassField = new ClassButtonDialogField(null);
        this.renderkitClassField.setLabelText(EditorMessages.RenderKitGeneralSection_Label_RenderKitClass);
        this.renderkitClassField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.renderkitClassField.setProject((IProject)this.getPage().getEditor().getAdapter(IProject.class));
        LayoutUtil.setHorizontalGrabbing((Control)this.renderkitClassField.getTextControl(toolkit, container));
        this.renderkitClassField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                Command command;
                RenderKitClassType RenderkitClass = FacesConfigFactory.eINSTANCE.createRenderKitClassType();
                RenderkitClass.setTextContent(((StringDialogField)field).getText());
                EditingDomain editingDomain = RenderkitGeneralSection.this.getEditingDomain();
                if (editingDomain != null && (command = SetCommand.create((EditingDomain)editingDomain, (Object)RenderkitGeneralSection.this.getInput(), (Object)FacesConfigPackage.eINSTANCE.getRenderKitType_RenderKitClass(), (Object)RenderkitClass)).canExecute()) {
                    editingDomain.getCommandStack().execute(command);
                }
            }
        });
        this.renderkitClassField.setSuperClassName("javax.faces.render.RenderKit");
    }

    public void refreshAll() {
        this.refresh();
    }

    public void refresh() {
        if (this.getSection() == null || this.getSection().isDisposed()) {
            return;
        }
        super.refresh();
        Object input = this.getInput();
        if (input instanceof RenderKitType) {
            RenderKitType Renderkit = (RenderKitType)input;
            if (Renderkit.getDisplayName().size() > 0) {
                DisplayNameType displayName = (DisplayNameType)Renderkit.getDisplayName().get(0);
                this.displayNameField.setTextWithoutUpdate(displayName.getTextContent());
            } else {
                this.displayNameField.setTextWithoutUpdate("");
            }
            if (Renderkit.getDescription().size() > 0) {
                DescriptionType description = (DescriptionType)Renderkit.getDescription().get(0);
                String descriptionString = description.getTextContent();
                descriptionString = ModelUtil.unEscapeEntities(descriptionString);
                this.descriptionField.setTextWithoutUpdate(descriptionString);
            } else {
                this.descriptionField.setTextWithoutUpdate("");
            }
            if (Renderkit.getRenderKitId() != null) {
                this.renderkitIdField.setTextWithoutUpdate(Renderkit.getRenderKitId().getTextContent());
            } else {
                this.renderkitIdField.setTextWithoutUpdate("");
            }
            if (Renderkit.getRenderKitClass() != null) {
                this.renderkitClassField.setTextWithoutUpdate(Renderkit.getRenderKitClass().getTextContent());
            } else {
                this.renderkitClassField.setTextWithoutUpdate("");
            }
        }
    }

    protected void addAdaptersOntoInput(Object newInput) {
        DescriptionType description;
        DisplayNameType displayName;
        RenderKitType renderkit = (RenderKitType)newInput;
        if (EcoreUtil.getExistingAdapter((Notifier)renderkit, RenderkitGeneralSection.class) == null) {
            renderkit.eAdapters().add((Object)this.getRenderKitGeneralAdapter());
        }
        if (renderkit.getDisplayName().size() > 0 && EcoreUtil.getExistingAdapter((Notifier)(displayName = (DisplayNameType)renderkit.getDisplayName().get(0)), RenderkitGeneralSection.class) == null) {
            displayName.eAdapters().add((Object)this.getRenderKitGeneralAdapter());
        }
        if (renderkit.getDescription().size() > 0 && EcoreUtil.getExistingAdapter((Notifier)(description = (DescriptionType)renderkit.getDescription().get(0)), RenderkitGeneralSection.class) == null) {
            description.eAdapters().add((Object)this.getRenderKitGeneralAdapter());
        }
    }

    protected void removeAdaptersFromInput(Object oldInput) {
        DescriptionType description;
        DisplayNameType displayName;
        RenderKitType renderkit = (RenderKitType)oldInput;
        if (EcoreUtil.getExistingAdapter((Notifier)renderkit, RenderkitGeneralSection.class) != null) {
            renderkit.eAdapters().remove((Object)this.getRenderKitGeneralAdapter());
        }
        if (renderkit.getDisplayName().size() > 0 && EcoreUtil.getExistingAdapter((Notifier)(displayName = (DisplayNameType)renderkit.getDisplayName().get(0)), RenderkitGeneralSection.class) != null) {
            displayName.eAdapters().remove((Object)this.getRenderKitGeneralAdapter());
        }
        if (renderkit.getDescription().size() > 0 && EcoreUtil.getExistingAdapter((Notifier)(description = (DescriptionType)renderkit.getDescription().get(0)), RenderkitGeneralSection.class) != null) {
            description.eAdapters().remove((Object)this.getRenderKitGeneralAdapter());
        }
    }

    private Adapter getRenderKitGeneralAdapter() {
        if (this.renderKitGeneralAdapter == null) {
            this.renderKitGeneralAdapter = new RenderKitGeneralAdapter();
        }
        return this.renderKitGeneralAdapter;
    }

    class RenderKitGeneralAdapter
    extends AdapterImpl {
        RenderKitGeneralAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == RenderkitGeneralSection.class;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() == 3 || msg.getEventType() == 4 || msg.getEventType() == 1) {
                if (msg.getFeature() == FacesConfigPackage.eINSTANCE.getRenderKitType_RenderKitId() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getRenderKitType_RenderKitClass() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getRenderKitType_Description() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getRenderKitType_DisplayName()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            RenderkitGeneralSection.this.refresh();
                        }
                    });
                } else if (msg.getFeature() == FacesConfigPackage.eINSTANCE.getDisplayNameType_TextContent() || msg.getFeature() == FacesConfigPackage.eINSTANCE.getDescriptionType_TextContent()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            RenderkitGeneralSection.this.refresh();
                        }
                    });
                }
            }
        }
    }
}

