/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.msg.XMLMessageFormatter;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.XIncludeAwareParserConfiguration;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.validation.ValidatorHelper;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationConfiguration;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationInfo;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationMessages;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationReport;
import org.eclipse.wst.xml.core.internal.validation.core.LazyURLInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidator {
    protected URIResolver uriResolver = null;
    protected Hashtable ingoredErrorKeyTable = new Hashtable();
    protected Set adjustLocationErrorKeySet = new TreeSet();
    protected static final String IGNORE_ALWAYS = "IGNORE_ALWAYS";
    protected static final String IGNORE_IF_DTD_WITHOUT_ELEMENT_DECL = "IGNORE_IF_DTD_WITHOUT_ELEMENT_DECL";
    protected static final String PREMATURE_EOF = "PrematureEOF";
    protected static final String ROOT_ELEMENT_TYPE_MUST_MATCH_DOCTYPEDECL = "RootElementTypeMustMatchDoctypedecl";
    protected static final String MSG_ELEMENT_NOT_DECLARED = "MSG_ELEMENT_NOT_DECLARED";
    protected static final String NO_GRAMMAR_FOUND = "NO_GRAMMAR_FOUND";
    private static final String FILE_NOT_FOUND_KEY = "FILE_NOT_FOUND";

    public XMLValidator() {
        this.ingoredErrorKeyTable.put(PREMATURE_EOF, IGNORE_ALWAYS);
        this.ingoredErrorKeyTable.put(ROOT_ELEMENT_TYPE_MUST_MATCH_DOCTYPEDECL, IGNORE_IF_DTD_WITHOUT_ELEMENT_DECL);
        this.ingoredErrorKeyTable.put(MSG_ELEMENT_NOT_DECLARED, IGNORE_IF_DTD_WITHOUT_ELEMENT_DECL);
        this.adjustLocationErrorKeySet.add("MSG_CONTENT_INVALID");
        this.adjustLocationErrorKeySet.add("MSG_CONTENT_INCOMPLETE");
        this.adjustLocationErrorKeySet.add("cvc-complex-type.2.4.b");
        this.adjustLocationErrorKeySet.add("cvc-complex-type.2.3");
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected XMLReader createXMLReader(final XMLValidationInfo valinfo, XMLEntityResolver entityResolver) throws Exception {
        SAXParser reader = null;
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                MyStandardParserConfiguration configuration = new MyStandardParserConfiguration(valinfo);
                reader = new SAXParser((XMLParserConfiguration)configuration){
                    private XMLLocator locator = null;

                    public void startDocument(XMLLocator theLocator, String encoding, NamespaceContext nscontext, Augmentations augs) {
                        this.locator = theLocator;
                        valinfo.setXMLLocator(theLocator);
                        super.startDocument(theLocator, encoding, nscontext, augs);
                    }

                    public void startElement(QName arg0, XMLAttributes arg1, Augmentations arg2) throws XNIException {
                        valinfo.getStartElementLocations().push(new LocationCoordinate(this.locator.getLineNumber(), this.locator.getColumnNumber()));
                        super.startElement(arg0, arg1, arg2);
                    }

                    public void endElement(QName arg0, Augmentations arg1) throws XNIException {
                        super.endElement(arg0, arg1);
                        valinfo.getStartElementLocations().pop();
                    }
                };
                reader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", valinfo.isNamespaceEncountered());
                reader.setFeature("http://xml.org/sax/features/namespaces", valinfo.isNamespaceEncountered());
                reader.setFeature("http://xml.org/sax/features/validation", valinfo.isGrammarEncountered());
                reader.setFeature("http://apache.org/xml/features/validation/schema", valinfo.isGrammarEncountered());
                reader.setFeature("http://apache.org/xml/features/xinclude", valinfo.isUseXInclude());
                reader.setContentHandler(new DefaultHandler(){

                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        valinfo.getErrorCustomizationManager().startElement(uri, localName);
                    }

                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        valinfo.getErrorCustomizationManager().endElement(uri, localName);
                    }
                });
                if (entityResolver != null) {
                    reader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", entityResolver);
                }
                reader.setProperty("http://xml.org/sax/properties/declaration-handler", new MyDeclHandler());
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            Thread.currentThread().setContextClassLoader(prevClassLoader);
            throw throwable;
        }
        {
            Object var6_9 = null;
            Thread.currentThread().setContextClassLoader(prevClassLoader);
            return reader;
        }
    }

    public XMLValidationReport validate(String uri) {
        return this.validate(uri, null, new XMLValidationConfiguration());
    }

    final String createStringForInputStream(InputStream inputStream) {
        StringBuffer fileString = new StringBuffer();
        try {
            InputStreamReader inputReader = new InputStreamReader(inputStream, "UTF-8");
            BufferedReader reader = new BufferedReader(inputReader);
            char[] chars = new char[1024];
            int numberRead = reader.read(chars);
            while (numberRead != -1) {
                fileString.append(chars, 0, numberRead);
                numberRead = reader.read(chars);
            }
        }
        catch (Exception exception) {}
        return fileString.toString();
    }

    public XMLValidationReport validate(String uri, InputStream inputStream) {
        return this.validate(uri, inputStream, new XMLValidationConfiguration());
    }

    public XMLValidationReport validate(String uri, InputStream inputStream, XMLValidationConfiguration configuration) {
        return this.validate(uri, inputStream, configuration, null);
    }

    public XMLValidationReport validate(String uri, InputStream inputStream, XMLValidationConfiguration configuration, ValidationResult result) {
        String grammarFile = "";
        StringReader reader1 = null;
        StringReader reader2 = null;
        if (inputStream != null) {
            String string = this.createStringForInputStream(inputStream);
            reader1 = new StringReader(string);
            reader2 = new StringReader(string);
        }
        XMLValidationInfo valinfo = new XMLValidationInfo(uri);
        MyEntityResolver entityResolver = new MyEntityResolver(this.uriResolver);
        ValidatorHelper helper = new ValidatorHelper();
        try {
            helper.computeValidationInformation(uri, reader1, this.uriResolver);
            valinfo.setDTDEncountered(helper.isDTDEncountered);
            valinfo.setElementDeclarationCount(helper.numDTDElements);
            valinfo.setNamespaceEncountered(helper.isNamespaceEncountered);
            valinfo.setGrammarEncountered(helper.isGrammarEncountered);
            XMLReader reader = this.createXMLReader(valinfo, entityResolver);
            XMLErrorHandler errorhandler = new XMLErrorHandler(valinfo);
            reader.setErrorHandler(errorhandler);
            InputSource inputSource = new InputSource(uri);
            inputSource.setCharacterStream(reader2);
            reader.parse(inputSource);
            if (configuration.getIntFeature(XMLValidationConfiguration.INDICATE_NO_GRAMMAR) > 0 && valinfo.isValid() && !helper.isGrammarEncountered) {
                if (configuration.getIntFeature(XMLValidationConfiguration.INDICATE_NO_GRAMMAR) == 1) {
                    valinfo.addWarning(XMLValidationMessages._WARN_NO_GRAMMAR, 1, 0, uri, NO_GRAMMAR_FOUND, null);
                } else {
                    valinfo.addError(XMLValidationMessages._WARN_NO_GRAMMAR, 1, 0, uri, NO_GRAMMAR_FOUND, null);
                }
            }
            grammarFile = helper.isDTDEncountered ? entityResolver.getLocation() : helper.schemaLocationString;
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (IOException ioException) {
            this.addValidationMessage(valinfo, ioException);
        }
        catch (Exception exception) {
            Logger.logException(exception.getLocalizedMessage(), exception);
        }
        if (result != null) {
            try {
                IResource resource = this.getWorkspaceFileFromLocation(grammarFile);
                ArrayList<IResource> resources = new ArrayList<IResource>();
                if (resource != null) {
                    resources.add(resource);
                }
                result.setDependsOn(resources.toArray(new IResource[0]));
            }
            catch (Exception e) {
                Logger.logException(e.getLocalizedMessage(), e);
            }
        }
        return valinfo;
    }

    protected void addValidationMessage(XMLValidationInfo valinfo, IOException exception) {
        String validationMessageStr = exception.getMessage();
        Throwable cause = exception.getCause() != null ? exception.getCause() : exception;
        while (validationMessageStr == null && cause != null) {
            String localizedMessage = cause.getLocalizedMessage();
            if ((cause = cause.getCause()) != null || localizedMessage == null) continue;
            validationMessageStr = localizedMessage;
        }
        if (validationMessageStr != null) {
            if (cause instanceof FileNotFoundException) {
                validationMessageStr = NLS.bind((String)XMLValidationMessages._UI_PROBLEMS_VALIDATING_FILE_NOT_FOUND, (Object[])new Object[]{validationMessageStr});
            } else if (cause instanceof UnknownHostException) {
                validationMessageStr = NLS.bind((String)XMLValidationMessages._UI_PROBLEMS_VALIDATING_UNKNOWN_HOST, (Object[])new Object[]{validationMessageStr});
            } else if (cause instanceof ConnectException) {
                validationMessageStr = XMLValidationMessages._UI_PROBLEMS_CONNECTION_REFUSED;
            }
        }
        if (validationMessageStr != null) {
            XMLLocator locator = valinfo.getXMLLocator();
            valinfo.addWarning(validationMessageStr, locator != null ? locator.getLineNumber() : 1, locator != null ? locator.getColumnNumber() : 0, valinfo.getFileURI(), FILE_NOT_FOUND_KEY, null);
        }
    }

    protected void addValidationMessage(XMLValidationInfo valinfo, SAXParseException exception) {
        if (exception.getMessage() != null) {
            valinfo.addError(exception.getLocalizedMessage(), exception.getLineNumber(), exception.getColumnNumber(), exception.getSystemId());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XMLInputSource _internalResolveEntity(URIResolver uriResolver, XMLResourceIdentifier rid) throws IOException {
        XMLInputSource is = null;
        if (uriResolver != null) {
            String id = rid.getPublicId();
            if (id == null) {
                id = rid.getNamespace();
            }
            String location = null;
            if (id != null || rid.getLiteralSystemId() != null) {
                location = uriResolver.resolve(rid.getBaseSystemId(), id, rid.getLiteralSystemId());
            }
            if (location != null) {
                String physical;
                block8: {
                    physical = uriResolver.resolvePhysicalLocation(rid.getBaseSystemId(), id, location);
                    is = new XMLInputSource(rid.getPublicId(), location, location);
                    InputStream isTemp = null;
                    try {
                        isTemp = new URL(physical).openStream();
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (isTemp != null) {
                            isTemp.close();
                        }
                        throw throwable;
                    }
                    {
                        Object var7_9 = null;
                        if (isTemp == null) break block8;
                    }
                    isTemp.close();
                }
                is.setByteStream((InputStream)new LazyURLInputStream(physical));
            }
        }
        return is;
    }

    protected IResource getWorkspaceFileFromLocation(String location) {
        if (location == null) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path canonicalForm = new Path(location);
        Path pathLocation = new Path(URIHelper.removeProtocol((String)canonicalForm.toString()));
        IFile resourceFile = workspace.getRoot().getFileForLocation((IPath)pathLocation);
        return resourceFile;
    }

    protected class LocationCoordinate {
        private int lineNo = -1;
        private int columnNo = -1;

        public LocationCoordinate(int lineNumber, int columnNumber) {
            this.lineNo = lineNumber;
            this.columnNo = columnNumber;
        }

        public int getLineNumber() {
            return this.lineNo;
        }

        public int getColumnNumner() {
            return this.columnNo;
        }
    }

    protected class MyDeclHandler
    implements DeclHandler {
        public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) {
        }

        public void elementDecl(String name, String model) {
        }

        public void externalEntityDecl(String name, String publicId, String systemId) {
        }

        public void internalEntityDecl(String name, String value) {
        }
    }

    protected class MyEntityResolver
    implements XMLEntityResolver {
        private URIResolver uriResolver;
        private String resolvedDTDLocation;

        public MyEntityResolver(URIResolver uriResolver) {
            this.uriResolver = uriResolver;
        }

        public XMLInputSource resolveEntity(XMLResourceIdentifier rid) throws XNIException, IOException {
            try {
                XMLInputSource inputSource = XMLValidator._internalResolveEntity(this.uriResolver, rid);
                if (inputSource != null) {
                    this.resolvedDTDLocation = inputSource.getSystemId();
                }
                return inputSource;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public String getLocation() {
            return this.resolvedDTDLocation;
        }
    }

    protected class MyStandardParserConfiguration
    extends XIncludeAwareParserConfiguration {
        XMLValidationInfo valinfo = null;
        List reportedExceptions = new ArrayList();

        public MyStandardParserConfiguration(XMLValidationInfo valinfo) {
            this.valinfo = valinfo;
            XMLErrorReporter errorReporter = this.createErrorReporter();
            if (errorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210") == null) {
                XMLMessageFormatter xmft = new XMLMessageFormatter();
                errorReporter.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", (MessageFormatter)xmft);
                errorReporter.putMessageFormatter("http://www.w3.org/TR/1999/REC-xml-names-19990114", (MessageFormatter)xmft);
            }
            this.fErrorReporter = errorReporter;
            this.setProperty("http://apache.org/xml/properties/internal/error-reporter", errorReporter);
            this.fCommonComponents.remove(this.fErrorReporter);
            this.fCommonComponents.add(this.fErrorReporter);
        }

        protected XMLErrorReporter createErrorReporter() {
            return new XMLErrorReporter(this){
                final /* synthetic */ MyStandardParserConfiguration this$1;
                {
                    this.this$1 = myStandardParserConfiguration;
                }

                public void reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
                    Object location;
                    boolean reportError = true;
                    this.this$1.valinfo.setCurrentErrorKey(key);
                    this.this$1.valinfo.setMessageArguments(arguments);
                    String ignoreCondition = (String)MyStandardParserConfiguration.access$0((MyStandardParserConfiguration)this.this$1).ingoredErrorKeyTable.get(key);
                    if (ignoreCondition != null) {
                        boolean isDTDWithoutElementDeclarationEncountered;
                        reportError = ignoreCondition.equals("IGNORE_IF_DTD_WITHOUT_ELEMENT_DECL") ? !(isDTDWithoutElementDeclarationEncountered = this.this$1.valinfo.isDTDWithoutElementDeclarationEncountered()) : false;
                    }
                    if ("schema_reference.4".equals(key) && arguments.length > 0 && (location = arguments[0]) != null) {
                        if (this.this$1.reportedExceptions.contains(location)) {
                            reportError = false;
                        } else {
                            this.this$1.reportedExceptions.add(location);
                        }
                    }
                    if (reportError) {
                        super.reportError(domain, key, arguments, severity);
                        this.this$1.valinfo.getErrorCustomizationManager().considerReportedError(this.this$1.valinfo, key, arguments);
                    }
                }
            };
        }

        static /* synthetic */ XMLValidator access$0(MyStandardParserConfiguration myStandardParserConfiguration) {
            return myStandardParserConfiguration.XMLValidator.this;
        }
    }

    protected class XMLErrorHandler
    implements ErrorHandler {
        private final int ERROR = 0;
        private final int WARNING = 1;
        private XMLValidationInfo valinfo;

        public XMLErrorHandler(XMLValidationInfo valinfo) {
            this.valinfo = valinfo;
        }

        protected void addValidationMessage(SAXParseException exception, int severity) {
            if (exception.getSystemId() != null) {
                int lineNumber = exception.getLineNumber();
                int columnNumber = exception.getColumnNumber();
                String currentErrorKey = this.valinfo.currentErrorKey;
                if (currentErrorKey != null && XMLValidator.this.adjustLocationErrorKeySet.contains(currentErrorKey)) {
                    LocationCoordinate adjustedCoordinates = (LocationCoordinate)this.valinfo.getStartElementLocations().peek();
                    lineNumber = adjustedCoordinates.getLineNumber();
                    columnNumber = adjustedCoordinates.getColumnNumner();
                }
                if (severity == 1) {
                    this.valinfo.addWarning(exception.getLocalizedMessage(), lineNumber, columnNumber, exception.getSystemId());
                } else {
                    this.valinfo.addError(exception.getLocalizedMessage(), lineNumber, columnNumber, exception.getSystemId(), this.valinfo.getCurrentErrorKey(), this.valinfo.getMessageArguments());
                }
            }
        }

        public void error(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 0);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 0);
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 1);
        }
    }
}

