/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.jsp;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.common.internal.JSPUtil;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.designtime.internal.jsp.JSPModelProcessor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class StartupHandler
implements IStartup {
    private final JSPEditorListener _partListener = new JSPEditorListener();

    public void earlyStartup() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchPage[] pages = windows[i].getPages();
                    int j = 0;
                    while (j < pages.length) {
                        IEditorReference[] editorReferences = pages[j].getEditorReferences();
                        int k = 0;
                        while (k < editorReferences.length) {
                            if (StartupHandler.this._partListener.isValidJSPEditor(editorReferences[k])) {
                                StartupHandler.this._partListener.setJSPModelListener(editorReferences[k]);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    windows[i].getPartService().addPartListener((IPartListener2)StartupHandler.this._partListener);
                    ++i;
                }
                PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

                    public void windowActivated(IWorkbenchWindow window) {
                    }

                    public void windowDeactivated(IWorkbenchWindow window) {
                    }

                    public void windowClosed(IWorkbenchWindow window) {
                        window.getPartService().removePartListener((IPartListener2)StartupHandler.this._partListener);
                    }

                    public void windowOpened(IWorkbenchWindow window) {
                        window.getPartService().addPartListener((IPartListener2)StartupHandler.this._partListener);
                    }
                });
            }
        });
    }

    private static class JSPEditorListener
    implements IPartListener2 {
        private JSPModelProcessor _processor;

        private JSPEditorListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            if (this.isValidJSPEditor(partRef)) {
                this.setJSPModelListener((IEditorReference)partRef);
            }
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        private boolean isJSPEditor(IEditorReference editorRef) {
            IFile file = this.getIFile(editorRef);
            if (file != null) {
                return JSPUtil.isJSPContentType((IFile)file);
            }
            return false;
        }

        boolean isValidJSPEditor(IEditorReference editorRef) {
            IFile file = this.getIFile(editorRef);
            return file != null && JSFAppConfigUtils.isValidJSFProject(file.getProject()) && this.isJSPEditor(editorRef);
        }

        boolean isValidJSPEditor(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                return this.isValidJSPEditor((IEditorReference)partRef);
            }
            return false;
        }

        void setJSPModelListener(IEditorReference editorRef) {
            IFile file = this.getIFile(editorRef);
            if (file != null) {
                try {
                    this._processor = JSPModelProcessor.get(file);
                    this._processor.refresh(false);
                }
                catch (Exception e) {
                    JSFCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.jsf.core", 0, "Error acquiring model processor", (Throwable)e));
                }
            }
        }

        IFile getIFile(IEditorReference editorRef) {
            try {
                IEditorInput editorInput = editorRef.getEditorInput();
                Object adapt = editorInput.getAdapter(IFile.class);
                if (adapt instanceof IFile) {
                    return (IFile)adapt;
                }
            }
            catch (PartInitException excp) {
                JSFCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.jsf.core", 0, "Error acquiring editor input", (Throwable)excp));
            }
            return null;
        }
    }
}

