/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

class ColorFontFieldEditor
extends FieldEditor {
    private static final int NUM_CONTROLS_WHEN_PREVIEWER = 4;
    private static final int NUM_CONTROLS_WHEN_NO_PREVIEWER = 3;
    private Button changeFontButton = null;
    private String changeButtonText;
    private String previewText;
    private FontData[] chosenFont;
    private RGB fontRGB;
    private Label valueControl;
    private DefaultPreviewer previewer;

    protected ColorFontFieldEditor() {
    }

    public ColorFontFieldEditor(String name, String labelText, String previewAreaText, Composite parent) {
        this.init(name, labelText);
        this.previewText = previewAreaText;
        this.changeButtonText = JFaceResources.getString((String)"openChange");
        this.createControl(parent);
    }

    public ColorFontFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, null, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData data = new GridData();
        if (this.valueControl.getLayoutData() != null) {
            data = (GridData)this.valueControl.getLayoutData();
        }
        data.horizontalSpan = numColumns - this.getNumberOfControls() + 1;
        this.valueControl.setLayoutData((Object)data);
    }

    protected void applyFont() {
        if (this.chosenFont != null && this.previewer != null) {
            this.previewer.setFont(this.chosenFont);
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.valueControl = this.getValueControl(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns - this.getNumberOfControls() + 1;
        this.valueControl.setLayoutData((Object)gd);
        if (this.previewText != null) {
            this.previewer = new DefaultPreviewer(this.previewText, parent);
            gd = new GridData(768);
            gd.heightHint = this.previewer.getPreferredExtent();
            gd.widthHint = this.previewer.getPreferredExtent();
            this.previewer.getControl().setLayoutData((Object)gd);
        }
        this.changeFontButton = this.getChangeControl(parent);
        gd = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels((Control)this.changeFontButton, 61);
        gd.widthHint = Math.max(widthHint, this.changeFontButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.changeFontButton.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.changeFontButton == null) {
            return;
        }
        this.fontRGB = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)(String.valueOf(this.getPreferenceName()) + "Color"));
        this.updateFont(PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        if (this.changeFontButton == null) {
            return;
        }
        this.updateFont(PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.chosenFont != null) {
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName(), (FontData[])this.chosenFont);
        }
        if (this.fontRGB != null) {
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)(String.valueOf(this.getPreferenceName()) + "Color"), (RGB)this.fontRGB);
        }
    }

    protected Button getChangeControl(Composite parent) {
        if (this.changeFontButton == null) {
            this.changeFontButton = new Button(parent, 8);
            if (this.changeButtonText != null) {
                this.changeFontButton.setText(this.changeButtonText);
            }
            this.changeFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FontData font;
                    FontDialog fontDialog = new FontDialog(ColorFontFieldEditor.this.changeFontButton.getShell());
                    if (ColorFontFieldEditor.this.chosenFont != null) {
                        fontDialog.setFontList(ColorFontFieldEditor.this.chosenFont);
                    }
                    if (ColorFontFieldEditor.this.fontRGB != null) {
                        fontDialog.setRGB(ColorFontFieldEditor.this.fontRGB);
                    }
                    if ((font = fontDialog.open()) != null) {
                        FontData[] oldFont = ColorFontFieldEditor.this.chosenFont;
                        if (oldFont == null) {
                            oldFont = JFaceResources.getDefaultFont().getFontData();
                        }
                        ColorFontFieldEditor.this.setPresentsDefaultValue(false);
                        FontData[] newData = new FontData[]{font};
                        ColorFontFieldEditor.this.fontRGB = fontDialog.getRGB();
                        ColorFontFieldEditor.this.updateFont(newData);
                        ColorFontFieldEditor.this.fireValueChanged("field_editor_value", oldFont[0], font);
                    }
                }
            });
            this.changeFontButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ColorFontFieldEditor.this.changeFontButton = null;
                }
            });
            this.changeFontButton.setFont(parent.getFont());
            this.setButtonLayoutData(this.changeFontButton);
        } else {
            this.checkParent((Control)this.changeFontButton, parent);
        }
        return this.changeFontButton;
    }

    public int getNumberOfControls() {
        if (this.previewer == null) {
            return 3;
        }
        return 4;
    }

    public int getPreferredPreviewHeight() {
        if (this.previewer == null) {
            return -1;
        }
        return this.previewer.getPreferredExtent();
    }

    public Control getPreviewControl() {
        if (this.previewer == null) {
            return null;
        }
        return this.previewer.getControl();
    }

    protected Label getValueControl(Composite parent) {
        if (this.valueControl == null) {
            this.valueControl = new Label(parent, 16384);
            this.valueControl.setFont(parent.getFont());
            this.valueControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ColorFontFieldEditor.this.valueControl = null;
                }
            });
        } else {
            this.checkParent((Control)this.valueControl, parent);
        }
        return this.valueControl;
    }

    public void setChangeButtonText(String text) {
        Assert.isNotNull((Object)text);
        this.changeButtonText = text;
        if (this.changeFontButton != null) {
            this.changeFontButton.setText(text);
        }
    }

    private void updateFont(FontData[] font) {
        FontData[] bestFont = JFaceResources.getFontRegistry().filterData(font, this.valueControl.getDisplay());
        if (bestFont == null) {
            bestFont = this.getDefaultFontData();
        }
        this.chosenFont = bestFont;
        if (this.valueControl != null) {
            if (this.fontRGB != null) {
                ColorRegistry registry = JFaceResources.getColorRegistry();
                Color color = registry.get(this.fontRGB.toString());
                if (color == null) {
                    registry.put(this.fontRGB.toString(), this.fontRGB);
                    color = registry.get(this.fontRGB.toString());
                }
                this.valueControl.setForeground(color);
            }
            this.valueControl.setText(StringConverter.asString((FontData)this.chosenFont[0]));
        }
        if (this.previewer != null) {
            this.previewer.setFont(bestFont);
        }
    }

    protected void setToDefault() {
        FontData[] defaultFontData = PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName());
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName(), (FontData[])defaultFontData);
    }

    private FontData[] getDefaultFontData() {
        return this.valueControl.getDisplay().getSystemFont().getFontData();
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getChangeControl(parent).setEnabled(enabled);
        this.getValueControl(parent).setEnabled(enabled);
    }

    private static class DefaultPreviewer {
        private Text text;
        private String string;
        private Font font;
        private Color color;

        public DefaultPreviewer(String s, Composite parent) {
            this.string = s;
            this.text = new Text(parent, 2056);
            this.text.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (DefaultPreviewer.this.font != null) {
                        DefaultPreviewer.this.font.dispose();
                    }
                }
            });
            if (this.string != null) {
                this.text.setText(this.string);
            }
        }

        public Control getControl() {
            return this.text;
        }

        public void setFont(FontData[] fontData) {
            if (this.font != null && !this.font.isDisposed()) {
                this.font.dispose();
            }
            this.font = new Font((Device)this.text.getDisplay(), fontData);
            this.text.setFont(this.font);
        }

        public void setRGB(RGB fontRGB) {
            if (fontRGB != null) {
                if (this.color != null && !this.color.isDisposed()) {
                    this.color.dispose();
                }
                this.color = new Color(null, fontRGB);
                this.text.setForeground(this.color);
            }
        }

        public int getPreferredExtent() {
            return 40;
        }
    }
}

