/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.classpathdep;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;

public class ClasspathDependencyManifestUtil {
    private static ConcurrentHashMap<String, String> manifestClasspaths = new ConcurrentHashMap();

    public static void updateManifestClasspath(IFile manifestFile, List dynamicURIs, OutputStream outputStream) throws IOException, FileNotFoundException {
        ClasspathDependencyManifestUtil.updateManifestClasspathImpl(manifestFile, dynamicURIs, null, outputStream);
    }

    public static void updateManifestClasspath(IFile manifestFile, List dynamicURIs, File outputFile) throws IOException, FileNotFoundException {
        ClasspathDependencyManifestUtil.updateManifestClasspathImpl(manifestFile, dynamicURIs, outputFile, null);
    }

    private static void updateManifestClasspathImpl(IFile manifestFile, List dynamicURIs, File outputFile, OutputStream stream) throws IOException, FileNotFoundException {
        OutputStream outputStream = stream;
        try {
            InputStream in = null;
            ArchiveManifestImpl manifest = null;
            try {
                try {
                    in = manifestFile.getContents();
                    manifest = new ArchiveManifestImpl(in);
                }
                catch (CoreException ce) {
                    throw new IOException(ce.getLocalizedMessage());
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                        in = null;
                    }
                    catch (IOException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                }
            }
            String[] manifestClasspath = manifest.getClassPathTokenized();
            ArrayList<String> updatedCP = new ArrayList<String>();
            int i = 0;
            while (i < manifestClasspath.length) {
                updatedCP.add(manifestClasspath[i]);
                ++i;
            }
            int j = 0;
            while (j < dynamicURIs.size()) {
                String containerURI = (String)dynamicURIs.get(j);
                boolean exists = false;
                int i2 = 0;
                while (i2 < manifestClasspath.length) {
                    if (manifestClasspath[i2].equals(containerURI)) {
                        exists = true;
                        break;
                    }
                    ++i2;
                }
                if (!exists) {
                    updatedCP.add(containerURI);
                }
                ++j;
            }
            StringBuffer cpBuffer = new StringBuffer();
            boolean first = true;
            int j2 = 0;
            while (j2 < updatedCP.size()) {
                if (!first) {
                    cpBuffer.append(" ");
                } else {
                    first = false;
                }
                cpBuffer.append((String)updatedCP.get(j2));
                ++j2;
            }
            String cp = cpBuffer.toString();
            if (outputStream != null) {
                manifest.setClassPath(cp);
                manifest.write(outputStream);
                outputStream.flush();
            } else {
                String manifestPath = manifestFile.getFullPath().toString();
                String priorClasspath = manifestClasspaths.get(manifestPath);
                if (priorClasspath == null || !priorClasspath.equals(cp) || !outputFile.exists()) {
                    manifestClasspaths.put(manifestPath, cp);
                    manifest.setClassPath(cp);
                    outputStream = new FileOutputStream(outputFile);
                    manifest.write(outputStream);
                    outputStream.flush();
                }
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }
}

