/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.engine.RankedWordProposal;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposalComputer;

public final class WordCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private static final int PREFIX_RANK_SHIFT = 500;

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (this.contributes()) {
            try {
                ISpellCheckEngine engine;
                ISpellChecker checker;
                IDocument document = context.getDocument();
                final int offset = context.getInvocationOffset();
                IRegion region = document.getLineInformationOfOffset(offset);
                String content = document.get(region.getOffset(), region.getLength());
                int index = offset - region.getOffset() - 1;
                while (index >= 0 && Character.isLetter(content.charAt(index))) {
                    --index;
                }
                int start = region.getOffset() + index + 1;
                String candidate = content.substring(index + 1, offset - region.getOffset());
                if (candidate.length() > 0 && (checker = (engine = SpellCheckEngine.getInstance()).getSpellChecker()) != null) {
                    ArrayList proposals = new ArrayList(checker.getProposals(candidate, Character.isUpperCase(candidate.charAt(0))));
                    ArrayList<1> result = new ArrayList<1>(proposals.size());
                    Iterator it = proposals.iterator();
                    while (it.hasNext()) {
                        RankedWordProposal word = (RankedWordProposal)it.next();
                        String text = word.getText();
                        if (text.startsWith(candidate)) {
                            word.setRank(word.getRank() + 500);
                        }
                        result.add(new JavaCompletionProposal(text, start, candidate.length(), JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_rename.gif"), text, word.getRank()){

                            public boolean validate(IDocument doc, int validate_offset, DocumentEvent event) {
                                return offset == validate_offset;
                            }
                        });
                    }
                    return result;
                }
            }
            catch (BadLocationException exception) {
                JavaScriptPlugin.log(exception);
            }
        }
        return Collections.EMPTY_LIST;
    }

    private boolean contributes() {
        return PreferenceConstants.getPreferenceStore().getBoolean("spelling_enable_contentassist");
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
    }
}

