/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.perspective;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.ws.internal.explorer.plugin.ExplorerPlugin;
import org.eclipse.wst.ws.internal.explorer.transport.ISOAPTransportProvider;

public class TransportProviderRegistry {
    private static final String PREF_TRANSPORT_PROVIDERS = "TRANSPORT_PROVIDERS";
    private static final String EXTENSION_NAME = "wseTransportProvider";
    private static final String SOAP_TRANSPORT_PROVIDER = "soapTransportProvider";
    private static final String NAMESPACE_URI = "namespaceURI";
    private static final String TRANSPORT_URI = "transportURI";
    private static TransportProviderRegistry instance = null;
    private List preferredIDs = null;
    private Map soapProviderElements = null;
    private Map soapProviderCache = null;

    public static synchronized TransportProviderRegistry getInstance() {
        if (instance == null) {
            instance = new TransportProviderRegistry();
        }
        return instance;
    }

    private TransportProviderRegistry() {
        Preferences preferences = ExplorerPlugin.getInstance().getPluginPreferences();
        String transportProviders = preferences.getString(PREF_TRANSPORT_PROVIDERS).replaceAll("\\s", "");
        this.preferredIDs = transportProviders.length() == 0 ? new ArrayList() : Arrays.asList(transportProviders.split(","));
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] configs = registry.getConfigurationElementsFor("org.eclipse.wst.ws.explorer", EXTENSION_NAME);
        this.soapProviderElements = new Hashtable();
        int i = 0;
        while (i < configs.length) {
            if (SOAP_TRANSPORT_PROVIDER.equals(configs[i].getName())) {
                String id = configs[i].getAttribute("id");
                this.soapProviderElements.put(id, configs[i]);
            }
            ++i;
        }
        this.soapProviderCache = new Hashtable();
    }

    private boolean uriMatch(String required, String supported) {
        if (supported == null) {
            return true;
        }
        if (!required.endsWith("/")) {
            required = String.valueOf(required) + "/";
        }
        if (!supported.endsWith("/")) {
            supported = String.valueOf(supported) + "/";
        }
        return required.equals(supported);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISOAPTransportProvider createExtension(Object key, String namespaceURI, String transportURI) {
        IConfigurationElement element = (IConfigurationElement)this.soapProviderElements.get(key);
        if (element == null) {
            return null;
        }
        boolean supportsNamespace = this.uriMatch(namespaceURI, element.getAttribute(NAMESPACE_URI));
        boolean supportsTransport = this.uriMatch(transportURI, element.getAttribute(TRANSPORT_URI));
        if (supportsNamespace && supportsTransport) {
            String providerClassID = element.getAttribute("class");
            Object obj = null;
            try {
                Map map = this.soapProviderCache;
                synchronized (map) {
                    obj = this.soapProviderCache.get(providerClassID);
                    if (obj == null) {
                        obj = element.createExecutableExtension("class");
                        this.soapProviderCache.put(providerClassID, obj);
                    }
                }
                return (ISOAPTransportProvider)obj;
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public ISOAPTransportProvider getSOAPTransportProvider(String namespaceURI, String transportURI) {
        ISOAPTransportProvider provider = null;
        Iterator<Object> iter = this.preferredIDs.iterator();
        while (iter.hasNext()) {
            provider = this.createExtension(iter.next(), namespaceURI, transportURI);
            if (provider == null) continue;
            return provider;
        }
        for (Object key : this.soapProviderElements.keySet()) {
            if (this.preferredIDs.contains(key) || (provider = this.createExtension(key, namespaceURI, transportURI)) == null) continue;
            return provider;
        }
        return null;
    }
}

