/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.resolver;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.IMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.designtime.resolver.AbstractSymbolContextResolver;
import org.eclipse.jst.jsf.designtime.resolver.SymbolContextResolver;

public final class CachingSymbolContextResolver
extends AbstractSymbolContextResolver {
    private static final ISymbol SYMBOL_NOT_FOUND = SymbolFactory.eINSTANCE.createIComponentSymbol();
    private static final IMethodSymbol METHOD_SYMBOL_NOT_FOUND = SymbolFactory.eINSTANCE.createIMethodSymbol();
    private final SymbolContextResolver _delegate;
    private final Map<String, ISymbol> _variablesByName = new HashMap<String, ISymbol>();
    private ISymbol[] _allVariables;
    private final Map<ISymbol, Map<Object, ISymbol>> _propertiesByOwner = new HashMap<ISymbol, Map<Object, ISymbol>>();
    private ISymbol[] _allProperties;
    private final Map<IObjectSymbol, Map<Object, IMethodSymbol>> _methodsByOwner = new HashMap<IObjectSymbol, Map<Object, IMethodSymbol>>();
    private ISymbol[] _allMethods;

    public CachingSymbolContextResolver(IStructuredDocumentContext context) {
        this._delegate = new SymbolContextResolver(context);
    }

    public boolean canResolveContext(IModelContext modelContext) {
        return this._delegate.canResolveContext(modelContext);
    }

    public ISymbol[] getAllVariables() {
        if (this._allVariables == null) {
            this._allVariables = this._delegate.getAllVariables();
        }
        return this._allVariables;
    }

    public IMethodSymbol getMethod(IObjectSymbol base, Object methodName) {
        IMethodSymbol method;
        Map<Object, IMethodSymbol> methods = this._methodsByOwner.get(base);
        if (methods == null) {
            methods = new HashMap<Object, IMethodSymbol>();
            this._methodsByOwner.put(base, methods);
        }
        if ((method = methods.get(methodName)) == SYMBOL_NOT_FOUND) {
            method = null;
        } else if (method == null) {
            method = this._delegate.getMethod(base, methodName);
            if (method == null) {
                methods.put(methodName, METHOD_SYMBOL_NOT_FOUND);
            } else {
                methods.put(methodName, method);
            }
        }
        return method;
    }

    public ISymbol[] getMethods(IObjectSymbol base) {
        if (this._allMethods == null) {
            this._allMethods = this._delegate.getMethods(base);
        }
        return this._allMethods;
    }

    public ISymbol[] getProperties(ISymbol symbol) {
        if (this._allProperties == null) {
            this._allProperties = this._delegate.getProperties(symbol);
        }
        return this._allProperties;
    }

    public ISymbol getProperty(ISymbol symbol, Object propertyName) {
        ISymbol property;
        Map<Object, ISymbol> properties = this._propertiesByOwner.get(symbol);
        if (properties == null) {
            properties = new HashMap<Object, ISymbol>();
            this._propertiesByOwner.put(symbol, properties);
        }
        if ((property = properties.get(propertyName)) == SYMBOL_NOT_FOUND) {
            property = null;
        } else if (property == null) {
            property = this._delegate.getProperty(symbol, propertyName);
            if (property == null) {
                properties.put(propertyName, SYMBOL_NOT_FOUND);
            } else {
                properties.put(propertyName, property);
            }
        }
        return property;
    }

    public ISymbol getVariable(String name) {
        ISymbol variable = this._variablesByName.get(name);
        if (variable == SYMBOL_NOT_FOUND) {
            variable = null;
        } else if (variable == null) {
            variable = this._delegate.getVariable(name);
            if (variable == null) {
                this._variablesByName.put(name, SYMBOL_NOT_FOUND);
            } else {
                this._variablesByName.put(name, variable);
            }
        }
        return variable;
    }

    public boolean hasSameResolution(IModelContext modelContext) {
        return this._delegate.hasSameResolution(modelContext);
    }
}

