/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.contentoutline;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;

public class PropertyChangeUpdateActionContributionItem
extends ActionContributionItem {
    static final boolean debug = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/propertyChangeUpdateActionContributionItem"));
    private IPropertyChangeListener fListener = null;
    protected String fProperty = null;
    private IPreferenceStore fStore;

    public PropertyChangeUpdateActionContributionItem(PropertyChangeUpdateAction action) {
        super((IAction)action);
        this.fProperty = action.getPreferenceKey();
        this.fStore = action.getPreferenceStore();
        this.fListener = new PreferenceUpdateListener();
        this.connect();
    }

    public void connect() {
        if (debug) {
            System.out.println("PropertyChangeUpdateActionContributionItem started listening for " + this.fProperty);
        }
        if (this.fStore != null) {
            this.fStore.addPropertyChangeListener(this.fListener);
        }
    }

    public void disconnect() {
        if (debug) {
            System.out.println("PropertyChangeUpdateActionContributionItem stopped listening for " + this.fProperty);
        }
        if (this.fStore != null) {
            this.fStore.removePropertyChangeListener(this.fListener);
        }
    }

    public void dispose() {
        super.dispose();
        this.disconnect();
        this.fProperty = null;
        this.fStore = null;
    }

    public String toString() {
        if (this.getAction().getId() != null) {
            return super.toString();
        }
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "(text=" + this.getAction().getText() + ")";
    }

    private class PreferenceUpdateListener
    implements IPropertyChangeListener {
        private PreferenceUpdateListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(PropertyChangeUpdateActionContributionItem.this.fProperty)) {
                if (debug) {
                    System.out.println(String.valueOf(PropertyChangeUpdateActionContributionItem.this.fProperty) + " preference changed, updating " + PropertyChangeUpdateActionContributionItem.this.getAction());
                }
                ((IUpdate)PropertyChangeUpdateActionContributionItem.this.getAction()).update();
            }
        }
    }
}

