/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;

class ReadOnlyController {
    private static ReadOnlyController fInstance;

    static synchronized ReadOnlyController getInstance() {
        if (fInstance == null) {
            fInstance = new ReadOnlyController();
        }
        return fInstance;
    }

    private static void lock(IStructuredDocument doc, int offset, int length, boolean canInsertBefore, boolean canInsertAfter) {
        if (doc == null) {
            return;
        }
        if (doc instanceof BasicStructuredDocument) {
            ((BasicStructuredDocument)doc).makeReadOnly(offset, length, canInsertBefore, canInsertAfter);
        } else {
            doc.makeReadOnly(offset, length);
        }
    }

    private static void lock(IStructuredDocumentRegion node, boolean canInsertBefore, boolean canInsertAfter) {
        if (node == null) {
            return;
        }
        IStructuredDocument doc = node.getParentDocument();
        if (doc == null) {
            return;
        }
        if (doc instanceof BasicStructuredDocument) {
            ((BasicStructuredDocument)doc).makeReadOnly(node.getStart(), node.getLength(), canInsertBefore, canInsertAfter);
        } else {
            doc.makeReadOnly(node.getStart(), node.getLength());
        }
    }

    private static void unlock(IStructuredDocumentRegion node) {
        if (node == null) {
            return;
        }
        IStructuredDocument doc = node.getParentDocument();
        if (doc == null) {
            return;
        }
        doc.clearReadOnly(node.getStart(), node.getLength());
    }

    private ReadOnlyController() {
    }

    private Span getDataSpan(IDOMNode node) {
        switch (node.getNodeType()) {
            case 1: {
                return this.getDataSpanForElement((IDOMElement)node);
            }
            case 3: {
                return this.getDataSpanForText((IDOMText)node);
            }
        }
        return new Span(0, -1);
    }

    private Span getDataSpanForElement(IDOMElement node) {
        String endType;
        String startType;
        IStructuredDocumentRegion docRegion = node.getStartStructuredDocumentRegion();
        if (docRegion == null) {
            return new Span(0, -1);
        }
        ITextRegionList regions = docRegion.getRegions();
        if (regions == null) {
            return new Span(0, -1);
        }
        if (node.isCommentTag()) {
            startType = "XML_COMMENT_OPEN";
            endType = "XML_COMMENT_CLOSE";
        } else {
            startType = "XML_TAG_NAME";
            endType = "XML_TAG_CLOSE";
        }
        int startOffset = -1;
        int endOffset = -1;
        ITextRegion prevRegion = null;
        int i = 0;
        while (i < regions.size()) {
            ITextRegion region = regions.get(i);
            String type = region.getType();
            if (type == startType) {
                startOffset = region.getEnd();
            } else if (type == endType && prevRegion != null) {
                endOffset = prevRegion.getTextEnd();
            }
            prevRegion = region;
            ++i;
        }
        if (startOffset >= 0 && endOffset >= 0) {
            return new Span(startOffset, endOffset - startOffset);
        }
        return new Span(0, -1);
    }

    private Span getDataSpanForText(IDOMText node) {
        IStructuredDocumentRegion docRegion = ((NodeImpl)((Object)node)).getStructuredDocumentRegion();
        if (docRegion == null) {
            return new Span(0, -1);
        }
        return new Span(0, docRegion.getLength());
    }

    void lockBoth(IDOMNode node) {
        IStructuredDocumentRegion flatNode;
        if (node == null) {
            return;
        }
        boolean canInsert = false;
        if (node.getNodeType() == 1 && (flatNode = node.getEndStructuredDocumentRegion()) != null) {
            canInsert = node.isChildEditable();
            ReadOnlyController.lock(flatNode, canInsert, false);
        }
        if ((flatNode = node.getStartStructuredDocumentRegion()) != null) {
            ReadOnlyController.lock(flatNode, false, canInsert);
        }
    }

    void lockData(IDOMNode node) {
        if (node == null) {
            return;
        }
        Span span = this.getDataSpan(node);
        if (span.length >= 0) {
            ReadOnlyController.lock(node.getModel().getStructuredDocument(), node.getStartOffset() + span.offset, span.length, false, false);
        }
    }

    void lockDeep(IDOMNode node) {
        if (node == null) {
            return;
        }
        int offset = node.getStartOffset();
        int length = node.getEndOffset() - offset;
        boolean canInsert = true;
        IDOMNode parent = (IDOMNode)node.getParentNode();
        if (parent != null && !parent.isChildEditable()) {
            canInsert = false;
        }
        ReadOnlyController.lock(node.getStructuredDocument(), offset, length, canInsert, canInsert);
    }

    void lockNode(IDOMNode node) {
        IStructuredDocumentRegion flatNode;
        if (node == null) {
            return;
        }
        if (!node.isDataEditable()) {
            this.lockBoth(node);
            return;
        }
        boolean canInsert = false;
        if (node.getNodeType() == 1 && (flatNode = node.getEndStructuredDocumentRegion()) != null) {
            canInsert = node.isChildEditable();
            ReadOnlyController.lock(flatNode, canInsert, false);
        }
        if ((flatNode = node.getStartStructuredDocumentRegion()) != null) {
            Span span = this.getDataSpan(node);
            if (span.length >= 0) {
                IStructuredDocument structuredDocument = flatNode.getParentDocument();
                int offset = flatNode.getStart();
                int length = span.offset;
                ReadOnlyController.lock(structuredDocument, offset, length, false, false);
                offset = offset + span.offset + span.length;
                length = flatNode.getEnd() - offset;
                ReadOnlyController.lock(structuredDocument, offset, length, canInsert, false);
            } else {
                ReadOnlyController.lock(flatNode, false, canInsert);
            }
        }
    }

    private void unlock(IStructuredDocument doc, int offset, int length) {
        if (doc == null) {
            return;
        }
        doc.clearReadOnly(offset, length);
    }

    void unlockBoth(IDOMNode node) {
        if (node == null) {
            return;
        }
        IStructuredDocumentRegion flatNode = node.getStartStructuredDocumentRegion();
        if (flatNode != null) {
            ReadOnlyController.unlock(flatNode);
        }
        if ((flatNode = node.getEndStructuredDocumentRegion()) != null) {
            ReadOnlyController.unlock(flatNode);
        }
    }

    void unlockData(IDOMNode node) {
        if (node == null) {
            return;
        }
        Span span = this.getDataSpan(node);
        if (span.length >= 0) {
            this.unlock(node.getModel().getStructuredDocument(), span.offset, span.length);
        }
    }

    void unlockDeep(IDOMNode node) {
        if (node == null) {
            return;
        }
        int offset = node.getStartOffset();
        int length = node.getEndOffset() - offset;
        this.unlock(node.getStructuredDocument(), offset, length);
    }

    void unlockNode(IDOMNode node) {
        IStructuredDocumentRegion flatNode;
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 1 && (flatNode = node.getEndStructuredDocumentRegion()) != null) {
            ReadOnlyController.unlock(flatNode);
        }
        if ((flatNode = node.getStartStructuredDocumentRegion()) != null) {
            if (node.isDataEditable()) {
                ReadOnlyController.unlock(flatNode);
            } else {
                Span span = this.getDataSpan(node);
                if (span.length <= 0) {
                    ReadOnlyController.unlock(flatNode);
                } else {
                    IStructuredDocument structuredDocument = flatNode.getParentDocument();
                    int offset = flatNode.getStart();
                    int length = span.offset - offset;
                    this.unlock(structuredDocument, offset, length);
                    offset = span.offset + span.length;
                    length = flatNode.getEnd() - span.offset;
                    this.unlock(structuredDocument, offset, length);
                }
            }
        }
    }

    class Span {
        int length;
        int offset;

        Span(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

