/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.internal.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.wst.internet.monitor.core.internal.Connection;
import org.eclipse.wst.internet.monitor.core.internal.Messages;
import org.eclipse.wst.internet.monitor.core.internal.Trace;
import org.eclipse.wst.internet.monitor.core.internal.http.HTTPConnection;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;

public class HTTPThread
extends Thread {
    private static final int BUFFER = 2048;
    private static final byte CR = 13;
    private static final byte LF = 10;
    protected static int threadCount = 0;
    private byte[] readBuffer = new byte[2048];
    protected byte[] buffer = new byte[0];
    protected int bufferIndex = 0;
    protected InputStream in;
    protected OutputStream out;
    protected HTTPConnection conn;
    protected boolean isRequest;
    protected Connection conn2;
    protected HTTPThread request;
    protected boolean isWaiting;
    protected String host;
    protected int port;
    protected int contentLength = -1;
    protected byte transferEncoding = (byte)-1;
    protected String responseType = null;
    protected boolean connectionKeepAlive = false;
    protected boolean connectionClose = false;
    protected static final String[] ENCODING_STRING = new String[]{"chunked", "identity", "gzip", "compressed", "deflate"};
    protected static final byte ENCODING_CHUNKED = 0;
    protected static final byte ENCODING_IDENTITY = 1;
    protected static final byte ENCODING_GZIP = 2;
    protected static final byte ENCODING_COMPRESSED = 3;
    protected static final byte ENCODING_DEFLATE = 4;

    public HTTPThread(Connection conn2, InputStream in, OutputStream out, HTTPConnection conn, boolean isRequest, String host, int port) {
        super("TCP/IP Monitor HTTP Connection");
        this.conn2 = conn2;
        this.in = in;
        this.out = out;
        this.conn = conn;
        this.isRequest = isRequest;
        this.host = host;
        this.port = port;
        this.setName("HTTP (" + host + ":" + port + ") " + (isRequest ? "REQUEST" : "RESPONSE") + " " + threadCount++);
        this.setPriority(6);
        this.setDaemon(true);
        Trace.trace((byte)4, "Started: " + this);
    }

    public HTTPThread(Connection conn2, InputStream in, OutputStream out, HTTPConnection conn, boolean isRequest, String host, int port, HTTPThread request) {
        this(conn2, in, out, conn, isRequest, host, port);
        this.request = request;
    }

    protected static byte[] convert(byte[] b) {
        if (b == null || b.length == 0) {
            return b;
        }
        int size = b.length;
        byte[] x = new byte[size + 2];
        System.arraycopy(b, 0, x, 0, size);
        x[size] = 13;
        x[size + 1] = 10;
        return x;
    }

    protected void fillBuffer() throws IOException {
        int n = this.in.read(this.readBuffer);
        if (n <= 0) {
            throw new IOException("End of input");
        }
        int len = this.buffer.length - this.bufferIndex;
        if (len < 0) {
            len = 0;
        }
        byte[] x = new byte[n + len];
        System.arraycopy(this.buffer, this.bufferIndex, x, 0, len);
        System.arraycopy(this.readBuffer, 0, x, len, n);
        this.bufferIndex = 0;
        this.buffer = x;
    }

    protected int getFirstCRLF() {
        int size = this.buffer.length;
        int i = this.bufferIndex + 1;
        while (i < size) {
            if (this.buffer[i - 1] == 13 && this.buffer[i] == 10) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void outputBytes(byte[] b, boolean isNew) throws IOException {
        this.out.write(b);
        if (this.isRequest) {
            this.conn.addRequest(b, isNew);
        } else {
            this.conn.addResponse(b, isNew);
        }
    }

    public void parseBody() throws IOException {
        Trace.trace((byte)4, "Parsing body for: " + this);
        if (this.responseType != null && ("204".equals(this.responseType) || "304".equals(this.responseType))) {
            this.setHTTPBody(new byte[0]);
            return;
        }
        if (this.isRequest) {
            if (this.contentLength != -1) {
                byte[] b2 = null;
                int b2Index = 0;
                if (this.contentLength < 0x100000) {
                    b2 = new byte[this.contentLength];
                }
                byte[] b = this.removeFromBuffer(Math.min(this.buffer.length, this.bufferIndex + this.contentLength));
                if (b2 != null) {
                    System.arraycopy(b, 0, b2, 0, b.length);
                    b2Index += b.length;
                }
                int bytesLeft = this.contentLength - b.length;
                Trace.trace((byte)4, "[Request] bytesLeft: " + bytesLeft);
                this.out.write(b);
                int n = 0;
                while (bytesLeft > 0) {
                    n = this.in.read(this.readBuffer, 0, Math.min(this.readBuffer.length, bytesLeft));
                    bytesLeft -= n;
                    if (b2 != null) {
                        System.arraycopy(this.readBuffer, 0, b2, b2Index, n);
                        b2Index += n;
                    }
                    this.out.write(this.readBuffer, 0, n);
                    Trace.trace((byte)4, "[Request] bytes read: " + n + " bytesLeft: " + bytesLeft);
                }
                if (b2 == null) {
                    b2 = Messages.errorContentSize.getBytes();
                }
                this.conn.addRequest(b2, false);
                this.setHTTPBody(b2);
            } else if (this.transferEncoding != -1 && this.transferEncoding != 1) {
                this.parseChunk();
            }
            Trace.trace((byte)4, "Done parsing request body for: " + this);
            return;
        }
        if (!this.isRequest && !this.connectionKeepAlive && this.contentLength == -1 && this.transferEncoding == -1) {
            Trace.trace((byte)4, "Assuming HTTP 1.0 for: " + this);
            int n = this.buffer.length - this.bufferIndex;
            byte[] b = this.readBytes(n);
            byte[] body = new byte[]{};
            while (n >= 0) {
                Trace.trace((byte)4, "Bytes read: " + n + " " + this);
                if (b != null && n > 0) {
                    byte[] x = null;
                    if (n == b.length) {
                        x = b;
                    } else {
                        x = new byte[n];
                        System.arraycopy(b, 0, x, 0, n);
                    }
                    this.outputBytes(x, false);
                    byte[] temp = new byte[body.length + x.length];
                    System.arraycopy(body, 0, temp, 0, body.length);
                    System.arraycopy(x, 0, temp, body.length, x.length);
                    body = temp;
                }
                if (b == null || b.length < 2048) {
                    b = new byte[2048];
                }
                n = this.in.read(b);
                Thread.yield();
            }
            this.out.flush();
            this.setHTTPBody(body);
            return;
        }
        if (this.responseType != null && this.responseType.startsWith("1")) {
            this.setHTTPBody(new byte[0]);
            return;
        }
        if (this.transferEncoding != -1 && this.transferEncoding != 1) {
            this.parseChunk();
            return;
        }
        if (this.contentLength != -1) {
            byte[] b2 = null;
            int b2Index = 0;
            if (this.contentLength < 0x100000) {
                b2 = new byte[this.contentLength];
            }
            byte[] b = this.removeFromBuffer(Math.min(this.buffer.length, this.bufferIndex + this.contentLength));
            if (b2 != null) {
                System.arraycopy(b, 0, b2, 0, b.length);
                b2Index += b.length;
            }
            int bytesLeft = this.contentLength - b.length;
            Trace.trace((byte)4, "bytesLeft: " + bytesLeft);
            this.out.write(b);
            int n = 0;
            while (bytesLeft > 0) {
                n = this.in.read(this.readBuffer, 0, Math.min(this.readBuffer.length, bytesLeft));
                bytesLeft -= n;
                if (b2 != null) {
                    System.arraycopy(this.readBuffer, 0, b2, b2Index, n);
                    b2Index += n;
                }
                Trace.trace((byte)4, "bytes read: " + n + " bytesLeft: " + bytesLeft);
                this.out.write(this.readBuffer, 0, n);
            }
            if (b2 == null) {
                b2 = Messages.errorContentSize.getBytes();
            }
            if (this.isRequest) {
                this.conn.addRequest(b2, false);
            } else {
                this.conn.addResponse(b2, false);
            }
            this.setHTTPBody(b2);
            return;
        }
        Trace.trace((byte)4, "Unknown body for: " + this);
    }

    public void parseChunk() throws IOException {
        byte[] b;
        Trace.trace((byte)4, "Parsing chunk for: " + this);
        boolean done = false;
        byte[] body = new byte[]{};
        while (!done) {
            b = this.readLine();
            String s = new String(b);
            Trace.trace((byte)4, "Chunk-length: " + s);
            int index = s.indexOf(" ");
            int length = -1;
            try {
                if (index > 0) {
                    s = s.substring(0, index);
                }
                length = Integer.parseInt(s.trim(), 16);
            }
            catch (Exception e) {
                Trace.trace((byte)4, "Error chunk for: " + this, e);
            }
            this.outputBytes(b, false);
            if (length <= 0) {
                done = true;
                continue;
            }
            b = this.readBytes(length + 2);
            this.outputBytes(b, false);
            byte[] temp = new byte[body.length + b.length - 2];
            System.arraycopy(body, 0, temp, 0, body.length);
            System.arraycopy(b, 0, temp, body.length, b.length - 2);
            body = temp;
        }
        b = this.readLine();
        while (b.length > 2) {
            this.outputBytes(b, false);
            b = this.readLine();
        }
        this.outputBytes(b, false);
        this.setHTTPBody(body);
    }

    public void parseHeader() throws IOException {
        Trace.trace((byte)4, "Parsing header for: " + this);
        boolean isFirstLine = true;
        boolean isNew = true;
        byte[] b = this.readLine();
        while (b.length > 5) {
            Trace.trace((byte)4, "Parsing header line: '" + new String(b) + "'");
            if (isFirstLine) {
                String s = new String(b);
                if (this.isRequest) {
                    this.setLabel(s);
                    isNew = false;
                }
                if (!this.isRequest) {
                    int index1 = s.indexOf(32);
                    int index2 = s.indexOf(32, index1 + 1);
                    try {
                        this.responseType = s.substring(index1 + 1, index2).trim();
                        Trace.trace((byte)4, "Response Type: " + this + " " + this.responseType);
                    }
                    catch (Exception e) {
                        Trace.trace((byte)4, "Error parsing response type for: " + this, e);
                    }
                    if (this.responseType != null && this.responseType.equals("100")) {
                        this.outputBytes(b, isNew);
                        isNew = false;
                        b = this.readLine();
                        this.outputBytes(b, false);
                        b = this.readLine();
                        index1 = s.indexOf(32);
                        index2 = s.indexOf(32, index1 + 1);
                        try {
                            this.responseType = s.substring(index1 + 1, index2).trim();
                            Trace.trace((byte)4, "Response Type: " + this + " " + this.responseType);
                        }
                        catch (Exception e) {
                            Trace.trace((byte)4, "Error parsing response type for: " + this, e);
                        }
                    }
                }
                isFirstLine = false;
            }
            b = this.translateHeaderLine(b);
            this.outputBytes(b, isNew);
            isNew = false;
            b = this.readLine();
        }
        Trace.trace((byte)4, "Parsing final header line: '" + new String(b) + "'");
        this.outputBytes(b, false);
        Request rr = this.conn.getRequestResponse(this.isRequest);
        Trace.trace((byte)4, "Setting header length: " + rr.getRequest(3).length);
        this.setHTTPHeader(rr);
    }

    protected byte[] readBytes(int n) throws IOException {
        Trace.trace((byte)4, "readBytes() " + n + " for: " + this);
        while (this.buffer.length - this.bufferIndex < n) {
            this.fillBuffer();
        }
        return this.removeFromBuffer(this.bufferIndex + n);
    }

    protected byte[] readLine() throws IOException {
        Trace.trace((byte)4, "readLine() for: " + this);
        int n = this.getFirstCRLF();
        while (n < 0) {
            this.fillBuffer();
            n = this.getFirstCRLF();
        }
        return this.removeFromBuffer(n + 1);
    }

    protected byte[] removeFromBuffer(int n) {
        byte[] b = new byte[n - this.bufferIndex];
        System.arraycopy(this.buffer, this.bufferIndex, b, 0, n - this.bufferIndex);
        if (this.buffer.length > 4096 || this.bufferIndex > 2048) {
            int size = this.buffer.length;
            byte[] x = new byte[size - n];
            System.arraycopy(this.buffer, n, x, 0, size - n);
            this.buffer = x;
            this.bufferIndex = 0;
        } else {
            this.bufferIndex = n;
        }
        return b;
    }

    public void run() {
        try {
            block11: {
                try {
                    while (true) {
                        this.contentLength = -1;
                        this.transferEncoding = (byte)-1;
                        this.connectionKeepAlive = false;
                        this.connectionClose = false;
                        this.parseHeader();
                        this.parseBody();
                        if (this.isRequest && this.connectionKeepAlive) {
                            this.waitForResponse();
                        }
                        Trace.trace((byte)4, "Done HTTP request for " + this + " " + this.connectionKeepAlive);
                        if (!(this.isRequest || this.request.connectionKeepAlive && !this.connectionClose)) {
                            this.conn2.close();
                            if (this.request.connectionKeepAlive && this.connectionClose) {
                                this.request.connectionKeepAlive = false;
                            }
                            this.notifyRequest();
                            break;
                        }
                        if (!this.isRequest) {
                            this.notifyRequest();
                        }
                        Thread.yield();
                    }
                }
                catch (IOException e) {
                    Trace.trace((byte)4, "End of buffer for: " + this, e);
                    if (this.isRequest) break block11;
                    try {
                        this.request.connectionKeepAlive = false;
                        this.request.conn2.close();
                        this.notifyRequest();
                    }
                    catch (Exception exception) {
                        Trace.trace((byte)4, "Error closing request in response to error: " + this, e);
                    }
                }
            }
            this.out.write(this.buffer, this.bufferIndex, this.buffer.length - this.bufferIndex);
            this.out.flush();
        }
        catch (Exception e) {
            Trace.trace((byte)4, "Error in: " + this, e);
        }
        Trace.trace((byte)4, "Closing thread " + this);
    }

    protected void setLabel(String s) {
        try {
            int index1 = s.indexOf(32);
            if (index1 < 0 || index1 > 15) {
                return;
            }
            int index2 = s.indexOf(32, index1 + 1);
            if (index2 < 0) {
                return;
            }
            this.conn.setLabel(s.substring(index1 + 1, index2), true);
        }
        catch (Exception exception) {}
    }

    protected byte[] translateHeaderLine(byte[] b) {
        String s = new String(b);
        if (this.isRequest && s.startsWith("Host: ")) {
            String t = "Host: " + this.host;
            if (this.port != 80) {
                t = String.valueOf(t) + ":" + this.port;
            }
            return HTTPThread.convert(t.getBytes());
        }
        if (s.toLowerCase().startsWith("content-length: ")) {
            try {
                this.contentLength = Integer.parseInt(s.substring(16).trim());
                Trace.trace((byte)4, "Content length: " + this + " " + this.contentLength);
            }
            catch (Exception e) {
                Trace.trace((byte)4, "Content length error", e);
            }
        } else if (s.startsWith("Connection: ")) {
            try {
                String t = s.substring(11).trim();
                if (t.equalsIgnoreCase("Keep-Alive")) {
                    this.connectionKeepAlive = true;
                }
                if (t.equalsIgnoreCase("close")) {
                    this.connectionClose = true;
                }
                Trace.trace((byte)4, "Keep alive: " + this.connectionKeepAlive);
            }
            catch (Exception e) {
                Trace.trace((byte)4, "Error getting Connection: from header", e);
            }
        } else if (s.startsWith("Transfer-Encoding: ")) {
            String t = s.substring(19).trim();
            int size = ENCODING_STRING.length;
            int i = 0;
            while (i < size) {
                if (ENCODING_STRING[i].equalsIgnoreCase(t)) {
                    this.transferEncoding = (byte)i;
                    Trace.trace((byte)4, "Transfer encoding: " + ENCODING_STRING[i]);
                }
                ++i;
            }
        }
        return b;
    }

    protected void close() {
        try {
            Trace.trace((byte)4, "Closing: " + this);
            this.out.close();
        }
        catch (Exception e) {
            Trace.trace((byte)4, "Error closing connection " + this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForResponse() {
        Trace.trace((byte)4, "Waiting for response " + this);
        HTTPThread hTTPThread = this;
        synchronized (hTTPThread) {
            try {
                this.isWaiting = true;
                this.wait();
            }
            catch (Exception e) {
                Trace.trace((byte)4, "Error in waitForResponse() " + this, e);
            }
            this.isWaiting = false;
        }
        Trace.trace((byte)4, "Done waiting for response " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRequest() {
        Trace.trace((byte)4, "Notifying request " + this);
        while (this.request.connectionKeepAlive && !this.request.isWaiting) {
            Trace.trace((byte)4, "Waiting for request " + this);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        HTTPThread hTTPThread = this.request;
        synchronized (hTTPThread) {
            try {
                this.request.notify();
            }
            catch (Exception e) {
                Trace.trace((byte)4, "Error in notifyRequest() " + this, e);
            }
        }
        Trace.trace((byte)4, "Done notifying request " + this);
    }

    protected void setHTTPHeader(Request rr) {
        if (this.isRequest) {
            byte[] b = rr.getRequest(3);
            byte[] h = new byte[b.length];
            System.arraycopy(b, 0, h, 0, b.length);
            rr.setProperty("request-header", h);
        } else {
            byte[] b = rr.getResponse(3);
            byte[] h = new byte[b.length];
            System.arraycopy(b, 0, h, 0, b.length);
            rr.setProperty("response-header", h);
        }
    }

    protected void setHTTPBody(byte[] b) {
        Request rr = this.conn.getRequestResponse(this.isRequest);
        if (this.isRequest) {
            rr.setProperty("request-body", b);
        } else {
            rr.setProperty("response-body", b);
        }
    }
}

