/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.hyperlink;

import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.hyperlink.URLFileHyperlink;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

class TaglibJarHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private IPath fZipFilePath;

    public TaglibJarHyperlink(IRegion region, IPath zipFilePath) {
        this.fRegion = region;
        this.fZipFilePath = zipFilePath;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return this.fZipFilePath.toString();
    }

    public void open() {
        URLFileHyperlink.StorageEditorInput input = new URLFileHyperlink.StorageEditorInput(new ZipStorage(this.fZipFilePath.toFile(), "META-INF/taglib.tld"));
        try {
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
            if (descriptor != null) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)descriptor.getId(), (boolean)true);
            }
        }
        catch (PartInitException e) {
            Logger.log(202, e.getMessage(), e);
        }
    }

    static class ZipStorage
    implements IStorage {
        File fFile = null;
        String fEntryName = null;

        ZipStorage(File file, String entryName) {
            this.fFile = file;
            this.fEntryName = entryName;
        }

        public InputStream getContents() throws CoreException {
            InputStream stream = null;
            try {
                ZipFile file = new ZipFile(this.fFile);
                ZipEntry entry = file.getEntry(this.fEntryName);
                stream = file.getInputStream(entry);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, JSPUIPlugin.getDefault().getBundle().getSymbolicName(), 4, this.getFullPath().toString(), (Throwable)e));
            }
            return stream;
        }

        public IPath getFullPath() {
            return new Path(String.valueOf(this.fFile.getAbsolutePath()) + '/' + this.fEntryName);
        }

        public String getName() {
            return this.fEntryName;
        }

        public boolean isReadOnly() {
            return true;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }
}

