/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;
import org.eclipse.jst.j2ee.internal.wizard.ImportUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class J2EEUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.jst.j2ee.ui";
    private static J2EEUIPlugin plugin;
    private static IPath location;

    public J2EEUIPlugin() {
        plugin = this;
    }

    public static J2EEUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IPath getInstallLocation() {
        if (location == null) {
            URL url = J2EEUIPlugin.getInstallURL();
            try {
                String installLocation = ((PlatformURLConnection)url.openConnection()).getURLAsLocal().getFile();
                location = new Path(installLocation);
            }
            catch (IOException e) {
                Logger.getLogger().logWarning(String.valueOf(J2EEPluginResourceHandler.getString((String)"Install_Location_Error_", (Object[])new Object[]{url})) + e);
            }
        }
        return location;
    }

    public static URL getInstallURL() {
        return J2EEUIPlugin.getDefault().getBundle().getEntry("/");
    }

    public static String getArchiveDefaultProjectName(Archive anArchive) {
        if (anArchive == null) {
            return null;
        }
        int type = J2EEUIPlugin.getArchiveType(anArchive);
        return J2EEUIPlugin.getTypeDefaultProjectName(anArchive.getURI(), type);
    }

    public static String getArchiveDefaultUtilProjectName(Archive anArchive) {
        if (anArchive == null) {
            return null;
        }
        int type = J2EEUIPlugin.getArchiveType(anArchive);
        return J2EEUIPlugin.getTypeDefaultUtilProjectName(anArchive.getName(), type);
    }

    public static String getArchiveDefaultProjectName(Archive anArchive, HashSet moduleNames) {
        if (anArchive == null) {
            return null;
        }
        int type = J2EEUIPlugin.getArchiveType(anArchive);
        return J2EEUIPlugin.getTypeDefaultProjectName(anArchive.getURI(), type, moduleNames);
    }

    public static int getArchiveType(Archive anArchive) {
        int type = 0;
        try {
            try {
                if (anArchive.isEJBJarFile()) {
                    type = 2;
                } else if (anArchive.isWARFile()) {
                    type = 3;
                } else if (anArchive.isApplicationClientFile()) {
                    type = 4;
                } else if (anArchive.isRARFile()) {
                    type = 5;
                } else if (anArchive.isEARFile()) {
                    type = 1;
                }
            }
            catch (Exception exception) {}
        }
        finally {
            if (anArchive != null) {
                anArchive.close();
            }
        }
        return type;
    }

    public static String getTypeDefaultProjectName(String text, int type) {
        Path path = new Path(text);
        text = path.makeRelative().removeFileExtension().lastSegment();
        boolean exists = false;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(text);
        if (project != null && project.exists()) {
            exists = true;
        }
        if (exists && text.toLowerCase().indexOf(ImportUtil.SUFFIXES[type].toLowerCase()) == -1) {
            text = String.valueOf(text) + ImportUtil.SUFFIXES[type];
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int j = 1;
        while (j < 10) {
            boolean found = false;
            String iteratedProjectName = String.valueOf(text) + (j == 1 ? "" : Integer.toString(j));
            int i = 0;
            while (!found && i < projects.length) {
                if (projects[i].getName().equalsIgnoreCase(iteratedProjectName)) {
                    found = true;
                }
                ++i;
            }
            if (!found) {
                return iteratedProjectName;
            }
            ++j;
        }
        return text;
    }

    private static String getTypeDefaultProjectName(String text, int type, HashSet moduleNames) {
        Path path = new Path(text);
        text = path.makeRelative().removeFileExtension().lastSegment();
        boolean isValidName = moduleNames.add(text);
        boolean exists = false;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(text);
        if (project != null && project.exists()) {
            exists = true;
        }
        if (!isValidName || exists && text.toLowerCase().indexOf(ImportUtil.SUFFIXES[type].toLowerCase()) == -1) {
            text = String.valueOf(text) + ImportUtil.SUFFIXES[type];
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int j = 1;
        while (j < 10) {
            boolean found = false;
            String iteratedProjectName = String.valueOf(text) + (j == 1 ? "" : Integer.toString(j));
            int i = 0;
            while (!found && i < projects.length) {
                if (projects[i].getName().equalsIgnoreCase(iteratedProjectName)) {
                    found = true;
                }
                ++i;
            }
            if (!found) {
                return iteratedProjectName;
            }
            ++j;
        }
        return text;
    }

    private static String getTypeDefaultUtilProjectName(String text, int type) {
        int i = (text = text.substring(text.lastIndexOf(File.separator) + 1)).lastIndexOf(46);
        if (i > 0) {
            text = text.substring(0, i);
        }
        if (text.toLowerCase().indexOf(ImportUtil.SUFFIXES[type].toLowerCase()) == -1) {
            text = String.valueOf(text) + ImportUtil.SUFFIXES[type];
        }
        IProject[] projects = J2EEUIPlugin.getWorkspace().getRoot().getProjects();
        int j = 0;
        while (j < 10) {
            boolean found = false;
            String iteratedProjectName = String.valueOf(text) + (j == 0 ? "" : Integer.toString(j));
            i = 0;
            while (!found && i < projects.length) {
                if (projects[i].getName().equalsIgnoreCase(iteratedProjectName)) {
                    found = true;
                }
                ++i;
            }
            if (!found) {
                return iteratedProjectName;
            }
            ++j;
        }
        return text;
    }

    public Image getImage(String key) {
        ImageDescriptor descriptor;
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if ((image == null || image.isDisposed()) && (descriptor = this.getImageDescriptor(key)) != null) {
            image = descriptor.createImage();
            imageRegistry.put(key, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        URL gifImageURL = this.getImageURL(key);
        if (gifImageURL != null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
        }
        return imageDescriptor;
    }

    private URL getImageURL(String key) {
        return J2EEPlugin.getImageURL((String)key, (Bundle)this.getBundle());
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return J2EEUIPlugin.getPluginWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbench getPluginWorkbench() {
        return J2EEUIPlugin.getDefault().getWorkbench();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = J2EEUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IStructuredSelection getCurrentSelection() {
        ISelection selection;
        IWorkbenchWindow window = J2EEUIPlugin.getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public static void logError(int aCode, String aMessage, Throwable anException) {
        J2EEUIPlugin.getDefault().getLog().log(J2EEUIPlugin.createErrorStatus(aCode, aMessage, anException));
    }

    public static void log(int severity, int aCode, String aMessage, Throwable exception) {
        J2EEUIPlugin.log(J2EEUIPlugin.createStatus(severity, aCode, aMessage, exception));
    }

    public static void log(IStatus aStatus) {
        J2EEUIPlugin.getDefault().getLog().log(aStatus);
    }

    public static IStatus createStatus(int severity, int aCode, String aMessage, Throwable exception) {
        return new Status(severity, PLUGIN_ID, aCode, aMessage != null ? aMessage : "No message.", exception);
    }

    public static IStatus createErrorStatus(int aCode, String aMessage, Throwable exception) {
        return J2EEUIPlugin.createStatus(4, aCode, aMessage, exception);
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, PLUGIN_ID, message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return J2EEUIPlugin.createStatus(severity, message, null);
    }

    public static void logError(Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(J2EEUIPlugin.createStatus(4, exception.getMessage(), exception));
    }

    public static void logError(CoreException exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(exception.getStatus());
    }
}

